/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.filters;

import java.io.IOException;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.DelegatingAuthenticationEntryPoint;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class AtlasDelegatingAuthenticationEntryPoint
extends DelegatingAuthenticationEntryPoint {
    public static final String SESSION_TIMEOUT = "Session Timeout";
    private static final Logger LOG = LoggerFactory.getLogger(AtlasDelegatingAuthenticationEntryPoint.class);

    public AtlasDelegatingAuthenticationEntryPoint(LinkedHashMap<RequestMatcher, AuthenticationEntryPoint> entryPoints) {
        super(entryPoints);
        if (LOG.isDebugEnabled()) {
            LOG.info("AtlasDelegatingAuthenticationEntryPoint-AjaxAwareAuthenticationEntryPoint(): constructor");
        }
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException {
        String ajaxRequestHeader = request.getHeader("X-REQUESTED-WITH");
        if (ajaxRequestHeader != null && "XMLHttpRequest".equalsIgnoreCase(ajaxRequestHeader)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("commence() AJAX request. Authentication required. Returning 401. URL=" + request.getRequestURI());
            }
            response.sendError(419, SESSION_TIMEOUT);
        } else {
            response.sendError(401, authException.getMessage());
        }
    }
}

