/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.security;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.atlas.web.security.PamPrincipal;
import org.jvnet.libpam.PAM;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.UnixUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PamLoginModule
implements LoginModule {
    private static final Logger LOG = LoggerFactory.getLogger(PamLoginModule.class);
    public static final String SERVICE_KEY = "service";
    private PAM pam;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, ?> options;
    private String username;
    private String password;
    private boolean authSucceeded = false;
    private PamPrincipal principal;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.options = new HashMap(options);
    }

    @Override
    public boolean login() throws LoginException {
        this.initializePam();
        this.obtainUserAndPassword();
        return this.performLogin();
    }

    private void initializePam() throws LoginException {
        String service = (String)this.options.get(SERVICE_KEY);
        if (service == null) {
            throw new LoginException("Error: PAM service was not defined");
        }
        this.createPam(service);
    }

    private void createPam(String service) throws LoginException {
        try {
            this.pam = new PAM(service);
        }
        catch (PAMException ex) {
            LoginException le = new LoginException("Error initializing PAM");
            le.initCause(ex);
            throw le;
        }
    }

    private void obtainUserAndPassword() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available  to gather authentication information from the user");
        }
        try {
            NameCallback nameCallback = new NameCallback("username");
            PasswordCallback passwordCallback = new PasswordCallback("password", false);
            this.invokeCallbackHandler(nameCallback, passwordCallback);
            this.initUserName(nameCallback);
            this.initPassword(passwordCallback);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Searching for user " + nameCallback.getName());
            }
        }
        catch (IOException | UnsupportedCallbackException ex) {
            LoginException le = new LoginException("Error in callbacks");
            le.initCause(ex);
            throw le;
        }
    }

    private void invokeCallbackHandler(NameCallback nameCallback, PasswordCallback passwordCallback) throws IOException, UnsupportedCallbackException {
        Callback[] callbacks = new Callback[]{nameCallback, passwordCallback};
        this.callbackHandler.handle(callbacks);
    }

    private void initUserName(NameCallback nameCallback) {
        this.username = nameCallback.getName();
    }

    private void initPassword(PasswordCallback passwordCallback) {
        char[] password = passwordCallback.getPassword();
        if (password != null) {
            this.password = new String(password);
        }
        passwordCallback.clearPassword();
    }

    private boolean performLogin() throws LoginException {
        try {
            UnixUser user = this.pam.authenticate(this.username, this.password);
            this.principal = new PamPrincipal(user);
            this.authSucceeded = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug("user " + this.username);
            }
            return true;
        }
        catch (PAMException ex) {
            FailedLoginException le = new FailedLoginException("Invalid username or password");
            le.initCause(ex);
            throw le;
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.authSucceeded) {
            return false;
        }
        if (this.subject.isReadOnly()) {
            this.cleanup();
            throw new LoginException("Subject is read-only");
        }
        Set<Principal> principals = this.subject.getPrincipals();
        if (!principals.contains(this.principal)) {
            principals.add(this.principal);
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.authSucceeded) {
            return false;
        }
        this.cleanup();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.subject.isReadOnly()) {
            this.cleanup();
            throw new LoginException("Subject is read-only");
        }
        this.subject.getPrincipals().remove(this.principal);
        this.cleanup();
        return true;
    }

    private void cleanup() {
        this.authSucceeded = false;
        this.username = null;
        this.password = null;
        this.principal = null;
        this.pam.dispose();
    }
}

