/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.RepeatStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.VertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.StartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ProfileStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.janusgraph.core.BaseVertexQuery;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphMultiVertexQuery;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexQuery;
import org.janusgraph.graphdb.query.JanusGraphPredicateUtils;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.query.vertex.BasicVertexCentricQueryBuilder;
import org.janusgraph.graphdb.tinkerpop.optimize.HasStepFolder;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphMultiQueryStep;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.optimize.MultiQueriable;
import org.janusgraph.graphdb.tinkerpop.profile.TP3ProfileWrapper;

public class JanusGraphVertexStep<E extends Element>
extends VertexStep<E>
implements HasStepFolder<Vertex, E>,
Profiling,
MultiQueriable<Vertex, E> {
    private boolean initialized = false;
    private boolean useMultiQuery = false;
    private boolean batchPropertyPrefetching = false;
    private Map<JanusGraphVertex, Iterable<? extends JanusGraphElement>> multiQueryResults = null;
    private QueryProfiler queryProfiler = QueryProfiler.NO_OP;
    private int txVertexCacheSize = 20000;
    private JanusGraphMultiQueryStep parentMultiQueryStep;
    private final List<HasContainer> hasContainers;
    private int limit;
    private final List<HasStepFolder.OrderEntry> orders = new ArrayList<HasStepFolder.OrderEntry>();

    public JanusGraphVertexStep(VertexStep<E> originalStep) {
        super(originalStep.getTraversal(), originalStep.getReturnClass(), originalStep.getDirection(), originalStep.getEdgeLabels());
        originalStep.getLabels().forEach(arg_0 -> ((JanusGraphVertexStep)this).addLabel(arg_0));
        this.hasContainers = new ArrayList<HasContainer>();
        this.limit = Integer.MAX_VALUE;
    }

    @Override
    public void setUseMultiQuery(boolean useMultiQuery) {
        this.useMultiQuery = useMultiQuery;
    }

    public void setBatchPropertyPrefetching(boolean batchPropertyPrefetching) {
        this.batchPropertyPrefetching = batchPropertyPrefetching;
    }

    public void setTxVertexCacheSize(int txVertexCacheSize) {
        this.txVertexCacheSize = txVertexCacheSize;
    }

    public <Q extends BaseVertexQuery> Q makeQuery(Q query) {
        query.labels(this.getEdgeLabels());
        query.direction(this.getDirection());
        for (HasContainer condition : this.hasContainers) {
            query.has(condition.getKey(), JanusGraphPredicateUtils.convert(condition.getBiPredicate()), condition.getValue());
        }
        for (HasStepFolder.OrderEntry order : this.orders) {
            query.orderBy(order.key, order.order);
        }
        if (this.limit != Integer.MAX_VALUE) {
            query.limit(this.limit);
        }
        ((BasicVertexCentricQueryBuilder)query).profiler(this.queryProfiler);
        return query;
    }

    private void initialize() {
        assert (!this.initialized);
        this.initialized = true;
        if (this.useMultiQuery) {
            this.setParentMultiQueryStep();
            if (!this.starts.hasNext()) {
                throw FastNoSuchElementException.instance();
            }
            ArrayList<Traverser.Admin<Vertex>> vertices = new ArrayList<Traverser.Admin<Vertex>>();
            this.starts.forEachRemaining(v -> vertices.add((Traverser.Admin<Vertex>)v));
            this.starts.add(vertices.iterator());
            this.initializeMultiQuery(vertices);
        }
    }

    private void initializeMultiQuery(List<Traverser.Admin<Vertex>> vertices) {
        Map<JanusGraphVertex, Iterable<JanusGraphElement>> results;
        assert (vertices.size() > 0);
        List<Object> parentStarts = new ArrayList();
        if (vertices.size() == 1 && this.parentMultiQueryStep != null) {
            parentStarts = this.parentMultiQueryStep.getCachedStarts();
        }
        JanusGraphMultiVertexQuery<? extends JanusGraphMultiVertexQuery> multiQuery = JanusGraphTraversalUtil.getTx(this.traversal).multiQuery(new JanusGraphVertex[0]);
        vertices.forEach(v -> multiQuery.addVertex((Vertex)v.get()));
        parentStarts.forEach(v -> multiQuery.addVertex((Vertex)v.get()));
        this.makeQuery(multiQuery);
        Map<JanusGraphVertex, Iterable<JanusGraphElement>> map = results = Vertex.class.isAssignableFrom(this.getReturnClass()) ? multiQuery.vertices() : multiQuery.edges();
        if (this.multiQueryResults == null) {
            this.multiQueryResults = results;
        } else {
            this.multiQueryResults.putAll(results);
        }
    }

    private void setParentMultiQueryStep() {
        Step parentStep;
        Step firstStep = this.traversal.getStartStep();
        while (firstStep instanceof StartStep || firstStep instanceof SideEffectStep) {
            firstStep = firstStep.getNextStep();
        }
        if (this.equals(firstStep) && JanusGraphTraversalUtil.isMultiQueryCompatibleStep(parentStep = this.traversal.getParent().asStep())) {
            RepeatStep repeatStep;
            List repeatEndSteps;
            Step parentPreviousStep = parentStep.getPreviousStep();
            if (parentStep instanceof RepeatStep && (repeatEndSteps = TraversalHelper.getStepsOfClass(RepeatStep.RepeatEndStep.class, (Traversal.Admin)(repeatStep = (RepeatStep)parentStep).getRepeatTraversal())).size() == 1) {
                parentPreviousStep = ((RepeatStep.RepeatEndStep)repeatEndSteps.get(0)).getPreviousStep();
            }
            if (parentPreviousStep instanceof ProfileStep) {
                parentPreviousStep = parentPreviousStep.getPreviousStep();
            }
            if (parentPreviousStep instanceof JanusGraphMultiQueryStep) {
                JanusGraphMultiQueryStep multiQueryStep;
                this.parentMultiQueryStep = multiQueryStep = (JanusGraphMultiQueryStep)parentPreviousStep;
            }
        }
    }

    protected Traverser.Admin<E> processNextStart() {
        if (!this.initialized) {
            this.initialize();
        }
        return super.processNextStart();
    }

    protected Iterator<E> flatMap(Traverser.Admin<Vertex> traverser) {
        Iterable<? extends JanusGraphElement> result;
        if (this.useMultiQuery) {
            if (this.multiQueryResults == null || !this.multiQueryResults.containsKey(traverser.get())) {
                this.initializeMultiQuery(Collections.singletonList(traverser));
            }
            result = this.multiQueryResults.get(traverser.get());
        } else {
            JanusGraphVertexQuery<? extends JanusGraphVertexQuery> query = this.makeQuery(JanusGraphTraversalUtil.getJanusGraphVertex(traverser).query());
            Iterable<JanusGraphElement> iterable = result = Vertex.class.isAssignableFrom(this.getReturnClass()) ? query.vertices() : query.edges();
        }
        if (this.batchPropertyPrefetching) {
            HashSet vertices = Sets.newHashSet();
            result.forEach(v -> {
                if (vertices.size() < this.txVertexCacheSize) {
                    vertices.add((Vertex)v);
                }
            });
            if (vertices.size() > 1) {
                JanusGraphMultiVertexQuery<? extends JanusGraphMultiVertexQuery> propertyMultiQuery = JanusGraphTraversalUtil.getTx(this.traversal).multiQuery(new JanusGraphVertex[0]);
                ((BasicVertexCentricQueryBuilder)((Object)propertyMultiQuery)).profiler(this.queryProfiler);
                propertyMultiQuery.addAllVertices(vertices).preFetch();
            }
        }
        return result.iterator();
    }

    public void reset() {
        super.reset();
        this.initialized = false;
    }

    public JanusGraphVertexStep<E> clone() {
        JanusGraphVertexStep clone = (JanusGraphVertexStep)super.clone();
        clone.initialized = false;
        return clone;
    }

    @Override
    public void addAll(Iterable<HasContainer> has) {
        HasStepFolder.splitAndP(this.hasContainers, has);
    }

    @Override
    public List<HasContainer> addLocalAll(Iterable<HasContainer> has) {
        throw new UnsupportedOperationException("addLocalAll is not supported for graph vertex step.");
    }

    @Override
    public void orderBy(String key, Order order) {
        this.orders.add(new HasStepFolder.OrderEntry(key, order));
    }

    @Override
    public void localOrderBy(List<HasContainer> hasContainers, String key, Order order) {
        throw new UnsupportedOperationException("localOrderBy is not supported for graph vertex step.");
    }

    @Override
    public void setLimit(int low, int high) {
        Preconditions.checkArgument((low == 0 ? 1 : 0) != 0, (Object)"Offset is not supported for properties step.");
        this.limit = high;
    }

    @Override
    public void setLocalLimit(List<HasContainer> hasContainers, int low, int high) {
        throw new UnsupportedOperationException("setLocalLimit is not supported for graph vertex step.");
    }

    @Override
    public int getLowLimit() {
        throw new UnsupportedOperationException("getLowLimit is not supported for properties step.");
    }

    @Override
    public int getLocalLowLimit(List<HasContainer> hasContainers) {
        throw new UnsupportedOperationException("getLocalLowLimit is not supported for properties step.");
    }

    @Override
    public int getHighLimit() {
        return this.limit;
    }

    @Override
    public int getLocalHighLimit(List<HasContainer> hasContainers) {
        throw new UnsupportedOperationException("getLocalHighLimit is not supported for graph vertex step.");
    }

    public String toString() {
        return this.hasContainers.isEmpty() ? super.toString() : StringFactory.stepString((Step)this, (Object[])new Object[]{this.hasContainers});
    }

    public void setMetrics(MutableMetrics metrics) {
        this.queryProfiler = new TP3ProfileWrapper(metrics);
    }
}

