/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.util;

import com.google.common.base.Preconditions;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.model.ByteBufferRange;
import com.netflix.astyanax.serializers.BooleanSerializer;
import com.netflix.astyanax.serializers.ByteBufferSerializer;
import com.netflix.astyanax.serializers.BytesArraySerializer;
import com.netflix.astyanax.serializers.DateSerializer;
import com.netflix.astyanax.serializers.DoubleSerializer;
import com.netflix.astyanax.serializers.IntegerSerializer;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.serializers.UUIDSerializer;
import com.netflix.astyanax.util.ByteBufferRangeImpl;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;

public class RangeBuilder {
    private static ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private static final int DEFAULT_MAX_SIZE = Integer.MAX_VALUE;
    private ByteBuffer start = EMPTY_BUFFER;
    private ByteBuffer end = EMPTY_BUFFER;
    private int limit = Integer.MAX_VALUE;
    private boolean reversed = false;

    @Deprecated
    public RangeBuilder setMaxSize(int count) {
        return this.setLimit(count);
    }

    public RangeBuilder setLimit(int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)("Invalid count in RangeBuilder : " + count));
        this.limit = count;
        return this;
    }

    @Deprecated
    public RangeBuilder setReversed() {
        this.reversed = true;
        return this;
    }

    public RangeBuilder setReversed(boolean reversed) {
        this.reversed = reversed;
        return this;
    }

    public RangeBuilder setStart(String value) {
        this.start = StringSerializer.get().toByteBuffer(value);
        return this;
    }

    public RangeBuilder setStart(byte[] value) {
        this.start = BytesArraySerializer.get().toByteBuffer(value);
        return this;
    }

    public RangeBuilder setStart(int value) {
        this.start = IntegerSerializer.get().toByteBuffer(value);
        return this;
    }

    public RangeBuilder setStart(long value) {
        this.start = LongSerializer.get().toByteBuffer(value);
        return this;
    }

    public RangeBuilder setStart(boolean value) {
        this.start = BooleanSerializer.get().toByteBuffer(value);
        return this;
    }

    public RangeBuilder setStart(ByteBuffer value) {
        this.start = ByteBufferSerializer.get().toByteBuffer(value);
        return this;
    }

    public RangeBuilder setStart(Date value) {
        this.start = DateSerializer.get().toByteBuffer(value);
        return this;
    }

    public RangeBuilder setStart(double value) {
        this.start = DoubleSerializer.get().toByteBuffer(value);
        return this;
    }

    public RangeBuilder setStart(UUID value) {
        this.start = UUIDSerializer.get().toByteBuffer(value);
        return this;
    }

    public <T> RangeBuilder setStart(T value, Serializer<T> serializer) {
        this.start = serializer.toByteBuffer(value);
        return this;
    }

    public RangeBuilder setEnd(String value) {
        this.end = StringSerializer.get().toByteBuffer(value);
        return this;
    }

    public RangeBuilder setEnd(byte[] value) {
        this.end = BytesArraySerializer.get().toByteBuffer(value);
        return this;
    }

    public RangeBuilder setEnd(int value) {
        this.end = IntegerSerializer.get().toByteBuffer(value);
        return this;
    }

    public RangeBuilder setEnd(long value) {
        this.end = LongSerializer.get().toByteBuffer(value);
        return this;
    }

    public RangeBuilder setEnd(boolean value) {
        this.end = BooleanSerializer.get().toByteBuffer(value);
        return this;
    }

    public RangeBuilder setEnd(ByteBuffer value) {
        this.end = ByteBufferSerializer.get().toByteBuffer(value);
        return this;
    }

    public RangeBuilder setEnd(Date value) {
        this.end = DateSerializer.get().toByteBuffer(value);
        return this;
    }

    public RangeBuilder setEnd(double value) {
        this.end = DoubleSerializer.get().toByteBuffer(value);
        return this;
    }

    public RangeBuilder setEnd(UUID value) {
        this.end = UUIDSerializer.get().toByteBuffer(value);
        return this;
    }

    public <T> RangeBuilder setEnd(T value, Serializer<T> serializer) {
        this.end = serializer.toByteBuffer(value);
        return this;
    }

    public ByteBufferRange build() {
        return new ByteBufferRangeImpl(RangeBuilder.clone(this.start), RangeBuilder.clone(this.end), this.limit, this.reversed);
    }

    public static ByteBuffer clone(ByteBuffer original) {
        ByteBuffer clone = ByteBuffer.allocate(original.capacity());
        original.rewind();
        clone.put(original);
        original.rewind();
        clone.flip();
        return clone;
    }
}

