/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool;

import com.netflix.astyanax.AuthenticationCredentials;
import com.netflix.astyanax.connectionpool.BadHostDetector;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.LatencyScoreStrategy;
import com.netflix.astyanax.connectionpool.OperationFilterFactory;
import com.netflix.astyanax.connectionpool.RetryBackoffStrategy;
import com.netflix.astyanax.connectionpool.SSLConnectionContext;
import com.netflix.astyanax.connectionpool.impl.HostSelectorStrategy;
import com.netflix.astyanax.partitioner.Partitioner;
import com.netflix.astyanax.tracing.OperationTracer;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public interface ConnectionPoolConfiguration {
    public LatencyScoreStrategy getLatencyScoreStrategy();

    public BadHostDetector getBadHostDetector();

    public int getPort();

    public String getName();

    public int getMaxConnsPerHost();

    public int getInitConnsPerHost();

    public int getMaxConns();

    public int getMaxTimeoutWhenExhausted();

    public int getMaxFailoverCount();

    public RetryBackoffStrategy getRetryBackoffStrategy();

    public HostSelectorStrategy getHostSelectorStrategy();

    public String getSeeds();

    public List<Host> getSeedHosts();

    public String getLocalDatacenter();

    public int getSocketTimeout();

    public int getConnectTimeout();

    public int getConnectionLimiterWindowSize();

    public int getConnectionLimiterMaxPendingCount();

    public int getLatencyAwareWindowSize();

    public float getLatencyAwareSentinelCompare();

    public float getLatencyAwareBadnessThreshold();

    public int getBlockedThreadThreshold();

    public float getMinHostInPoolRatio();

    public int getLatencyAwareUpdateInterval();

    public int getLatencyAwareResetInterval();

    public int getMaxPendingConnectionsPerHost();

    public int getMaxBlockedThreadsPerHost();

    public int getTimeoutWindow();

    public int getMaxTimeoutCount();

    public int getRetrySuspendWindow();

    public int getRetryMaxDelaySlice();

    public int getRetryDelaySlice();

    public int getMaxOperationsPerConnection();

    public AuthenticationCredentials getAuthenticationCredentials();

    public OperationFilterFactory getOperationFilterFactory();

    public OperationTracer getOperationTracer();

    public Partitioner getPartitioner();

    public SSLConnectionContext getSSLConnectionContext();

    public ScheduledExecutorService getMaintainanceScheduler();

    public ScheduledExecutorService getHostReconnectExecutor();

    public void initialize();

    public void shutdown();
}

