/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.test;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class TestDriver {
    private int nThreads;
    private Supplier<Integer> callsPerSecond;
    private ScheduledExecutorService executor;
    private Function<TestDriver, Void> callback;
    private volatile int delta;
    private AtomicLong callbackCounter = new AtomicLong();
    private long iterationCount = 100L;
    private long futuresTimeout = 0L;
    private TimeUnit futuresUnits = TimeUnit.MILLISECONDS;
    private ExecutorService futuresExecutor;
    private ArrayList<Event> events = Lists.newArrayList();
    private long startTime;
    private AtomicLong operationCounter = new AtomicLong(0L);

    public void start() {
        this.updateDelta();
        this.operationCounter.incrementAndGet();
        this.startTime = System.currentTimeMillis();
        for (int i = 0; i < this.nThreads; ++i) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    long startTime;
                    try {
                        Thread.sleep(new Random().nextInt(TestDriver.this.delta));
                    }
                    catch (InterruptedException e1) {
                        throw new RuntimeException(e1);
                    }
                    long nextTime = startTime = System.currentTimeMillis();
                    while (true) {
                        long waitTime;
                        TestDriver.this.operationCounter.incrementAndGet();
                        try {
                            if (TestDriver.this.iterationCount != 0L && TestDriver.this.callbackCounter.incrementAndGet() > TestDriver.this.iterationCount) {
                                return;
                            }
                            if (TestDriver.this.futuresTimeout == 0L) {
                                TestDriver.this.callback.apply((Object)TestDriver.this);
                            } else {
                                Future<?> f = TestDriver.this.futuresExecutor.submit(new Runnable(){

                                    @Override
                                    public void run() {
                                        TestDriver.this.callback.apply((Object)TestDriver.this);
                                    }
                                });
                                try {
                                    f.get(TestDriver.this.futuresTimeout, TestDriver.this.futuresUnits);
                                }
                                catch (Throwable t) {
                                    f.cancel(true);
                                }
                            }
                        }
                        catch (Throwable f) {
                            // empty catch block
                        }
                        if ((waitTime = (nextTime += (long)TestDriver.this.delta) - System.currentTimeMillis()) <= 0L) continue;
                        try {
                            Thread.sleep(waitTime);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
            });
        }
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                TestDriver.this.updateDelta();
            }
        }, 1L, 1L, TimeUnit.SECONDS);
        for (Event event : this.events) {
            event.addToExecutor(this.executor, this);
        }
    }

    public void updateDelta() {
        this.delta = 1000 * this.nThreads / (Integer)this.callsPerSecond.get();
    }

    public void stop() {
        this.executor.shutdownNow();
    }

    public void await() throws InterruptedException {
        this.executor.awaitTermination(1000L, TimeUnit.HOURS);
    }

    public long getCallCount() {
        return this.callbackCounter.get();
    }

    public long getRuntime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public long getOperationCount() {
        return this.operationCounter.get();
    }

    public static class Builder {
        private TestDriver driver = new TestDriver();

        public Builder withThreadCount(int nThreads) {
            this.driver.nThreads = nThreads;
            return this;
        }

        public Builder withCallsPerSecondSupplier(Supplier<Integer> callsPerSecond) {
            this.driver.callsPerSecond = callsPerSecond;
            return this;
        }

        public Builder withCallback(Function<TestDriver, Void> callback) {
            this.driver.callback = callback;
            return this;
        }

        public Builder withIterationCount(long iterationCount) {
            this.driver.iterationCount = iterationCount;
            return this;
        }

        public Builder withFutures(long timeout, TimeUnit units) {
            this.driver.futuresTimeout = timeout;
            this.driver.futuresUnits = units;
            return this;
        }

        public Builder withRecurringEvent(long delay, TimeUnit units, Function<TestDriver, Void> event) {
            this.driver.events.add(new RecurringEvent(event, delay, units));
            return this;
        }

        public TestDriver build() {
            this.driver.executor = Executors.newScheduledThreadPool(this.driver.nThreads + 10);
            if (this.driver.futuresTimeout != 0L) {
                this.driver.futuresExecutor = Executors.newScheduledThreadPool(this.driver.nThreads);
            }
            return this.driver;
        }
    }

    public static class RecurringEvent
    extends Event {
        private final long delay;
        private final TimeUnit units;

        public RecurringEvent(Function<TestDriver, Void> function, long delay, TimeUnit units) {
            super(function);
            this.delay = delay;
            this.units = units;
        }

        @Override
        public void addToExecutor(ScheduledExecutorService service, final TestDriver driver) {
            service.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    RecurringEvent.this.function.apply((Object)driver);
                }
            }, this.delay, this.delay, this.units);
        }
    }

    public static abstract class Event {
        protected Function<TestDriver, Void> function;

        public Event(Function<TestDriver, Void> function) {
            this.function = function;
        }

        public abstract void addToExecutor(ScheduledExecutorService var1, TestDriver var2);
    }
}

