/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift.ddl;

import com.google.common.collect.Maps;
import com.netflix.astyanax.ddl.ColumnDefinition;
import com.netflix.astyanax.ddl.ColumnFamilyDefinition;
import com.netflix.astyanax.ddl.FieldMetadata;
import com.netflix.astyanax.thrift.ThriftTypes;
import com.netflix.astyanax.thrift.ThriftUtils;
import com.netflix.astyanax.thrift.ddl.ThriftColumnDefinitionImpl;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.thrift.meta_data.FieldMetaData;

public class ThriftColumnFamilyDefinitionImpl
implements ColumnFamilyDefinition {
    private static final Map<String, FieldMetadata> fieldsMetadata = Maps.newHashMap();
    private CfDef cfDef;

    public ThriftColumnFamilyDefinitionImpl() {
        this.cfDef = new CfDef();
    }

    public ThriftColumnFamilyDefinitionImpl(CfDef cfDef) {
        this.cfDef = cfDef;
    }

    public CfDef getThriftColumnFamilyDefinition() {
        return this.cfDef;
    }

    public ColumnFamilyDefinition setComment(String comment) {
        this.cfDef.setComment(comment);
        return this;
    }

    public String getComment() {
        return this.cfDef.getComment();
    }

    public ColumnFamilyDefinition setKeyspace(String keyspace) {
        this.cfDef.setKeyspace(keyspace);
        return this;
    }

    public String getKeyspace() {
        return this.cfDef.getKeyspace();
    }

    @Deprecated
    public ColumnFamilyDefinition setMemtableFlushAfterMins(Integer value) {
        throw new RuntimeException("API Remove in Cassandra 1.0");
    }

    @Deprecated
    public Integer getMemtableFlushAfterMins() {
        throw new RuntimeException("API Remove in Cassandra 1.0");
    }

    @Deprecated
    public ColumnFamilyDefinition setMemtableOperationsInMillions(Double value) {
        throw new RuntimeException("API Remove in Cassandra 1.0");
    }

    @Deprecated
    public Double getMemtableOperationsInMillions() {
        throw new RuntimeException("API Remove in Cassandra 1.0");
    }

    @Deprecated
    public ColumnFamilyDefinition setMemtableThroughputInMb(Integer value) {
        throw new RuntimeException("API Remove in Cassandra 1.0");
    }

    public ColumnFamilyDefinition setMergeShardsChance(Double value) {
        this.cfDef.setMerge_shards_chance(value.doubleValue());
        return this;
    }

    public ColumnFamilyDefinition setMinCompactionThreshold(Integer value) {
        if (value != null) {
            this.cfDef.setMin_compaction_threshold(value.intValue());
        }
        return this;
    }

    public ColumnFamilyDefinition setName(String name) {
        this.cfDef.setName(name);
        return this;
    }

    public String getName() {
        return this.cfDef.getName();
    }

    public ColumnFamilyDefinition setReadRepairChance(Double value) {
        if (value != null) {
            this.cfDef.setRead_repair_chance(value.doubleValue());
        }
        return this;
    }

    public ColumnFamilyDefinition setReplicateOnWrite(Boolean value) {
        if (value != null) {
            this.cfDef.setReplicate_on_write(value.booleanValue());
        }
        return this;
    }

    public ColumnFamilyDefinition setRowCacheProvider(String value) {
        this.cfDef.setRow_cache_provider(value);
        return this;
    }

    public ColumnFamilyDefinition setRowCacheSavePeriodInSeconds(Integer value) {
        if (value != null) {
            this.cfDef.setRow_cache_save_period_in_seconds(value.intValue());
        }
        return this;
    }

    public ColumnFamilyDefinition setRowCacheSize(Double size) {
        if (size != null) {
            this.cfDef.setRow_cache_size(size.doubleValue());
        }
        return this;
    }

    public ColumnFamilyDefinition setComparatorType(String value) {
        this.cfDef.setComparator_type(value);
        return this;
    }

    public String getComparatorType() {
        return this.cfDef.getComparator_type();
    }

    public ColumnFamilyDefinition setDefaultValidationClass(String value) {
        this.cfDef.setDefault_validation_class(value);
        return this;
    }

    public String getDefaultValidationClass() {
        return this.cfDef.getDefault_validation_class();
    }

    public ColumnFamilyDefinition setId(Integer id) {
        this.cfDef.setId(id.intValue());
        return this;
    }

    public Integer getId() {
        return this.cfDef.getId();
    }

    public ColumnFamilyDefinition setKeyAlias(ByteBuffer alias) {
        this.cfDef.setKey_alias(alias);
        return this;
    }

    public ByteBuffer getKeyAlias() {
        if (this.cfDef.getKey_alias() == null) {
            return null;
        }
        return ByteBuffer.wrap(this.cfDef.getKey_alias());
    }

    public ColumnFamilyDefinition setKeyCacheSavePeriodInSeconds(Integer value) {
        if (value != null) {
            this.cfDef.setKey_cache_save_period_in_seconds(value.intValue());
        }
        return this;
    }

    public Integer getKeyCacheSavePeriodInSeconds() {
        return this.cfDef.getKey_cache_save_period_in_seconds();
    }

    public ColumnFamilyDefinition setKeyCacheSize(Double keyCacheSize) {
        if (keyCacheSize != null) {
            this.cfDef.setKey_cache_size(keyCacheSize.doubleValue());
        }
        return this;
    }

    public ColumnFamilyDefinition setKeyValidationClass(String keyValidationClass) {
        this.cfDef.setKey_validation_class(keyValidationClass);
        return this;
    }

    public String getKeyValidationClass() {
        return this.cfDef.getKey_validation_class();
    }

    public ColumnFamilyDefinition addColumnDefinition(ColumnDefinition columnDef) {
        ArrayList<ColumnDef> columns = this.cfDef.getColumn_metadata();
        if (columns == null) {
            columns = new ArrayList<ColumnDef>();
            this.cfDef.setColumn_metadata(columns);
        }
        columns.add(((ThriftColumnDefinitionImpl)columnDef).getThriftColumnDefinition());
        return this;
    }

    public List<ColumnDefinition> getColumnDefinitionList() {
        ArrayList<ColumnDefinition> list = new ArrayList<ColumnDefinition>();
        List cdefs = this.cfDef.getColumn_metadata();
        if (cdefs != null) {
            for (ColumnDef cdef : cdefs) {
                list.add(new ThriftColumnDefinitionImpl(cdef));
            }
        }
        return list;
    }

    public void clearColumnDefinitionList() {
        this.cfDef.setColumn_metadata(new ArrayList());
    }

    @Deprecated
    public Integer getMemtableThroughputInMb() {
        throw new RuntimeException("API Remove in Cassandra 1.0");
    }

    public Double getMergeShardsChance() {
        return this.cfDef.merge_shards_chance;
    }

    public Integer getMinCompactionThreshold() {
        return this.cfDef.min_compaction_threshold;
    }

    public Double getReadRepairChance() {
        return this.cfDef.read_repair_chance;
    }

    public Boolean getReplicateOnWrite() {
        return this.cfDef.replicate_on_write;
    }

    public String getRowCacheProvider() {
        return this.cfDef.row_cache_provider;
    }

    public Integer getRowCacheSavePeriodInSeconds() {
        return this.cfDef.row_cache_save_period_in_seconds;
    }

    public Double getRowCacheSize() {
        return this.cfDef.row_cache_size;
    }

    public Double getKeyCacheSize() {
        return this.cfDef.key_cache_size;
    }

    public Collection<String> getFieldNames() {
        return fieldsMetadata.keySet();
    }

    public Object getFieldValue(String name) {
        return this.cfDef.getFieldValue(CfDef._Fields.valueOf((String)name));
    }

    public ColumnFamilyDefinition setFieldValue(String name, Object value) {
        this.cfDef.setFieldValue(CfDef._Fields.valueOf((String)name), value);
        return this;
    }

    public ColumnDefinition makeColumnDefinition() {
        return new ThriftColumnDefinitionImpl();
    }

    public Collection<FieldMetadata> getFieldsMetadata() {
        return fieldsMetadata.values();
    }

    public ColumnFamilyDefinition setMaxCompactionThreshold(Integer value) {
        if (value != null) {
            this.cfDef.setMax_compaction_threshold(value.intValue());
        }
        return this;
    }

    public Integer getMaxCompactionThreshold() {
        return this.cfDef.getMax_compaction_threshold();
    }

    public ColumnFamilyDefinition setCompactionStrategy(String strategy) {
        this.cfDef.setCompaction_strategy(strategy);
        return this;
    }

    public String getCompactionStrategy() {
        return this.cfDef.getCompaction_strategy();
    }

    public ColumnFamilyDefinition setCompactionStrategyOptions(Map<String, String> options) {
        this.cfDef.setCompaction_strategy_options(options);
        return this;
    }

    public Map<String, String> getCompactionStrategyOptions() {
        return this.cfDef.getCompaction_strategy_options();
    }

    public ColumnFamilyDefinition setCompressionOptions(Map<String, String> options) {
        this.cfDef.setCompression_options(options);
        return this;
    }

    public Map<String, String> getCompressionOptions() {
        return this.cfDef.getCompression_options();
    }

    public ColumnFamilyDefinition setBloomFilterFpChance(Double chance) {
        if (chance != null) {
            this.cfDef.setBloom_filter_fp_chance(chance.doubleValue());
        }
        return this;
    }

    public Double getBloomFilterFpChance() {
        return this.cfDef.getBloom_filter_fp_chance();
    }

    public ColumnFamilyDefinition setCaching(String caching) {
        this.cfDef.setCaching(caching);
        return this;
    }

    public String getCaching() {
        return this.cfDef.getCaching();
    }

    public ColumnFamilyDefinition setLocalReadRepairChance(Double value) {
        if (value != null) {
            this.cfDef.setDclocal_read_repair_chance(value.doubleValue());
        }
        return this;
    }

    public Double getLocalReadRepairChance() {
        return this.cfDef.getDclocal_read_repair_chance();
    }

    public ColumnFamilyDefinition setGcGraceSeconds(Integer seconds) {
        if (seconds != null) {
            this.cfDef.setGc_grace_seconds(seconds.intValue());
        }
        return this;
    }

    public Integer getGcGraceSeconds() {
        return this.cfDef.getGc_grace_seconds();
    }

    public void setFields(Map<String, Object> options) {
        for (Map.Entry<String, FieldMetadata> field : fieldsMetadata.entrySet()) {
            String fieldName = field.getKey();
            if (!options.containsKey(fieldName)) continue;
            if (fieldName.equals("column_metadata")) {
                Map columns = (Map)options.get("column_metadata");
                for (Map.Entry column : columns.entrySet()) {
                    ThriftColumnDefinitionImpl columnDef = new ThriftColumnDefinitionImpl();
                    columnDef.setName(((String)column.getKey()).toString());
                    columnDef.setFields((Map)column.getValue());
                    this.addColumnDefinition(columnDef);
                }
                continue;
            }
            this.setFieldValue(field.getValue().getName(), options.get(fieldName));
        }
    }

    public Properties getProperties() throws Exception {
        return ThriftUtils.getPropertiesFromThrift(this.cfDef);
    }

    public void setProperties(Properties properties) throws Exception {
        ThriftUtils.populateObjectFromProperties(this.cfDef, properties);
    }

    static {
        for (Map.Entry field : CfDef.metaDataMap.entrySet()) {
            fieldsMetadata.put(((FieldMetaData)field.getValue()).fieldName, new FieldMetadata(((CfDef._Fields)field.getKey()).name(), ThriftTypes.values()[((FieldMetaData)field.getValue()).valueMetaData.type].name(), ((FieldMetaData)field.getValue()).valueMetaData.isContainer()));
        }
    }
}

