/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.solr;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.auth.KerberosScheme;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.Krb5HttpClientBuilder;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.apache.solr.client.solrj.impl.PreemptiveAuth;
import org.apache.solr.client.solrj.impl.SolrHttpClientBuilder;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.zookeeper.KeeperException;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.core.attribute.Geo;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.core.attribute.Text;
import org.janusgraph.core.schema.Mapping;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransaction;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.BaseTransactionConfigurable;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.TemporaryBackendException;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.indexing.IndexEntry;
import org.janusgraph.diskstorage.indexing.IndexFeatures;
import org.janusgraph.diskstorage.indexing.IndexMutation;
import org.janusgraph.diskstorage.indexing.IndexProvider;
import org.janusgraph.diskstorage.indexing.IndexQuery;
import org.janusgraph.diskstorage.indexing.KeyInformation;
import org.janusgraph.diskstorage.indexing.RawQuery;
import org.janusgraph.diskstorage.solr.SolrIndex;
import org.janusgraph.diskstorage.solr.SolrResultIterator;
import org.janusgraph.diskstorage.solr.UncheckedSolrException;
import org.janusgraph.diskstorage.solr.transform.GeoToWktConverter;
import org.janusgraph.diskstorage.util.DefaultTransaction;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.configuration.PreInitializeConfigOptions;
import org.janusgraph.graphdb.database.serialize.AttributeUtils;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.condition.And;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.condition.Not;
import org.janusgraph.graphdb.query.condition.Or;
import org.janusgraph.graphdb.query.condition.PredicateCondition;
import org.janusgraph.graphdb.types.ParameterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreInitializeConfigOptions
public class Solr6Index
implements IndexProvider {
    private static final Logger logger = LoggerFactory.getLogger(Solr6Index.class);
    private static final String DEFAULT_ID_FIELD = "id";
    private static final char CHROOT_START_CHAR = '/';
    private static Solr6Index instance = null;
    public static final ConfigOption<Boolean> CREATE_SOLR_CLIENT_PER_REQUEST = new ConfigOption(SolrIndex.SOLR_NS, "create-client-per-request", "when false, allows the sharing of solr client across other components.", ConfigOption.Type.LOCAL, (Object)false);
    public static final ConfigOption<String[]> ZOOKEEPER_URLS = new ConfigOption(SolrIndex.SOLR_NS, "zookeeper-urls", "URL of the Zookeeper instance coordinating the SolrCloud cluster", ConfigOption.Type.MASKABLE, (Object)new String[]{"localhost:2181"});
    private static final IndexFeatures SOLR_FEATURES = new IndexFeatures.Builder().supportsDocumentTTL().setDefaultStringMapping(Mapping.TEXT).supportedStringMappings(new Mapping[]{Mapping.TEXT, Mapping.STRING}).supportsCardinality(Cardinality.SINGLE).supportsCardinality(Cardinality.LIST).supportsCardinality(Cardinality.SET).supportsCustomAnalyzer().supportsGeoContains().build();
    private static final Map<Geo, String> SPATIAL_PREDICATES = Solr6Index.spatialPredicates();
    private static boolean createSolrClientPerRequest;
    private final SolrClient solrClient;
    private final Configuration configuration;
    private final Mode mode;
    private final boolean dynFields;
    private final Map<String, String> keyFieldIds;
    private final String ttlField;
    private final int batchSize;
    private final boolean waitSearcher;
    private final boolean kerberosEnabled;

    public Solr6Index(Configuration config) throws BackendException {
        HttpClientUtil.setHttpClientBuilder((SolrHttpClientBuilder)new Krb5HttpClientBuilder().getBuilder());
        Preconditions.checkArgument((config != null ? 1 : 0) != 0);
        this.configuration = config;
        this.mode = Mode.parse((String)config.get(SolrIndex.SOLR_MODE, new String[0]));
        this.kerberosEnabled = (Boolean)config.get(SolrIndex.KERBEROS_ENABLED, new String[0]);
        this.dynFields = (Boolean)config.get(SolrIndex.DYNAMIC_FIELDS, new String[0]);
        this.keyFieldIds = this.parseKeyFieldsForCollections(config);
        this.batchSize = (Integer)config.get(GraphDatabaseConfiguration.INDEX_MAX_RESULT_SET_SIZE, new String[0]);
        this.ttlField = (String)config.get(SolrIndex.TTL_FIELD, new String[0]);
        this.waitSearcher = (Boolean)config.get(SolrIndex.WAIT_SEARCHER, new String[0]);
        if (this.kerberosEnabled) {
            logger.debug("Kerberos is enabled. Configuring SOLR for Kerberos.");
            this.configureSolrClientsForKerberos();
        } else {
            logger.debug("Kerberos is NOT enabled.");
            logger.debug("KERBEROS_ENABLED name is " + SolrIndex.KERBEROS_ENABLED.getName() + " and it is" + (SolrIndex.KERBEROS_ENABLED.isOption() ? " " : " not") + " an option.");
            logger.debug("KERBEROS_ENABLED type is " + SolrIndex.KERBEROS_ENABLED.getType().name());
        }
        this.solrClient = this.createSolrClient();
        createSolrClientPerRequest = (Boolean)config.get(CREATE_SOLR_CLIENT_PER_REQUEST, new String[0]);
        if (createSolrClientPerRequest) {
            logger.info("A new Solr Client will be created for direct interation with SOLR.");
        } else {
            logger.info("Solr Client will be shared for direct interation with SOLR.");
        }
        instance = this;
    }

    public static Mode getSolrMode() {
        Mode ret;
        Solr6Index solr6Index = instance;
        Mode mode = ret = solr6Index != null ? Mode.parse((String)solr6Index.configuration.get(SolrIndex.SOLR_MODE, new String[0])) : null;
        if (ret == null) {
            logger.warn("SolrMode is not set. Assuming {}", (Object)Mode.CLOUD);
            ret = Mode.CLOUD;
        }
        return ret;
    }

    public static SolrClient getSolrClient() {
        if (instance != null) {
            if (createSolrClientPerRequest) {
                logger.debug("Creating a new Solr Client.");
                return instance.createSolrClient();
            }
            logger.debug("Returning the solr client owned by Solr6Index.");
            return Solr6Index.instance.solrClient;
        }
        logger.debug(" No Solr6Index available. Will return null");
        return null;
    }

    public static void releaseSolrClient(SolrClient solrClient) {
        if (createSolrClientPerRequest) {
            if (solrClient != null) {
                try {
                    solrClient.close();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Closed the solr client successfully.");
                    }
                }
                catch (IOException excp) {
                    logger.warn("Failed to close SolrClient.", (Throwable)excp);
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("Ignoring the closing of solr client as it is owned by Solr6Index.");
        }
    }

    private SolrClient createSolrClient() {
        if (logger.isDebugEnabled()) {
            logger.debug("HttpClientBuilder = {}", (Object)HttpClientUtil.getHttpClientBuilder(), (Object)new Exception());
        }
        ModifiableSolrParams clientParams = new ModifiableSolrParams();
        CloudSolrClient solrClient = null;
        Mode mode = Mode.parse((String)this.configuration.get(SolrIndex.SOLR_MODE, new String[0]));
        switch (mode) {
            case CLOUD: {
                ArrayList<String> zkHosts = new ArrayList<String>();
                String chroot = null;
                String[] zkUrls = (String[])this.configuration.get(ZOOKEEPER_URLS, new String[0]);
                if (zkUrls != null) {
                    for (int i = zkUrls.length - 1; i >= 0; --i) {
                        String zkUrl = zkUrls[i];
                        int idxChroot = zkUrl.indexOf(47);
                        if (idxChroot != -1) {
                            if (chroot == null) {
                                chroot = zkUrl.substring(idxChroot);
                            }
                            zkUrl = zkUrl.substring(0, idxChroot);
                        }
                        zkHosts.add(zkUrl);
                    }
                }
                CloudSolrClient cloudServer = new CloudSolrClient.Builder().withZkHost(zkHosts).withZkChroot(chroot).withLBHttpSolrClientBuilder(new LBHttpSolrClient.Builder().withHttpSolrClientBuilder(new HttpSolrClient.Builder().withInvariantParams(clientParams)).withBaseSolrUrls((String[])this.configuration.get(SolrIndex.HTTP_URLS, new String[0]))).sendUpdatesOnlyToShardLeaders().build();
                cloudServer.connect();
                solrClient = cloudServer;
                logger.info("Created solr client using Cloud based configuration.");
                break;
            }
            case HTTP: {
                clientParams.add("allowCompression", new String[]{((Boolean)this.configuration.get(SolrIndex.HTTP_ALLOW_COMPRESSION, new String[0])).toString()});
                clientParams.add("connTimeout", new String[]{((Integer)this.configuration.get(SolrIndex.HTTP_CONNECTION_TIMEOUT, new String[0])).toString()});
                clientParams.add("maxConnectionsPerHost", new String[]{((Integer)this.configuration.get(SolrIndex.HTTP_MAX_CONNECTIONS_PER_HOST, new String[0])).toString()});
                clientParams.add("maxConnections", new String[]{((Integer)this.configuration.get(SolrIndex.HTTP_GLOBAL_MAX_CONNECTIONS, new String[0])).toString()});
                CloseableHttpClient client = HttpClientUtil.createClient((SolrParams)clientParams);
                solrClient = ((LBHttpSolrClient.Builder)new LBHttpSolrClient.Builder().withHttpClient((HttpClient)client)).withBaseSolrUrls((String[])this.configuration.get(SolrIndex.HTTP_URLS, new String[0])).build();
                logger.info("Created solr client using HTTP based configuration.");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Solr operation mode: " + (Object)((Object)mode));
            }
        }
        return solrClient;
    }

    private void configureSolrClientsForKerberos() throws PermanentBackendException {
        String kerberosConfig = System.getProperty("java.security.auth.login.config");
        if (kerberosConfig == null) {
            throw new PermanentBackendException("Unable to configure kerberos for solr client. System property 'java.security.auth.login.config' is not set.");
        }
        logger.debug("Using kerberos configuration file located at '{}'.", (Object)kerberosConfig);
        try (Krb5HttpClientBuilder krbBuild = new Krb5HttpClientBuilder();){
            SolrHttpClientBuilder kb = krbBuild.getBuilder();
            HttpClientUtil.setHttpClientBuilder((SolrHttpClientBuilder)kb);
            HttpRequestInterceptor bufferedEntityInterceptor = new HttpRequestInterceptor(){

                public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                    if (request instanceof HttpEntityEnclosingRequest) {
                        HttpEntityEnclosingRequest enclosingRequest = (HttpEntityEnclosingRequest)request;
                        HttpEntity requestEntity = enclosingRequest.getEntity();
                        enclosingRequest.setEntity((HttpEntity)new BufferedHttpEntity(requestEntity));
                    }
                }
            };
            HttpClientUtil.addRequestInterceptor((HttpRequestInterceptor)bufferedEntityInterceptor);
            PreemptiveAuth preemptiveAuth = new PreemptiveAuth((AuthScheme)new KerberosScheme());
            HttpClientUtil.addRequestInterceptor((HttpRequestInterceptor)preemptiveAuth);
        }
    }

    private Map<String, String> parseKeyFieldsForCollections(Configuration config) throws BackendException {
        String[] collectionFieldStatements;
        HashMap<String, String> keyFieldNames = new HashMap<String, String>();
        for (String collectionFieldStatement : collectionFieldStatements = config.has(SolrIndex.KEY_FIELD_NAMES, new String[0]) ? (String[])config.get(SolrIndex.KEY_FIELD_NAMES, new String[0]) : new String[]{}) {
            String[] parts = collectionFieldStatement.trim().split("=");
            if (parts.length != 2) {
                throw new PermanentBackendException("Unable to parse the collection name / key field name pair. It should be of the format collection=field");
            }
            String collectionName = parts[0];
            String keyFieldName = parts[1];
            keyFieldNames.put(collectionName, keyFieldName);
        }
        return keyFieldNames;
    }

    private String getKeyFieldId(String collection) {
        String field = this.keyFieldIds.get(collection);
        if (field == null) {
            field = DEFAULT_ID_FIELD;
        }
        return field;
    }

    public void register(String store, String key, KeyInformation information, BaseTransaction tx) throws BackendException {
        String analyzer;
        if (this.mode == Mode.CLOUD) {
            CloudSolrClient client = (CloudSolrClient)this.solrClient;
            try {
                Solr6Index.createCollectionIfNotExists(client, this.configuration, store);
            }
            catch (IOException | InterruptedException | SolrServerException | KeeperException e) {
                throw new PermanentBackendException(e);
            }
        }
        if ((analyzer = (String)ParameterType.STRING_ANALYZER.findParameter(information.getParameters(), null)) != null) {
            try {
                ClassLoader.getSystemClassLoader().loadClass(analyzer).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new PermanentBackendException(e.getMessage(), (Throwable)e);
            }
        }
        if ((analyzer = (String)ParameterType.TEXT_ANALYZER.findParameter(information.getParameters(), null)) != null) {
            try {
                ClassLoader.getSystemClassLoader().loadClass(analyzer).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new PermanentBackendException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void instantiateUsingClassLoader(String analyzer) throws PermanentBackendException {
        if (analyzer == null) {
            return;
        }
        try {
            Class<?> analyzerClass = Class.forName(analyzer);
            ClassLoader cl = analyzerClass.getClassLoader();
            cl.loadClass(analyzer).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new PermanentBackendException(e.getMessage(), (Throwable)e);
        }
    }

    public void mutate(Map<String, Map<String, IndexMutation>> mutations, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        logger.debug("Mutating SOLR");
        try {
            for (Map.Entry<String, Map<String, IndexMutation>> stores : mutations.entrySet()) {
                String collectionName = stores.getKey();
                String keyIdField = this.getKeyFieldId(collectionName);
                ArrayList<String> deleteIds = new ArrayList<String>();
                ArrayList<SolrInputDocument> changes = new ArrayList<SolrInputDocument>();
                for (Map.Entry<String, IndexMutation> entry : stores.getValue().entrySet()) {
                    String docId = entry.getKey();
                    IndexMutation mutation = entry.getValue();
                    Preconditions.checkArgument((!mutation.isNew() || !mutation.isDeleted() ? 1 : 0) != 0);
                    Preconditions.checkArgument((!mutation.isNew() || !mutation.hasDeletions() ? 1 : 0) != 0);
                    Preconditions.checkArgument((!mutation.isDeleted() || !mutation.hasAdditions() ? 1 : 0) != 0);
                    if (mutation.hasDeletions()) {
                        if (mutation.isDeleted()) {
                            logger.trace("Deleting entire document {}", (Object)docId);
                            deleteIds.add(docId);
                        } else {
                            ArrayList<IndexEntry> fieldDeletions = new ArrayList<IndexEntry>(mutation.getDeletions());
                            if (mutation.hasAdditions()) {
                                for (IndexEntry indexEntry : mutation.getAdditions()) {
                                    fieldDeletions.remove(indexEntry);
                                }
                            }
                            this.handleRemovalsFromIndex(collectionName, keyIdField, docId, fieldDeletions, information);
                        }
                    }
                    if (!mutation.hasAdditions()) continue;
                    int ttl = mutation.determineTTL();
                    SolrInputDocument doc = new SolrInputDocument(new String[0]);
                    doc.setField(keyIdField, (Object)docId);
                    boolean isNewDoc = mutation.isNew();
                    if (isNewDoc) {
                        logger.trace("Adding new document {}", (Object)docId);
                    }
                    final Map<String, Object> adds = this.collectFieldValues(mutation.getAdditions(), collectionName, information);
                    adds.keySet().forEach(v -> {
                        KeyInformation keyInformation = information.get(collectionName, v);
                        final String solrOp = keyInformation.getCardinality() == Cardinality.SINGLE ? "set" : "add";
                        doc.setField(v, isNewDoc ? adds.get(v) : new HashMap<String, Object>(1){
                            {
                                super(x0);
                                this.put(solrOp, adds.get(v));
                            }
                        });
                    });
                    if (ttl > 0) {
                        Preconditions.checkArgument((boolean)isNewDoc, (String)"Solr only supports TTL on new documents [%s]", (Object)docId);
                        doc.setField(this.ttlField, (Object)String.format("+%dSECONDS", ttl));
                    }
                    changes.add(doc);
                }
                this.commitDeletes(collectionName, deleteIds);
                this.commitChanges(collectionName, changes);
            }
        }
        catch (IllegalArgumentException e) {
            throw new PermanentBackendException("Unable to complete query on Solr.", (Throwable)e);
        }
        catch (Exception e) {
            throw this.storageException(e);
        }
    }

    private void handleRemovalsFromIndex(String collectionName, String keyIdField, String docId, List<IndexEntry> fieldDeletions, KeyInformation.IndexRetriever information) throws SolrServerException, IOException, BackendException {
        HashMap<String, Object> fieldDeletes = new HashMap<String, Object>(1);
        fieldDeletes.put("set", null);
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        doc.addField(keyIdField, (Object)docId);
        for (IndexEntry v : fieldDeletions) {
            KeyInformation keyInformation = information.get(collectionName, v.field);
            Map<String, Object> deletes = this.collectFieldValues(fieldDeletions, collectionName, information);
            deletes.keySet().forEach(vertex -> {
                HashMap remove;
                if (keyInformation.getCardinality() == Cardinality.SINGLE) {
                    remove = fieldDeletes;
                } else {
                    remove = new HashMap(1);
                    remove.put("remove", deletes.get(vertex));
                }
                doc.setField(vertex, remove);
            });
        }
        UpdateRequest singleDocument = this.newUpdateRequest();
        singleDocument.add(doc);
        this.solrClient.request((SolrRequest)singleDocument, collectionName);
    }

    private Object convertValue(Object value) throws BackendException {
        if (value instanceof Geoshape) {
            return GeoToWktConverter.convertToWktString((Geoshape)((Geoshape)value));
        }
        if (value instanceof UUID) {
            return value.toString();
        }
        if (value instanceof Instant) {
            if (Math.floorMod(((Instant)value).getNano(), 1000000) != 0) {
                throw new IllegalArgumentException("Solr indexes do not support nanoseconds");
            }
            return new Date(((Instant)value).toEpochMilli());
        }
        return value;
    }

    public void restore(Map<String, Map<String, List<IndexEntry>>> documents, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        try {
            for (Map.Entry<String, Map<String, List<IndexEntry>>> stores : documents.entrySet()) {
                String collectionName = stores.getKey();
                ArrayList<String> deleteIds = new ArrayList<String>();
                ArrayList<SolrInputDocument> newDocuments = new ArrayList<SolrInputDocument>();
                for (Map.Entry<String, List<IndexEntry>> entry : stores.getValue().entrySet()) {
                    String docID = entry.getKey();
                    List<IndexEntry> content = entry.getValue();
                    if (content == null || content.isEmpty()) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Deleting document [{}]", (Object)docID);
                        }
                        deleteIds.add(docID);
                        continue;
                    }
                    SolrInputDocument doc = new SolrInputDocument(new String[0]);
                    doc.setField(this.getKeyFieldId(collectionName), (Object)docID);
                    Map<String, Object> adds = this.collectFieldValues(content, collectionName, information);
                    adds.forEach((arg_0, arg_1) -> ((SolrInputDocument)doc).setField(arg_0, arg_1));
                    newDocuments.add(doc);
                }
                this.commitDeletes(collectionName, deleteIds);
                this.commitChanges(collectionName, newDocuments);
            }
        }
        catch (Exception e) {
            throw new TemporaryBackendException("Could not restore Solr index", (Throwable)e);
        }
    }

    private Map<String, Object> collectFieldValues(List<IndexEntry> content, String collectionName, KeyInformation.IndexRetriever information) throws BackendException {
        HashMap<String, Object> docs = new HashMap<String, Object>();
        for (IndexEntry addition : content) {
            KeyInformation keyInformation = information.get(collectionName, addition.field);
            switch (keyInformation.getCardinality()) {
                case SINGLE: {
                    docs.put(addition.field, this.convertValue(addition.value));
                    break;
                }
                case SET: {
                    if (!docs.containsKey(addition.field)) {
                        docs.put(addition.field, new HashSet());
                    }
                    ((Set)docs.get(addition.field)).add(this.convertValue(addition.value));
                    break;
                }
                case LIST: {
                    if (!docs.containsKey(addition.field)) {
                        docs.put(addition.field, new ArrayList());
                    }
                    ((List)docs.get(addition.field)).add(this.convertValue(addition.value));
                }
            }
        }
        return docs;
    }

    private void commitChanges(String collectionName, Collection<SolrInputDocument> documents) throws SolrServerException, IOException {
        if (documents.size() == 0) {
            return;
        }
        try {
            this.solrClient.request((SolrRequest)this.newUpdateRequest().add(documents), collectionName);
        }
        catch (HttpSolrClient.RemoteSolrException rse) {
            logger.error("Unable to save documents to Solr as one of the shape objects stored were not compatible with Solr.", (Throwable)rse);
            logger.error("Details in failed document batch: ");
            for (SolrInputDocument d : documents) {
                Collection fieldNames = d.getFieldNames();
                for (String name : fieldNames) {
                    logger.error(name + ":" + d.getFieldValue(name));
                }
            }
            throw rse;
        }
    }

    private void commitDeletes(String collectionName, List<String> deleteIds) throws SolrServerException, IOException {
        if (deleteIds.size() == 0) {
            return;
        }
        this.solrClient.request((SolrRequest)this.newUpdateRequest().deleteById(deleteIds), collectionName);
    }

    public Stream<String> query(IndexQuery query, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        String collection = query.getStore();
        String keyIdField = this.getKeyFieldId(collection);
        SolrQuery solrQuery = new SolrQuery("*:*");
        solrQuery.set("fl", new String[]{keyIdField});
        String queryFilter = this.buildQueryFilter((Condition<JanusGraphElement>)query.getCondition(), information.get(collection));
        solrQuery.addFilterQuery(new String[]{queryFilter});
        if (!query.getOrder().isEmpty()) {
            this.addOrderToQuery(solrQuery, query.getOrder());
        }
        solrQuery.setStart(Integer.valueOf(0));
        if (query.hasLimit()) {
            solrQuery.setRows(Integer.valueOf(Math.min(query.getLimit(), this.batchSize)));
        } else {
            solrQuery.setRows(Integer.valueOf(this.batchSize));
        }
        return this.executeQuery(query.hasLimit() ? Integer.valueOf(query.getLimit()) : null, 0, collection, solrQuery, doc -> doc.getFieldValue(keyIdField).toString());
    }

    private void addOrderToQuery(SolrQuery solrQuery, List<IndexQuery.OrderEntry> orders) {
        for (IndexQuery.OrderEntry order1 : orders) {
            String item = order1.getKey();
            SolrQuery.ORDER order = order1.getOrder() == Order.ASC ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc;
            solrQuery.addSort(new SolrQuery.SortClause(item, order));
        }
    }

    private <E> Stream<E> executeQuery(Integer limit, int offset, String collection, SolrQuery solrQuery, Function<SolrDocument, E> function) throws PermanentBackendException {
        try {
            SolrResultIterator resultIterator = new SolrResultIterator(this.solrClient, limit, offset, solrQuery.getRows().intValue(), collection, solrQuery, function);
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(resultIterator, 16), false);
        }
        catch (IOException | UncheckedIOException e) {
            logger.error("Query did not complete : ", (Throwable)e);
            throw new PermanentBackendException((Throwable)e);
        }
        catch (SolrServerException | UncheckedSolrException e) {
            logger.error("Unable to query Solr index.", e);
            throw new PermanentBackendException(e);
        }
    }

    private SolrQuery runCommonQuery(RawQuery query, KeyInformation.IndexRetriever information, BaseTransaction tx, String collection, String keyIdField) throws BackendException {
        SolrQuery solrQuery = new SolrQuery(query.getQuery()).addField(keyIdField).setIncludeScore(true).setStart(Integer.valueOf(query.getOffset()));
        if (query.hasLimit()) {
            solrQuery.setRows(Integer.valueOf(Math.min(query.getLimit(), this.batchSize)));
        } else {
            solrQuery.setRows(Integer.valueOf(this.batchSize));
        }
        if (!query.getOrders().isEmpty()) {
            this.addOrderToQuery(solrQuery, (List<IndexQuery.OrderEntry>)query.getOrders());
        }
        for (Parameter parameter : query.getParameters()) {
            if (parameter.value() instanceof String[]) {
                solrQuery.setParam(parameter.key(), (String[])parameter.value());
                continue;
            }
            if (!(parameter.value() instanceof String)) continue;
            solrQuery.setParam(parameter.key(), new String[]{(String)parameter.value()});
        }
        return solrQuery;
    }

    public Stream<RawQuery.Result<String>> query(RawQuery query, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        String collection = query.getStore();
        String keyIdField = this.getKeyFieldId(collection);
        return this.executeQuery(query.hasLimit() ? Integer.valueOf(query.getLimit()) : null, query.getOffset(), collection, this.runCommonQuery(query, information, tx, collection, keyIdField), doc -> {
            double score = Double.parseDouble(doc.getFieldValue("score").toString());
            return new RawQuery.Result((Object)doc.getFieldValue(keyIdField).toString(), score);
        });
    }

    public Long totals(RawQuery query, KeyInformation.IndexRetriever information, BaseTransaction tx) throws BackendException {
        try {
            String collection = query.getStore();
            String keyIdField = this.getKeyFieldId(collection);
            QueryResponse response = this.solrClient.query(collection, (SolrParams)this.runCommonQuery(query, information, tx, collection, keyIdField));
            logger.debug("Executed query [{}] in {} ms", (Object)query.getQuery(), (Object)response.getElapsedTime());
            return response.getResults().getNumFound();
        }
        catch (IOException e) {
            logger.error("Query did not complete : ", (Throwable)e);
            throw new PermanentBackendException((Throwable)e);
        }
        catch (SolrServerException e) {
            logger.error("Unable to query Solr index.", (Throwable)e);
            throw new PermanentBackendException((Throwable)e);
        }
    }

    private static String escapeValue(Object value) {
        return ClientUtils.escapeQueryChars((String)value.toString());
    }

    public String buildQueryFilter(Condition<JanusGraphElement> condition, KeyInformation.StoreRetriever information) {
        if (condition instanceof PredicateCondition) {
            PredicateCondition atom = (PredicateCondition)condition;
            Object value = atom.getValue();
            String key = (String)atom.getKey();
            JanusGraphPredicate predicate = atom.getPredicate();
            if (value instanceof Number) {
                String queryValue = Solr6Index.escapeValue(value);
                Preconditions.checkArgument((boolean)(predicate instanceof Cmp), (Object)("Relation not supported on numeric types: " + predicate));
                Cmp numRel = (Cmp)predicate;
                switch (numRel) {
                    case EQUAL: {
                        return key + ":" + queryValue;
                    }
                    case NOT_EQUAL: {
                        return "-" + key + ":" + queryValue;
                    }
                    case LESS_THAN: {
                        return key + ":[* TO " + queryValue + "}";
                    }
                    case LESS_THAN_EQUAL: {
                        return key + ":[* TO " + queryValue + "]";
                    }
                    case GREATER_THAN: {
                        return key + ":{" + queryValue + " TO *]";
                    }
                    case GREATER_THAN_EQUAL: {
                        return key + ":[" + queryValue + " TO *]";
                    }
                }
                throw new IllegalArgumentException("Unexpected relation: " + numRel);
            }
            if (value instanceof String) {
                Mapping map = Solr6Index.getStringMapping(information.get(key));
                assert (map == Mapping.TEXT || map == Mapping.STRING);
                if (map == Mapping.TEXT && !Text.HAS_CONTAINS.contains(predicate) && !(predicate instanceof Cmp)) {
                    throw new IllegalArgumentException("Text mapped string values only support CONTAINS and Compare queries and not: " + predicate);
                }
                if (map == Mapping.STRING && Text.HAS_CONTAINS.contains(predicate)) {
                    throw new IllegalArgumentException("String mapped string values do not support CONTAINS queries: " + predicate);
                }
                if (predicate == Text.CONTAINS) {
                    return this.tokenize(information, value, key, predicate, (String)ParameterType.TEXT_ANALYZER.findParameter(information.get(key).getParameters(), null));
                }
                if (predicate == Text.PREFIX || predicate == Text.CONTAINS_PREFIX) {
                    return key + ":" + Solr6Index.escapeValue(value) + "*";
                }
                if (predicate == Text.REGEX || predicate == Text.CONTAINS_REGEX) {
                    return key + ":/" + value + "/";
                }
                if (predicate == Cmp.EQUAL) {
                    String tokenizer = (String)ParameterType.STRING_ANALYZER.findParameter(information.get(key).getParameters(), null);
                    if (tokenizer != null) {
                        return this.tokenize(information, value, key, predicate, tokenizer);
                    }
                    return key + ":\"" + Solr6Index.escapeValue(value) + "\"";
                }
                if (predicate == Cmp.NOT_EQUAL) {
                    return "-" + key + ":\"" + Solr6Index.escapeValue(value) + "\"";
                }
                if (predicate == Text.FUZZY || predicate == Text.CONTAINS_FUZZY) {
                    return key + ":" + Solr6Index.escapeValue(value) + "~";
                }
                if (predicate == Cmp.LESS_THAN) {
                    return key + ":[* TO \"" + Solr6Index.escapeValue(value) + "\"}";
                }
                if (predicate == Cmp.LESS_THAN_EQUAL) {
                    return key + ":[* TO \"" + Solr6Index.escapeValue(value) + "\"]";
                }
                if (predicate == Cmp.GREATER_THAN) {
                    return key + ":{\"" + Solr6Index.escapeValue(value) + "\" TO *]";
                }
                if (predicate == Cmp.GREATER_THAN_EQUAL) {
                    return key + ":[\"" + Solr6Index.escapeValue(value) + "\" TO *]";
                }
                throw new IllegalArgumentException("Relation is not supported for string value: " + predicate);
            }
            if (value instanceof Geoshape) {
                Mapping map = Mapping.getMapping((KeyInformation)information.get(key));
                Preconditions.checkArgument((predicate instanceof Geo && predicate != Geo.DISJOINT ? 1 : 0) != 0, (Object)("Relation not supported on geo types: " + predicate));
                Preconditions.checkArgument((map == Mapping.PREFIX_TREE || predicate == Geo.WITHIN || predicate == Geo.INTERSECT ? 1 : 0) != 0, (Object)("Relation not supported on geopoint types: " + predicate));
                Geoshape geo = (Geoshape)value;
                if (geo.getType() == Geoshape.Type.CIRCLE && (predicate == Geo.INTERSECT || map == Mapping.DEFAULT)) {
                    Geoshape.Point center = geo.getPoint();
                    return "{!geofilt sfield=" + key + " pt=" + center.getLatitude() + "," + center.getLongitude() + " d=" + geo.getRadius() + "} distErrPct=0";
                }
                if (geo.getType() == Geoshape.Type.BOX && (predicate == Geo.INTERSECT || map == Mapping.DEFAULT)) {
                    Geoshape.Point southwest = geo.getPoint(0);
                    Geoshape.Point northeast = geo.getPoint(1);
                    return key + ":[" + southwest.getLatitude() + "," + southwest.getLongitude() + " TO " + northeast.getLatitude() + "," + northeast.getLongitude() + "]";
                }
                if (map == Mapping.PREFIX_TREE) {
                    return key + ":\"" + SPATIAL_PREDICATES.get(predicate) + "(" + geo + ")\" distErrPct=0";
                }
                throw new IllegalArgumentException("Unsupported or invalid search shape type: " + geo.getType());
            }
            if (value instanceof Date || value instanceof Instant) {
                String s = value.toString();
                String queryValue = Solr6Index.escapeValue(value instanceof Date ? this.toIsoDate((Date)value) : value.toString());
                Preconditions.checkArgument((boolean)(predicate instanceof Cmp), (Object)("Relation not supported on date types: " + predicate));
                Cmp numRel = (Cmp)predicate;
                switch (numRel) {
                    case EQUAL: {
                        return key + ":" + queryValue;
                    }
                    case NOT_EQUAL: {
                        return "-" + key + ":" + queryValue;
                    }
                    case LESS_THAN: {
                        return key + ":[* TO " + queryValue + "}";
                    }
                    case LESS_THAN_EQUAL: {
                        return key + ":[* TO " + queryValue + "]";
                    }
                    case GREATER_THAN: {
                        return key + ":{" + queryValue + " TO *]";
                    }
                    case GREATER_THAN_EQUAL: {
                        return key + ":[" + queryValue + " TO *]";
                    }
                }
                throw new IllegalArgumentException("Unexpected relation: " + numRel);
            }
            if (value instanceof Boolean) {
                Cmp numRel = (Cmp)predicate;
                String queryValue = Solr6Index.escapeValue(value);
                switch (numRel) {
                    case EQUAL: {
                        return key + ":" + queryValue;
                    }
                    case NOT_EQUAL: {
                        return "-" + key + ":" + queryValue;
                    }
                }
                throw new IllegalArgumentException("Boolean types only support EQUAL or NOT_EQUAL");
            }
            if (value instanceof UUID) {
                if (predicate == Cmp.EQUAL) {
                    return key + ":\"" + Solr6Index.escapeValue(value) + "\"";
                }
                if (predicate == Cmp.NOT_EQUAL) {
                    return "-" + key + ":\"" + Solr6Index.escapeValue(value) + "\"";
                }
                throw new IllegalArgumentException("Relation is not supported for uuid value: " + predicate);
            }
            throw new IllegalArgumentException("Unsupported type: " + value);
        }
        if (condition instanceof Not) {
            String sub = this.buildQueryFilter((Condition<JanusGraphElement>)((Not)condition).getChild(), information);
            if (StringUtils.isNotBlank((String)sub)) {
                return "-(" + sub + ")";
            }
            return "";
        }
        if (condition instanceof And) {
            int numChildren = ((And)condition).size();
            StringBuilder sb = new StringBuilder();
            for (Condition c : condition.getChildren()) {
                String sub = this.buildQueryFilter((Condition<JanusGraphElement>)c, information);
                if (StringUtils.isBlank((String)sub)) continue;
                if (!sub.startsWith("-") && numChildren > 1) {
                    sb.append("+");
                }
                sb.append(sub).append(" ");
            }
            return sb.toString();
        }
        if (condition instanceof Or) {
            StringBuilder sb = new StringBuilder();
            int element = 0;
            for (Condition c : condition.getChildren()) {
                String sub = this.buildQueryFilter((Condition<JanusGraphElement>)c, information);
                if (StringUtils.isBlank((String)sub)) continue;
                if (element == 0) {
                    sb.append("(");
                } else {
                    sb.append(" OR ");
                }
                sb.append(sub);
                ++element;
            }
            if (element > 0) {
                sb.append(")");
            }
            return sb.toString();
        }
        throw new IllegalArgumentException("Invalid condition: " + condition);
    }

    private String tokenize(KeyInformation.StoreRetriever information, Object value, String key, JanusGraphPredicate janusgraphPredicate, String tokenizer) {
        List<String> terms = tokenizer != null ? this.customTokenize(tokenizer, (String)value) : Text.tokenize((String)((String)value));
        if (terms.isEmpty()) {
            return "";
        }
        if (terms.size() == 1) {
            return key + ":(" + Solr6Index.escapeValue(terms.get(0)) + ")";
        }
        And andTerms = new And();
        for (String term : terms) {
            andTerms.add((Condition)new PredicateCondition((Object)key, janusgraphPredicate, (Object)term));
        }
        return this.buildQueryFilter((Condition<JanusGraphElement>)andTerms, information);
    }

    private List<String> customTokenize(String tokenizerClass, String value) {
        ArrayList<String> arrayList;
        CachingTokenFilter stream = null;
        try {
            ArrayList<String> terms = new ArrayList<String>();
            Tokenizer tokenizer = (Tokenizer)ClassLoader.getSystemClassLoader().loadClass(tokenizerClass).getConstructor(new Class[0]).newInstance(new Object[0]);
            tokenizer.setReader((Reader)new StringReader(value));
            stream = new CachingTokenFilter((TokenStream)tokenizer);
            TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(TermToBytesRefAttribute.class);
            stream.reset();
            while (stream.incrementToken()) {
                terms.add(termAtt.getBytesRef().utf8ToString());
            }
            arrayList = terms;
        }
        catch (IOException | ReflectiveOperationException e) {
            try {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)stream);
        return arrayList;
    }

    private String toIsoDate(Date value) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(tz);
        return df.format(value);
    }

    public BaseTransactionConfigurable beginTransaction(BaseTransactionConfig config) {
        return new DefaultTransaction(config);
    }

    public void close() throws BackendException {
        logger.trace("Shutting down connection to Solr", (Object)this.solrClient);
        try {
            this.solrClient.close();
        }
        catch (IOException e) {
            throw new TemporaryBackendException((Throwable)e);
        }
    }

    public void clearStorage() throws BackendException {
        try {
            if (this.mode != Mode.CLOUD) {
                logger.error("Operation only supported for SolrCloud. Cores must be deleted manually through the Solr API when using HTTP mode.");
                return;
            }
            logger.debug("Clearing storage from Solr: {}", (Object)this.solrClient);
            ZkStateReader zkStateReader = ((CloudSolrClient)this.solrClient).getZkStateReader();
            zkStateReader.forciblyRefreshAllClusterStateSlow();
            ClusterState clusterState = zkStateReader.getClusterState();
            for (String collection : clusterState.getCollectionsMap().keySet()) {
                logger.debug("Clearing collection [{}] in Solr", (Object)collection);
                UpdateRequest deleteAll = this.newUpdateRequest();
                deleteAll.deleteByQuery("*:*");
                this.solrClient.request((SolrRequest)deleteAll, collection);
            }
        }
        catch (SolrServerException e) {
            logger.error("Unable to clear storage from index due to server error on Solr.", (Throwable)e);
            throw new PermanentBackendException((Throwable)e);
        }
        catch (IOException e) {
            logger.error("Unable to clear storage from index due to low-level I/O error.", (Throwable)e);
            throw new PermanentBackendException((Throwable)e);
        }
        catch (Exception e) {
            logger.error("Unable to clear storage from index due to general error.", (Throwable)e);
            throw new PermanentBackendException((Throwable)e);
        }
    }

    public boolean supports(KeyInformation information, JanusGraphPredicate predicate) {
        Class dataType = information.getDataType();
        Mapping mapping = Mapping.getMapping((KeyInformation)information);
        if (!(mapping == Mapping.DEFAULT || AttributeUtils.isString((Class)dataType) || mapping == Mapping.PREFIX_TREE && AttributeUtils.isGeo((Class)dataType))) {
            return false;
        }
        if (Number.class.isAssignableFrom(dataType)) {
            return predicate instanceof Cmp;
        }
        if (dataType == Geoshape.class) {
            switch (mapping) {
                case DEFAULT: {
                    return predicate == Geo.WITHIN || predicate == Geo.INTERSECT;
                }
                case PREFIX_TREE: {
                    return predicate == Geo.INTERSECT || predicate == Geo.WITHIN || predicate == Geo.CONTAINS;
                }
            }
        } else if (AttributeUtils.isString((Class)dataType)) {
            switch (mapping) {
                case DEFAULT: 
                case TEXT: {
                    return predicate == Text.CONTAINS || predicate == Text.CONTAINS_PREFIX || predicate == Text.CONTAINS_REGEX || predicate == Text.CONTAINS_FUZZY;
                }
                case STRING: {
                    return predicate instanceof Cmp || predicate == Text.REGEX || predicate == Text.PREFIX || predicate == Text.FUZZY;
                }
            }
        } else {
            if (dataType == Date.class || dataType == Instant.class) {
                return predicate instanceof Cmp;
            }
            if (dataType == Boolean.class) {
                return predicate == Cmp.EQUAL || predicate == Cmp.NOT_EQUAL;
            }
            if (dataType == UUID.class) {
                return predicate == Cmp.EQUAL || predicate == Cmp.NOT_EQUAL;
            }
        }
        return false;
    }

    public boolean supports(KeyInformation information) {
        Class dataType = information.getDataType();
        Mapping mapping = Mapping.getMapping((KeyInformation)information);
        if (Number.class.isAssignableFrom(dataType) || dataType == Date.class || dataType == Instant.class || dataType == Boolean.class || dataType == UUID.class) {
            return mapping == Mapping.DEFAULT;
        }
        if (AttributeUtils.isString((Class)dataType)) {
            return mapping == Mapping.DEFAULT || mapping == Mapping.TEXT || mapping == Mapping.STRING;
        }
        if (AttributeUtils.isGeo((Class)dataType)) {
            return mapping == Mapping.DEFAULT || mapping == Mapping.PREFIX_TREE;
        }
        return false;
    }

    public String mapKey2Field(String key, KeyInformation keyInfo) {
        String postfix;
        IndexProvider.checkKeyValidity((String)key);
        key = key.replace(' ', '\u2022');
        if (!this.dynFields) {
            return key;
        }
        if (ParameterType.MAPPED_NAME.hasParameter(keyInfo.getParameters())) {
            return key;
        }
        Class dataType = keyInfo.getDataType();
        if (AttributeUtils.isString((Class)dataType)) {
            Mapping map = Solr6Index.getStringMapping(keyInfo);
            switch (map) {
                case TEXT: {
                    postfix = "_t";
                    break;
                }
                case STRING: {
                    postfix = "_s";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported string mapping: " + map);
                }
            }
        } else if (AttributeUtils.isWholeNumber((Class)dataType)) {
            postfix = dataType.equals(Long.class) ? "_l" : "_i";
        } else if (AttributeUtils.isDecimal((Class)dataType)) {
            postfix = dataType.equals(Float.class) ? "_f" : "_d";
        } else if (dataType.equals(BigInteger.class)) {
            postfix = "_bi";
        } else if (dataType.equals(BigDecimal.class)) {
            postfix = "_bd";
        } else if (dataType.equals(Geoshape.class)) {
            postfix = "_g";
        } else if (dataType.equals(Date.class) || dataType.equals(Instant.class)) {
            postfix = "_dt";
        } else if (dataType.equals(Boolean.class)) {
            postfix = "_b";
        } else if (dataType.equals(UUID.class)) {
            postfix = "_uuid";
        } else {
            throw new IllegalArgumentException("Unsupported data type [" + dataType + "] for field: " + key);
        }
        if (keyInfo.getCardinality() == Cardinality.SET || keyInfo.getCardinality() == Cardinality.LIST) {
            postfix = postfix + "s";
        }
        return key + postfix;
    }

    public IndexFeatures getFeatures() {
        return SOLR_FEATURES;
    }

    public boolean exists() throws BackendException {
        if (this.mode != Mode.CLOUD) {
            throw new UnsupportedOperationException("Operation only supported for SolrCloud");
        }
        CloudSolrClient server = (CloudSolrClient)this.solrClient;
        try {
            ZkStateReader zkStateReader = server.getZkStateReader();
            zkStateReader.forciblyRefreshAllClusterStateSlow();
            ClusterState clusterState = zkStateReader.getClusterState();
            Map collections = clusterState.getCollectionsMap();
            return collections != null && !collections.isEmpty();
        }
        catch (InterruptedException | KeeperException e) {
            throw new PermanentBackendException("Unable to check if index exists", e);
        }
    }

    private static Mapping getStringMapping(KeyInformation information) {
        assert (AttributeUtils.isString((Class)information.getDataType()));
        Mapping map = Mapping.getMapping((KeyInformation)information);
        if (map == Mapping.DEFAULT) {
            map = Mapping.TEXT;
        }
        return map;
    }

    private static Map<Geo, String> spatialPredicates() {
        return Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<Geo, String>(Geo.WITHIN, "IsWithin"), new AbstractMap.SimpleEntry<Geo, String>(Geo.CONTAINS, "Contains"), new AbstractMap.SimpleEntry<Geo, String>(Geo.INTERSECT, "Intersects"), new AbstractMap.SimpleEntry<Geo, String>(Geo.DISJOINT, "IsDisjointTo")).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
    }

    private UpdateRequest newUpdateRequest() {
        UpdateRequest req = new UpdateRequest();
        if (this.waitSearcher) {
            req.setAction(AbstractUpdateRequest.ACTION.COMMIT, true, true);
        }
        return req;
    }

    private BackendException storageException(Exception solrException) {
        return new TemporaryBackendException("Unable to complete query on Solr.", (Throwable)solrException);
    }

    private static void createCollectionIfNotExists(CloudSolrClient client, Configuration config, String collection) throws IOException, SolrServerException, KeeperException, InterruptedException {
        if (!Solr6Index.checkIfCollectionExists(client, collection)) {
            Integer numShards = (Integer)config.get(SolrIndex.NUM_SHARDS, new String[0]);
            Integer maxShardsPerNode = (Integer)config.get(SolrIndex.MAX_SHARDS_PER_NODE, new String[0]);
            Integer replicationFactor = (Integer)config.get(SolrIndex.REPLICATION_FACTOR, new String[0]);
            String genericConfigSet = config.has(SolrIndex.SOLR_DEFAULT_CONFIG, new String[0]) ? (String)config.get(SolrIndex.SOLR_DEFAULT_CONFIG, new String[0]) : collection;
            CollectionAdminRequest.Create createRequest = CollectionAdminRequest.createCollection((String)collection, (String)genericConfigSet, (int)numShards, (int)replicationFactor);
            createRequest.setMaxShardsPerNode(maxShardsPerNode);
            CollectionAdminResponse createResponse = (CollectionAdminResponse)createRequest.process((SolrClient)client);
            if (createResponse.isSuccess()) {
                logger.trace("Collection {} successfully created.", (Object)collection);
            } else {
                throw new SolrServerException(Joiner.on((String)"\n").join((Iterable)createResponse.getErrorMessages()));
            }
        }
        Solr6Index.waitForRecoveriesToFinish(client, collection);
    }

    private static boolean checkIfCollectionExists(CloudSolrClient server, String collection) throws KeeperException, InterruptedException {
        ZkStateReader zkStateReader = server.getZkStateReader();
        zkStateReader.forceUpdateCollection(collection);
        ClusterState clusterState = zkStateReader.getClusterState();
        return clusterState.getCollectionOrNull(collection) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForRecoveriesToFinish(CloudSolrClient server, String collection) throws KeeperException, InterruptedException {
        ZkStateReader zkStateReader = server.getZkStateReader();
        try {
            boolean cont = true;
            while (cont) {
                boolean sawLiveRecovering = false;
                zkStateReader.forceUpdateCollection(collection);
                ClusterState clusterState = zkStateReader.getClusterState();
                Map slices = clusterState.getCollection(collection).getSlicesMap();
                Preconditions.checkNotNull((Object)slices, (Object)("Could not find collection:" + collection));
                for (Map.Entry entry : slices.entrySet()) {
                    Map shards = ((Slice)entry.getValue()).getReplicasMap();
                    for (Map.Entry shard : shards.entrySet()) {
                        String state = ((Replica)shard.getValue()).getStr("state").toUpperCase();
                        if (!Replica.State.RECOVERING.name().equals(state) && !Replica.State.DOWN.name().equals(state) || !clusterState.liveNodesContain(((Replica)shard.getValue()).getStr("node_name"))) continue;
                        sawLiveRecovering = true;
                    }
                }
                if (!sawLiveRecovering) {
                    cont = false;
                    continue;
                }
                Thread.sleep(1000L);
            }
        }
        finally {
            logger.info("Exiting solr wait");
        }
    }

    public static enum Mode {
        HTTP,
        CLOUD;


        public static Mode parse(String mode) {
            for (Mode m : Mode.values()) {
                if (!m.toString().equalsIgnoreCase(mode)) continue;
                return m;
            }
            throw new IllegalArgumentException("Unrecognized mode: " + mode);
        }
    }
}

