/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.hbase2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.janusgraph.diskstorage.hbase2.AdminMask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseAdmin2_0
implements AdminMask {
    private static final Logger log = LoggerFactory.getLogger(HBaseAdmin2_0.class);
    private final Admin adm;

    public HBaseAdmin2_0(Admin adm) {
        this.adm = adm;
    }

    @Override
    public void clearTable(String tableString, long timestamp) throws IOException {
        TableName tableName = TableName.valueOf((String)tableString);
        if (!this.adm.tableExists(tableName)) {
            log.debug("Attempted to clear table {} before it exists (noop)", (Object)tableString);
            return;
        }
        Scan scan = new Scan();
        scan.setCacheBlocks(false);
        scan.setCaching(2000);
        scan.setTimeRange(0L, Long.MAX_VALUE);
        scan.readVersions(1);
        try (Table table = this.adm.getConnection().getTable(tableName);
             ResultScanner scanner = table.getScanner(scan);){
            Iterator iterator = scanner.iterator();
            int batchSize = 1000;
            ArrayList<Delete> deleteList = new ArrayList<Delete>();
            while (iterator.hasNext()) {
                deleteList.add(new Delete(((Result)iterator.next()).getRow(), timestamp));
                if (iterator.hasNext() && deleteList.size() != 1000) continue;
                table.delete(deleteList);
                deleteList.clear();
            }
        }
    }

    @Override
    public void dropTable(String tableString) throws IOException {
        TableName tableName = TableName.valueOf((String)tableString);
        if (!this.adm.tableExists(tableName)) {
            log.debug("Attempted to drop table {} before it exists (noop)", (Object)tableString);
            return;
        }
        if (this.adm.isTableEnabled(tableName)) {
            this.adm.disableTable(tableName);
        }
        this.adm.deleteTable(tableName);
    }

    @Override
    public TableDescriptor getTableDescriptor(String tableString) throws TableNotFoundException, IOException {
        return this.adm.getDescriptor(TableName.valueOf((String)tableString));
    }

    @Override
    public boolean tableExists(String tableString) throws IOException {
        return this.adm.tableExists(TableName.valueOf((String)tableString));
    }

    @Override
    public void createTable(TableDescriptor desc) throws IOException {
        this.adm.createTable(desc);
    }

    @Override
    public void createTable(TableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        this.adm.createTable(desc, startKey, endKey, numRegions);
    }

    @Override
    public int getEstimatedRegionServerCount() {
        int serverCount = -1;
        try {
            serverCount = this.adm.getClusterStatus().getServers().size();
            log.debug("Read {} servers from HBase ClusterStatus", (Object)serverCount);
        }
        catch (IOException e) {
            log.debug("Unable to retrieve HBase cluster status", (Throwable)e);
        }
        return serverCount;
    }

    @Override
    public void disableTable(String tableString) throws IOException {
        this.adm.disableTable(TableName.valueOf((String)tableString));
    }

    @Override
    public void enableTable(String tableString) throws IOException {
        this.adm.enableTable(TableName.valueOf((String)tableString));
    }

    @Override
    public boolean isTableDisabled(String tableString) throws IOException {
        return this.adm.isTableDisabled(TableName.valueOf((String)tableString));
    }

    @Override
    public void addColumn(String tableString, ColumnFamilyDescriptor columnDescriptor) throws IOException {
        this.adm.addColumnFamily(TableName.valueOf((String)tableString), columnDescriptor);
    }

    @Override
    public void close() throws IOException {
        this.adm.close();
    }
}

