/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.dao;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.web.model.User;
import org.apache.atlas.web.security.AtlasAuthenticationException;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.encoding.ShaPasswordEncoder;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCrypt;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class UserDao {
    private static final Logger LOG = LoggerFactory.getLogger(UserDao.class);
    private static final String DEFAULT_USER_CREDENTIALS_PROPERTIES = "users-credentials.properties";
    private static final ShaPasswordEncoder sha256Encoder = new ShaPasswordEncoder(256);
    private static boolean v1ValidationEnabled = true;
    private static boolean v2ValidationEnabled = true;
    private Properties userLogins = new Properties();

    @PostConstruct
    public void init() {
        this.loadFileLoginsDetails();
    }

    void loadFileLoginsDetails() {
        this.userLogins.clear();
        InputStream inStr = null;
        try {
            Configuration configuration = ApplicationProperties.get();
            v1ValidationEnabled = configuration.getBoolean("atlas.authentication.method.file.v1-validation.enabled", true);
            v2ValidationEnabled = configuration.getBoolean("atlas.authentication.method.file.v2-validation.enabled", true);
            inStr = ApplicationProperties.getFileAsInputStream((Configuration)configuration, (String)"atlas.authentication.method.file.filename", (String)DEFAULT_USER_CREDENTIALS_PROPERTIES);
            this.userLogins.load(inStr);
        }
        catch (IOException | AtlasException e) {
            LOG.error("Error while reading user.properties file", e);
            throw new RuntimeException(e);
        }
        finally {
            if (inStr != null) {
                try {
                    inStr.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public User loadUserByUsername(String username) throws AuthenticationException {
        String userdetailsStr = this.userLogins.getProperty(username);
        if (userdetailsStr == null || userdetailsStr.isEmpty()) {
            throw new UsernameNotFoundException("Username not found." + username);
        }
        String password = "";
        String role = "";
        String[] dataArr = userdetailsStr.split("::");
        if (dataArr == null || dataArr.length != 2) {
            LOG.error("User role credentials is not set properly for {}", (Object)username);
            throw new AtlasAuthenticationException("User role credentials is not set properly for " + username);
        }
        role = dataArr[0];
        password = dataArr[1];
        ArrayList<GrantedAuthority> grantedAuths = new ArrayList<GrantedAuthority>();
        if (!StringUtils.hasText((String)role)) {
            LOG.error("User role credentials is not set properly for {}", (Object)username);
            throw new AtlasAuthenticationException("User role credentials is not set properly for " + username);
        }
        grantedAuths.add((GrantedAuthority)new SimpleGrantedAuthority(role));
        User userDetails = new User(username, password, grantedAuths);
        return userDetails;
    }

    @VisibleForTesting
    public void setUserLogins(Properties userLogins) {
        this.userLogins = userLogins;
    }

    public static String encrypt(String password) {
        String ret = null;
        try {
            ret = BCrypt.hashpw((String)password, (String)BCrypt.gensalt());
        }
        catch (Throwable excp) {
            LOG.warn("UserDao.encrypt(): failed", excp);
        }
        return ret;
    }

    public static boolean checkEncrypted(String password, String encryptedPwd, String userName) {
        boolean ret = UserDao.checkPasswordBCrypt(password, encryptedPwd);
        if (!ret && v2ValidationEnabled) {
            ret = UserDao.checkPasswordSHA256WithSalt(password, encryptedPwd, userName);
        }
        if (!ret && v1ValidationEnabled) {
            ret = UserDao.checkPasswordSHA256(password, encryptedPwd);
        }
        return ret;
    }

    private static boolean checkPasswordBCrypt(String password, String encryptedPwd) {
        boolean ret;
        block3: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("checkPasswordBCrypt()");
            }
            ret = false;
            try {
                ret = BCrypt.checkpw((String)password, (String)encryptedPwd);
            }
            catch (Throwable excp) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("checkPasswordBCrypt(): failed", excp);
            }
        }
        return ret;
    }

    private static boolean checkPasswordSHA256WithSalt(String password, String encryptedPwd, String salt) {
        boolean ret;
        block3: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("checkPasswordSHA256WithSalt()");
            }
            ret = false;
            try {
                String hash = sha256Encoder.encodePassword(password, (Object)salt);
                ret = hash != null && hash.equals(encryptedPwd);
            }
            catch (Throwable excp) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("checkPasswordSHA256WithSalt(): failed", excp);
            }
        }
        return ret;
    }

    private static boolean checkPasswordSHA256(String password, String encryptedPwd) {
        boolean ret;
        block3: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("checkPasswordSHA256()");
            }
            ret = false;
            try {
                String hash = UserDao.getSha256Hash(password);
                ret = hash != null && hash.equals(encryptedPwd);
            }
            catch (Throwable excp) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("checkPasswordSHA256(): failed", excp);
            }
        }
        return ret;
    }

    private static String getSha256Hash(String base) throws AtlasAuthenticationException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(base.getBytes("UTF-8"));
            StringBuffer hexString = new StringBuffer();
            for (byte aHash : hash) {
                String hex = Integer.toHexString(0xFF & aHash);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (Exception ex) {
            throw new AtlasAuthenticationException("Exception while encoding password.", ex);
        }
    }
}

