/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.errors;

import java.util.concurrent.ThreadLocalRandom;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.atlas.web.errors.ExceptionMapperUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Provider
@Component
public class AllExceptionMapper
implements ExceptionMapper<Exception> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllExceptionMapper.class);

    public Response toResponse(Exception exception) {
        long id = ThreadLocalRandom.current().nextLong();
        ExceptionMapperUtil.logException(id, exception);
        return Response.serverError().entity((Object)ExceptionMapperUtil.formatErrorMessage(id, exception)).build();
    }
}

