/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.filters;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.stereotype.Component;

@Component
public class AtlasAuthenticationEntryPoint
extends LoginUrlAuthenticationEntryPoint {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasAuthenticationEntryPoint.class);
    private String loginPath = "/login.jsp";

    @Inject
    public AtlasAuthenticationEntryPoint(@Value(value="/login.jsp") String loginFormUrl) {
        super(loginFormUrl);
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        String ajaxRequestHeader = request.getHeader("X-Requested-With");
        if ("XMLHttpRequest".equals(ajaxRequestHeader)) {
            response.setStatus(401);
        } else {
            LOG.debug("redirecting to login page loginPath" + this.loginPath);
            response.sendRedirect(this.loginPath);
        }
    }
}

