/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.inject.Inject;
import javax.servlet.Filter;
import org.apache.atlas.web.filters.ActiveServerFilter;
import org.apache.atlas.web.filters.AtlasAuthenticationEntryPoint;
import org.apache.atlas.web.filters.AtlasAuthenticationFilter;
import org.apache.atlas.web.filters.AtlasCSRFPreventionFilter;
import org.apache.atlas.web.filters.AtlasDelegatingAuthenticationEntryPoint;
import org.apache.atlas.web.filters.AtlasKnoxSSOAuthenticationFilter;
import org.apache.atlas.web.filters.HeadersUtil;
import org.apache.atlas.web.filters.StaleTransactionCleanupFilter;
import org.apache.atlas.web.security.AtlasAuthenticationFailureHandler;
import org.apache.atlas.web.security.AtlasAuthenticationProvider;
import org.apache.atlas.web.security.AtlasAuthenticationSuccessHandler;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.UserSessionManagement;
import org.keycloak.adapters.springsecurity.AdapterDeploymentContextFactoryBean;
import org.keycloak.adapters.springsecurity.KeycloakConfiguration;
import org.keycloak.adapters.springsecurity.authentication.KeycloakAuthenticationEntryPoint;
import org.keycloak.adapters.springsecurity.authentication.KeycloakLogoutHandler;
import org.keycloak.adapters.springsecurity.filter.KeycloakAuthenticatedActionsFilter;
import org.keycloak.adapters.springsecurity.filter.KeycloakAuthenticationProcessingFilter;
import org.keycloak.adapters.springsecurity.filter.KeycloakPreAuthActionsFilter;
import org.keycloak.adapters.springsecurity.filter.KeycloakSecurityContextRequestFilter;
import org.keycloak.adapters.springsecurity.filter.QueryParamPresenceRequestMatcher;
import org.keycloak.adapters.springsecurity.management.HttpSessionManager;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.DelegatingAuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.session.RegisterSessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.writers.StaticHeadersWriter;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@KeycloakConfiguration
public class AtlasSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasSecurityConfig.class);
    private final AtlasAuthenticationProvider authenticationProvider;
    private final AtlasAuthenticationSuccessHandler successHandler;
    private final AtlasAuthenticationFailureHandler failureHandler;
    private final AtlasKnoxSSOAuthenticationFilter ssoAuthenticationFilter;
    private final AtlasAuthenticationFilter atlasAuthenticationFilter;
    private final AtlasCSRFPreventionFilter csrfPreventionFilter;
    private final AtlasAuthenticationEntryPoint atlasAuthenticationEntryPoint;
    private final Configuration configuration;
    private final StaleTransactionCleanupFilter staleTransactionCleanupFilter;
    private final ActiveServerFilter activeServerFilter;
    public static final RequestMatcher KEYCLOAK_REQUEST_MATCHER = new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher("/login.jsp"), new RequestHeaderRequestMatcher("Authorization"), new QueryParamPresenceRequestMatcher("access_token")});
    @Value(value="${keycloak.configurationFile:WEB-INF/keycloak.json}")
    private Resource keycloakConfigFileResource;
    @Autowired(required=false)
    private KeycloakConfigResolver keycloakConfigResolver;
    private final boolean keycloakEnabled;

    @Inject
    public AtlasSecurityConfig(AtlasKnoxSSOAuthenticationFilter ssoAuthenticationFilter, AtlasCSRFPreventionFilter atlasCSRFPreventionFilter, AtlasAuthenticationFilter atlasAuthenticationFilter, AtlasAuthenticationProvider authenticationProvider, AtlasAuthenticationSuccessHandler successHandler, AtlasAuthenticationFailureHandler failureHandler, AtlasAuthenticationEntryPoint atlasAuthenticationEntryPoint, Configuration configuration, StaleTransactionCleanupFilter staleTransactionCleanupFilter, ActiveServerFilter activeServerFilter) {
        this.ssoAuthenticationFilter = ssoAuthenticationFilter;
        this.csrfPreventionFilter = atlasCSRFPreventionFilter;
        this.atlasAuthenticationFilter = atlasAuthenticationFilter;
        this.authenticationProvider = authenticationProvider;
        this.successHandler = successHandler;
        this.failureHandler = failureHandler;
        this.atlasAuthenticationEntryPoint = atlasAuthenticationEntryPoint;
        this.configuration = configuration;
        this.staleTransactionCleanupFilter = staleTransactionCleanupFilter;
        this.activeServerFilter = activeServerFilter;
        this.keycloakEnabled = configuration.getBoolean("atlas.authentication.method.keycloak", false);
    }

    public AuthenticationEntryPoint getAuthenticationEntryPoint() throws Exception {
        Object authenticationEntryPoint;
        if (this.keycloakEnabled) {
            KeycloakAuthenticationEntryPoint keycloakAuthenticationEntryPoint = new KeycloakAuthenticationEntryPoint(this.adapterDeploymentContext());
            keycloakAuthenticationEntryPoint.setRealm("atlas.com");
            keycloakAuthenticationEntryPoint.setLoginUri("/login.jsp");
            authenticationEntryPoint = keycloakAuthenticationEntryPoint;
        } else {
            LinkedHashMap<RequestMatcher, AuthenticationEntryPoint> entryPointMap = new LinkedHashMap<RequestMatcher, AuthenticationEntryPoint>();
            entryPointMap.put((RequestMatcher)new RequestHeaderRequestMatcher("User-Agent", "Mozilla"), (AuthenticationEntryPoint)this.atlasAuthenticationEntryPoint);
            AtlasDelegatingAuthenticationEntryPoint basicAuthenticationEntryPoint = new AtlasDelegatingAuthenticationEntryPoint(entryPointMap);
            authenticationEntryPoint = basicAuthenticationEntryPoint;
        }
        return authenticationEntryPoint;
    }

    public DelegatingAuthenticationEntryPoint getDelegatingAuthenticationEntryPoint() throws Exception {
        LinkedHashMap<RequestHeaderRequestMatcher, AtlasAuthenticationEntryPoint> entryPointMap = new LinkedHashMap<RequestHeaderRequestMatcher, AtlasAuthenticationEntryPoint>();
        entryPointMap.put(new RequestHeaderRequestMatcher("User-Agent", "Mozilla"), this.atlasAuthenticationEntryPoint);
        DelegatingAuthenticationEntryPoint entryPoint = new DelegatingAuthenticationEntryPoint(entryPointMap);
        entryPoint.setDefaultEntryPoint(this.getAuthenticationEntryPoint());
        return entryPoint;
    }

    @Inject
    protected void configure(AuthenticationManagerBuilder authenticationManagerBuilder) {
        authenticationManagerBuilder.authenticationProvider((AuthenticationProvider)this.authenticationProvider);
    }

    public void configure(WebSecurity web) throws Exception {
        ArrayList<String> matchers = new ArrayList<String>(Arrays.asList("/css/**", "/n/css/**", "/img/**", "/n/img/**", "/libs/**", "/n/libs/**", "/js/**", "/n/js/**", "/ieerror.html", "/migration-status.html", "/api/atlas/admin/status"));
        if (!this.keycloakEnabled) {
            matchers.add("/login.jsp");
        }
        web.ignoring().antMatchers(matchers.toArray(new String[matchers.size()]));
    }

    protected void configure(HttpSecurity httpSecurity) throws Exception {
        boolean configMigrationEnabled;
        ((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)httpSecurity.authorizeRequests().anyRequest()).authenticated().and()).headers().frameOptions().disable().addHeaderWriter((HeaderWriter)new StaticHeadersWriter("Content-Security-Policy", new String[]{HeadersUtil.headerMap.get("Content-Security-Policy")})).addHeaderWriter((HeaderWriter)new StaticHeadersWriter("Server", new String[]{HeadersUtil.headerMap.get("Server")})).and()).servletApi().and()).csrf().disable()).sessionManagement().enableSessionUrlRewriting(false).sessionCreationPolicy(SessionCreationPolicy.ALWAYS).sessionFixation().newSession().and()).httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)this.getDelegatingAuthenticationEntryPoint()).and()).formLogin().loginPage("/login.jsp").loginProcessingUrl("/j_spring_security_check")).successHandler((AuthenticationSuccessHandler)this.successHandler)).failureHandler((AuthenticationFailureHandler)this.failureHandler)).usernameParameter("j_username").passwordParameter("j_password").and()).logout().logoutSuccessUrl("/login.jsp").deleteCookies(new String[]{"ATLASSESSIONID"}).logoutUrl("/logout.html");
        boolean bl = configMigrationEnabled = !StringUtils.isEmpty((String)this.configuration.getString("atlas.migration.data.filename"));
        if (this.configuration.getBoolean("atlas.server.ha.enabled", false) || configMigrationEnabled) {
            if (configMigrationEnabled) {
                LOG.info("Atlas is in Migration Mode, enabling ActiveServerFilter");
            } else {
                LOG.info("Atlas is in HA Mode, enabling ActiveServerFilter");
            }
            httpSecurity.addFilterAfter((Filter)this.activeServerFilter, BasicAuthenticationFilter.class);
        }
        httpSecurity.addFilterAfter((Filter)this.staleTransactionCleanupFilter, BasicAuthenticationFilter.class).addFilterBefore((Filter)this.ssoAuthenticationFilter, BasicAuthenticationFilter.class).addFilterAfter((Filter)this.atlasAuthenticationFilter, SecurityContextHolderAwareRequestFilter.class).addFilterAfter((Filter)this.csrfPreventionFilter, AtlasAuthenticationFilter.class);
        if (this.keycloakEnabled) {
            ((HttpSecurity)httpSecurity.logout().addLogoutHandler((LogoutHandler)this.keycloakLogoutHandler()).and()).addFilterBefore((Filter)this.keycloakAuthenticationProcessingFilter(), BasicAuthenticationFilter.class).addFilterBefore((Filter)this.keycloakPreAuthActionsFilter(), LogoutFilter.class).addFilterAfter((Filter)this.keycloakSecurityContextRequestFilter(), SecurityContextHolderAwareRequestFilter.class).addFilterAfter((Filter)this.keycloakAuthenticatedActionsRequestFilter(), KeycloakSecurityContextRequestFilter.class);
        }
    }

    @Bean
    protected SessionAuthenticationStrategy sessionAuthenticationStrategy() {
        return new RegisterSessionAuthenticationStrategy((SessionRegistry)new SessionRegistryImpl());
    }

    @Bean
    protected AdapterDeploymentContext adapterDeploymentContext() throws Exception {
        AdapterDeploymentContextFactoryBean factoryBean;
        String fileName = this.configuration.getString("atlas.authentication.method.keycloak.file");
        if (fileName != null && !fileName.isEmpty()) {
            this.keycloakConfigFileResource = new FileSystemResource(fileName);
            factoryBean = new AdapterDeploymentContextFactoryBean(this.keycloakConfigFileResource);
        } else {
            Configuration conf = this.configuration.subset("atlas.authentication.method.keycloak");
            AdapterConfig cfg = new AdapterConfig();
            cfg.setRealm(conf.getString("realm", "atlas.com"));
            cfg.setAuthServerUrl(conf.getString("auth-server-url", "https://localhost/auth"));
            cfg.setResource(conf.getString("resource", "none"));
            HashMap<String, String> credentials = new HashMap<String, String>();
            credentials.put("secret", conf.getString("credentials-secret", "nosecret"));
            cfg.setCredentials(credentials);
            final KeycloakDeployment dep = KeycloakDeploymentBuilder.build((AdapterConfig)cfg);
            factoryBean = new AdapterDeploymentContextFactoryBean(new KeycloakConfigResolver(){

                public KeycloakDeployment resolve(HttpFacade.Request request) {
                    return dep;
                }
            });
        }
        factoryBean.afterPropertiesSet();
        return factoryBean.getObject();
    }

    @Bean
    protected KeycloakPreAuthActionsFilter keycloakPreAuthActionsFilter() {
        return new KeycloakPreAuthActionsFilter((UserSessionManagement)this.httpSessionManager());
    }

    @Bean
    protected HttpSessionManager httpSessionManager() {
        return new HttpSessionManager();
    }

    protected KeycloakLogoutHandler keycloakLogoutHandler() throws Exception {
        return new KeycloakLogoutHandler(this.adapterDeploymentContext());
    }

    @Bean
    protected KeycloakSecurityContextRequestFilter keycloakSecurityContextRequestFilter() {
        return new KeycloakSecurityContextRequestFilter();
    }

    @Bean
    protected KeycloakAuthenticatedActionsFilter keycloakAuthenticatedActionsRequestFilter() {
        return new KeycloakAuthenticatedActionsFilter();
    }

    @Bean
    protected KeycloakAuthenticationProcessingFilter keycloakAuthenticationProcessingFilter() throws Exception {
        KeycloakAuthenticationProcessingFilter filter = new KeycloakAuthenticationProcessingFilter(this.authenticationManagerBean(), KEYCLOAK_REQUEST_MATCHER);
        filter.setSessionAuthenticationStrategy(this.sessionAuthenticationStrategy());
        return filter;
    }
}

