/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.security;

import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import org.jvnet.libpam.UnixUser;

public class PamPrincipal
implements Principal {
    private String userName;
    private String gecos;
    private String homeDir;
    private String shell;
    private int uid;
    private int gid;
    private Set<String> groups;

    public PamPrincipal(UnixUser user) {
        this.userName = user.getUserName();
        this.gecos = user.getGecos();
        this.homeDir = user.getDir();
        this.shell = user.getShell();
        this.uid = user.getUID();
        this.gid = user.getGID();
        this.groups = Collections.unmodifiableSet(user.getGroups());
    }

    @Override
    public String getName() {
        return this.userName;
    }

    public String getGecos() {
        return this.gecos;
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    public String getShell() {
        return this.shell;
    }

    public int getUid() {
        return this.uid;
    }

    public int getGid() {
        return this.gid;
    }

    public Set<String> getGroups() {
        return this.groups;
    }
}

