/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.LocalBarrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class NoOpBarrierStep<S>
extends AbstractStep<S, S>
implements LocalBarrier<S> {
    private int maxBarrierSize;
    private TraverserSet<S> barrier;

    public NoOpBarrierStep(Traversal.Admin traversal) {
        this(traversal, Integer.MAX_VALUE);
    }

    public NoOpBarrierStep(Traversal.Admin traversal, int maxBarrierSize) {
        super(traversal);
        this.maxBarrierSize = maxBarrierSize;
        this.barrier = this.traversal.getTraverserSetSupplier().get();
    }

    @Override
    protected Traverser.Admin<S> processNextStart() throws NoSuchElementException {
        if (this.barrier.isEmpty()) {
            this.processAllStarts();
        }
        return this.barrier.remove();
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.BULK);
    }

    @Override
    public void processAllStarts() {
        while ((this.maxBarrierSize == Integer.MAX_VALUE || this.barrier.size() < this.maxBarrierSize) && this.starts.hasNext()) {
            Object traverser = this.starts.next();
            traverser.setStepId(this.getNextStep().getId());
            this.barrier.add((Traverser.Admin<S>)traverser);
        }
    }

    @Override
    public boolean hasNextBarrier() {
        this.processAllStarts();
        return !this.barrier.isEmpty();
    }

    @Override
    public TraverserSet<S> nextBarrier() throws NoSuchElementException {
        this.processAllStarts();
        if (this.barrier.isEmpty()) {
            throw FastNoSuchElementException.instance();
        }
        TraverserSet<S> temp = this.barrier;
        this.barrier = this.traversal.getTraverserSetSupplier().get();
        return temp;
    }

    @Override
    public void addBarrier(TraverserSet<S> barrier) {
        this.barrier.addAll(barrier);
    }

    @Override
    public NoOpBarrierStep<S> clone() {
        NoOpBarrierStep clone = (NoOpBarrierStep)super.clone();
        clone.barrier = this.traversal.getTraverserSetSupplier().get();
        return clone;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.maxBarrierSize == Integer.MAX_VALUE ? null : Integer.valueOf(this.maxBarrierSize));
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.maxBarrierSize;
    }

    @Override
    public void reset() {
        super.reset();
        this.barrier.clear();
    }
}

