/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.AndStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.ConnectiveStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.OrStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.HasNextStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.ProfileSideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.StartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ComputerAwareStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.EmptyStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public final class ConnectiveStrategy
extends AbstractTraversalStrategy<TraversalStrategy.DecorationStrategy>
implements TraversalStrategy.DecorationStrategy {
    private static final ConnectiveStrategy INSTANCE = new ConnectiveStrategy();

    private ConnectiveStrategy() {
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        if (TraversalHelper.hasStepOfAssignableClass(ConnectiveStep.class, traversal)) {
            ConnectiveStrategy.processConnectiveMarker(traversal);
        }
    }

    private static boolean legalCurrentStep(Step<?, ?> step) {
        return !(step instanceof EmptyStep) && !(step instanceof ProfileSideEffectStep) && !(step instanceof HasNextStep) && !(step instanceof ComputerAwareStep.EndStep) && (!(step instanceof StartStep) || StartStep.isVariableStartStep(step)) && !GraphStep.isStartStep(step);
    }

    private static void processConnectiveMarker(Traversal.Admin<?, ?> traversal) {
        ConnectiveStrategy.processConjunctionMarker(OrStep.class, traversal);
        ConnectiveStrategy.processConjunctionMarker(AndStep.class, traversal);
    }

    private static void processConjunctionMarker(Class<? extends ConnectiveStep> markerClass, Traversal.Admin<?, ?> traversal) {
        List<Step> steps = traversal.getSteps();
        for (int i = 0; i < steps.size(); ++i) {
            Step nextStep;
            Step previousStep;
            ConnectiveStep currentStep;
            Step step = steps.get(i);
            if (!step.getClass().equals(markerClass) || !(currentStep = (ConnectiveStep)step).getLocalChildren().isEmpty()) continue;
            Traversal.Admin<?, ?> connectiveTraversal = __.start().asAdmin();
            currentStep.addLocalChild(connectiveTraversal);
            for (int j = i - 1; j >= 0 && ConnectiveStrategy.legalCurrentStep(previousStep = steps.get(j)); --j) {
                connectiveTraversal.addStep(0, previousStep);
                traversal.removeStep(previousStep);
                --i;
            }
            ++i;
            connectiveTraversal = ConnectiveStrategy.connectiveTraversal(connectiveTraversal, currentStep);
            currentStep.addLocalChild(connectiveTraversal);
            currentStep.getLabels().forEach(currentStep::removeLabel);
            while (i < steps.size() && ConnectiveStrategy.legalCurrentStep(nextStep = steps.get(i))) {
                if (nextStep.getClass().equals(markerClass) && ((ConnectiveStep)nextStep).getLocalChildren().isEmpty()) {
                    ConnectiveStep nextConnectiveStep = (ConnectiveStep)nextStep;
                    connectiveTraversal = ConnectiveStrategy.connectiveTraversal(connectiveTraversal, nextConnectiveStep);
                    currentStep.addLocalChild(connectiveTraversal);
                } else {
                    connectiveTraversal.addStep(nextStep);
                }
                traversal.removeStep(nextStep);
            }
            if (!(currentStep instanceof OrStep)) continue;
            currentStep.getLocalChildren().forEach(t -> ConnectiveStrategy.processConjunctionMarker(AndStep.class, t));
        }
    }

    private static Traversal.Admin<?, ?> connectiveTraversal(Traversal.Admin<?, ?> connectiveTraversal, ConnectiveStep connectiveStep) {
        Traversal.Admin traversal = __.start().asAdmin();
        Set<String> conjunctionLabels = connectiveStep.getLabels();
        if (!conjunctionLabels.isEmpty()) {
            StartStep startStep = new StartStep(connectiveTraversal);
            conjunctionLabels.forEach(startStep::addLabel);
            traversal.addStep(startStep);
        }
        return traversal;
    }

    public static ConnectiveStrategy instance() {
        return INSTANCE;
    }
}

