/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.configuration.validator;

import com.google.common.base.Preconditions;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.graphdb.configuration.JanusGraphConstants;

public class CompatibilityValidator {
    private static final String INCOMPATIBLE_VERSION_EXCEPTION = "Runtime version is incompatible with current JanusGraph version: JanusGraph [%1s] vs. runtime [%2s]";

    public static void validateBackwardCompatibilityWithTitan(String version, String localConfigurationIdsStoreName) {
        Preconditions.checkArgument((version != null ? 1 : 0) != 0, (Object)"JanusGraph version nor Titan compatibility have not been initialized");
        if (!JanusGraphConstants.TITAN_COMPATIBLE_VERSIONS.contains(version)) {
            throw new JanusGraphException(String.format(INCOMPATIBLE_VERSION_EXCEPTION, version, JanusGraphConstants.VERSION));
        }
        boolean localIdStoreIsDefault = "janusgraph_ids".equals(localConfigurationIdsStoreName);
        boolean usingTitanIdStore = localIdStoreIsDefault || "titan_ids".equals(localConfigurationIdsStoreName);
        Preconditions.checkArgument((boolean)usingTitanIdStore, (Object)"ID store for Titan compatibility has not been initialized to: titan_ids");
    }
}

