/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cache;

import com.netflix.astyanax.shaded.org.apache.cassandra.cache.ICache;
import com.netflix.astyanax.shaded.org.apache.cassandra.metrics.CacheMetrics;
import java.util.Set;

public class InstrumentingCache<K, V> {
    private volatile boolean capacitySetManually;
    private final ICache<K, V> map;
    private final String type;
    private CacheMetrics metrics;

    public InstrumentingCache(String type, ICache<K, V> map) {
        this.map = map;
        this.type = type;
        this.metrics = new CacheMetrics(type, map);
    }

    public void put(K key, V value) {
        this.map.put(key, value);
    }

    public boolean putIfAbsent(K key, V value) {
        return this.map.putIfAbsent(key, value);
    }

    public boolean replace(K key, V old, V value) {
        return this.map.replace(key, old, value);
    }

    public V get(K key) {
        V v = this.map.get(key);
        this.metrics.requests.mark();
        if (v != null) {
            this.metrics.hits.mark();
        }
        return v;
    }

    public V getInternal(K key) {
        return this.map.get(key);
    }

    public void remove(K key) {
        this.map.remove(key);
    }

    public long getCapacity() {
        return this.map.capacity();
    }

    public boolean isCapacitySetManually() {
        return this.capacitySetManually;
    }

    public void updateCapacity(long capacity) {
        this.map.setCapacity(capacity);
    }

    public void setCapacity(long capacity) {
        this.updateCapacity(capacity);
        this.capacitySetManually = true;
    }

    public int size() {
        return this.map.size();
    }

    public long weightedSize() {
        return this.map.weightedSize();
    }

    public void clear() {
        this.map.clear();
        this.metrics = new CacheMetrics(this.type, this.map);
    }

    public Set<K> getKeySet() {
        return this.map.keySet();
    }

    public Set<K> hotKeySet(int n) {
        return this.map.hotKeySet(n);
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public CacheMetrics getMetrics() {
        return this.metrics;
    }
}

