/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cache;

import com.netflix.astyanax.shaded.org.apache.cassandra.cache.ICache;
import com.netflix.astyanax.shaded.org.apache.cassandra.cache.IRowCacheEntry;
import com.netflix.astyanax.shaded.org.apache.cassandra.cache.RowCacheKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.cache.RowCacheSentinel;
import com.netflix.astyanax.shaded.org.apache.cassandra.cache.SerializingCache;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.ISerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SerializingCacheProvider {
    public ICache<RowCacheKey, IRowCacheEntry> create(long capacity) {
        return SerializingCache.create(capacity, new RowCacheSerializer());
    }

    static class RowCacheSerializer
    implements ISerializer<IRowCacheEntry> {
        RowCacheSerializer() {
        }

        @Override
        public void serialize(IRowCacheEntry entry, DataOutput out) throws IOException {
            assert (entry != null);
            boolean isSentinel = entry instanceof RowCacheSentinel;
            out.writeBoolean(isSentinel);
            if (isSentinel) {
                out.writeLong(((RowCacheSentinel)entry).sentinelId);
            } else {
                ColumnFamily.serializer.serialize((ColumnFamily)entry, out, 7);
            }
        }

        @Override
        public IRowCacheEntry deserialize(DataInput in) throws IOException {
            boolean isSentinel = in.readBoolean();
            if (isSentinel) {
                return new RowCacheSentinel(in.readLong());
            }
            return ColumnFamily.serializer.deserialize(in, 7);
        }

        @Override
        public long serializedSize(IRowCacheEntry entry, TypeSizes typeSizes) {
            int size = typeSizes.sizeof(true);
            size = entry instanceof RowCacheSentinel ? (size += typeSizes.sizeof(((RowCacheSentinel)entry).sentinelId)) : (int)((long)size + ColumnFamily.serializer.serializedSize((ColumnFamily)entry, typeSizes, 7));
            return size;
        }
    }
}

