/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3;

import com.netflix.astyanax.shaded.org.apache.cassandra.auth.IAuthenticator;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.FBUtilities;
import java.util.HashMap;
import java.util.Map;

public class UserOptions {
    private final Map<IAuthenticator.Option, Object> options = new HashMap<IAuthenticator.Option, Object>();

    public void put(String name, Object value) {
        this.options.put(IAuthenticator.Option.valueOf(name.toUpperCase()), value);
    }

    public boolean isEmpty() {
        return this.options.isEmpty();
    }

    public Map<IAuthenticator.Option, Object> getOptions() {
        return this.options;
    }

    public void validate() throws InvalidRequestException {
        for (IAuthenticator.Option option : this.options.keySet()) {
            if (DatabaseDescriptor.getAuthenticator().supportedOptions().contains((Object)option)) continue;
            throw new InvalidRequestException(String.format("%s doesn't support %s option", new Object[]{DatabaseDescriptor.getAuthenticator().getClass().getName(), option}));
        }
    }

    public String toString() {
        return FBUtilities.toString(this.options);
    }
}

