/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements;

import com.netflix.astyanax.shaded.org.apache.cassandra.auth.Permission;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.DatabaseDescriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.KSPropDefs;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.AlreadyExistsException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.ConfigurationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestValidationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.UnauthorizedException;
import com.netflix.astyanax.shaded.org.apache.cassandra.locator.AbstractReplicationStrategy;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.ClientState;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.MigrationManager;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.StorageService;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.ThriftValidation;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ResultMessage;

public class CreateKeyspaceStatement
extends SchemaAlteringStatement {
    private final String name;
    private final KSPropDefs attrs;
    private final boolean ifNotExists;

    public CreateKeyspaceStatement(String name, KSPropDefs attrs, boolean ifNotExists) {
        this.name = name;
        this.attrs = attrs;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public String keyspace() {
        return this.name;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException {
        state.hasAllKeyspacesAccess(Permission.CREATE);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        ThriftValidation.validateKeyspaceNotSystem(this.name);
        if (!this.name.matches("\\w+")) {
            throw new InvalidRequestException(String.format("\"%s\" is not a valid keyspace name", this.name));
        }
        if (this.name.length() > 48) {
            throw new InvalidRequestException(String.format("Keyspace names shouldn't be more than %s characters long (got \"%s\")", 48, this.name));
        }
        this.attrs.validate();
        if (this.attrs.getReplicationStrategyClass() == null) {
            throw new ConfigurationException("Missing mandatory replication strategy class");
        }
        AbstractReplicationStrategy.validateReplicationStrategy(this.name, AbstractReplicationStrategy.getClass(this.attrs.getReplicationStrategyClass()), StorageService.instance.getTokenMetadata(), DatabaseDescriptor.getEndpointSnitch(), this.attrs.getReplicationOptions());
    }

    @Override
    public boolean announceMigration() throws RequestValidationException {
        try {
            MigrationManager.announceNewKeyspace(this.attrs.asKSMetadata(this.name));
            return true;
        }
        catch (AlreadyExistsException e) {
            if (this.ifNotExists) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public ResultMessage.SchemaChange.Change changeType() {
        return ResultMessage.SchemaChange.Change.CREATED;
    }
}

