/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements;

import com.netflix.astyanax.shaded.org.apache.cassandra.config.CFMetaData;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.Schema;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CFName;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.ConfigurationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestValidationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.UnauthorizedException;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.ClientState;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.MigrationManager;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.ThriftValidation;
import com.netflix.astyanax.shaded.org.apache.cassandra.transport.messages.ResultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropTriggerStatement
extends SchemaAlteringStatement {
    private static final Logger logger = LoggerFactory.getLogger(DropTriggerStatement.class);
    private final String triggerName;

    public DropTriggerStatement(CFName name, String triggerName) {
        super(name);
        this.triggerName = triggerName;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException {
        state.ensureIsSuper("Only superusers are allowed to perfrom DROP TRIGGER queries");
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
    }

    @Override
    public boolean announceMigration() throws ConfigurationException {
        CFMetaData cfm = Schema.instance.getCFMetaData(this.keyspace(), this.columnFamily()).clone();
        if (!cfm.removeTrigger(this.triggerName)) {
            throw new ConfigurationException(String.format("Trigger %s was not found", this.triggerName));
        }
        logger.info("Dropping trigger with name {}", (Object)this.triggerName);
        MigrationManager.announceColumnFamilyUpdate(cfm, false);
        return true;
    }

    @Override
    public ResultMessage.SchemaChange.Change changeType() {
        return ResultMessage.SchemaChange.Change.UPDATED;
    }
}

