/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db;

import com.google.common.base.Function;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.CFMetaData;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Column;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DeletionInfo;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DeletionTime;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RangeTombstone;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.ColumnSlice;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.index.SecondaryIndexManager;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Allocator;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Pair;
import edu.stanford.ppl.concurrent.SnapTreeMap;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicReference;

public class AtomicSortedColumns
extends ColumnFamily {
    private final AtomicReference<Holder> ref;
    private static final boolean enableColUpdateTimeDelta = Boolean.parseBoolean(System.getProperty("cassandra.enableColUpdateTimeDelta", "false"));
    public static final ColumnFamily.Factory<AtomicSortedColumns> factory = new ColumnFamily.Factory<AtomicSortedColumns>(){

        @Override
        public AtomicSortedColumns create(CFMetaData metadata, boolean insertReversed) {
            return new AtomicSortedColumns(metadata);
        }
    };

    private AtomicSortedColumns(CFMetaData metadata) {
        this(metadata, new Holder(metadata.comparator));
    }

    private AtomicSortedColumns(CFMetaData metadata, Holder holder) {
        super(metadata);
        this.ref = new AtomicReference<Holder>(holder);
    }

    @Override
    public AbstractType<?> getComparator() {
        return (AbstractType)this.ref.get().map.comparator();
    }

    @Override
    public ColumnFamily.Factory getFactory() {
        return factory;
    }

    @Override
    public ColumnFamily cloneMe() {
        return new AtomicSortedColumns(this.metadata, this.ref.get().cloneMe());
    }

    @Override
    public DeletionInfo deletionInfo() {
        return this.ref.get().deletionInfo;
    }

    @Override
    public void delete(DeletionTime delTime) {
        this.delete(new DeletionInfo(delTime));
    }

    @Override
    protected void delete(RangeTombstone tombstone) {
        this.delete(new DeletionInfo(tombstone, this.getComparator()));
    }

    @Override
    public void delete(DeletionInfo info) {
        DeletionInfo newDelInfo;
        Holder current;
        if (info.isLive()) {
            return;
        }
        while (!this.ref.compareAndSet(current = this.ref.get(), current.with(newDelInfo = current.deletionInfo.copy().add(info)))) {
        }
    }

    @Override
    public void setDeletionInfo(DeletionInfo newInfo) {
        this.ref.set(this.ref.get().with(newInfo));
    }

    @Override
    public void purgeTombstones(int gcBefore) {
        DeletionInfo purgedInfo;
        Holder current;
        do {
            current = this.ref.get();
            if (!current.deletionInfo.hasPurgeableTombstones(gcBefore)) break;
            purgedInfo = current.deletionInfo.copy();
            purgedInfo.purge(gcBefore);
        } while (!this.ref.compareAndSet(current, current.with(purgedInfo)));
    }

    @Override
    public void addColumn(Column column, Allocator allocator) {
        Holder modified;
        Holder current;
        do {
            current = this.ref.get();
            modified = current.cloneMe();
            modified.addColumn(column, allocator, SecondaryIndexManager.nullUpdater);
        } while (!this.ref.compareAndSet(current, modified));
    }

    @Override
    public void addAll(ColumnFamily cm, Allocator allocator, Function<Column, Column> transformation) {
        this.addAllWithSizeDelta(cm, allocator, transformation, SecondaryIndexManager.nullUpdater);
    }

    public Pair<Long, Long> addAllWithSizeDelta(ColumnFamily cm, Allocator allocator, Function<Column, Column> transformation, SecondaryIndexManager.Updater indexer) {
        long timeDelta;
        long sizeDelta;
        Holder modified;
        Holder current;
        block0: do {
            sizeDelta = 0L;
            timeDelta = Long.MAX_VALUE;
            current = this.ref.get();
            DeletionInfo newDelInfo = current.deletionInfo;
            if (cm.deletionInfo().mayModify(newDelInfo)) {
                newDelInfo = current.deletionInfo.copy().add(cm.deletionInfo());
                sizeDelta += (long)(newDelInfo.dataSize() - current.deletionInfo.dataSize());
            }
            modified = new Holder((SnapTreeMap<ByteBuffer, Column>)current.map.clone(), newDelInfo);
            for (Column column : cm) {
                Pair<Integer, Long> pair = modified.addColumn((Column)transformation.apply((Object)column), allocator, indexer);
                sizeDelta += (long)((Integer)pair.left).intValue();
                if (enableColUpdateTimeDelta) {
                    timeDelta = Math.min((Long)pair.right, timeDelta);
                }
                if (this.ref.get() == current) continue;
                continue block0;
            }
        } while (!this.ref.compareAndSet(current, modified));
        indexer.updateRowLevelIndexes();
        return Pair.create(sizeDelta, timeDelta);
    }

    @Override
    public boolean replace(Column oldColumn, Column newColumn) {
        boolean replaced;
        Holder modified;
        Holder current;
        if (!oldColumn.name().equals(newColumn.name())) {
            throw new IllegalArgumentException();
        }
        do {
            current = this.ref.get();
            modified = current.cloneMe();
            replaced = modified.map.replace((Object)oldColumn.name(), (Object)oldColumn, (Object)newColumn);
        } while (!this.ref.compareAndSet(current, modified));
        return replaced;
    }

    @Override
    public void clear() {
        Holder modified;
        Holder current;
        while (!this.ref.compareAndSet(current = this.ref.get(), modified = current.clear())) {
        }
    }

    @Override
    public Column getColumn(ByteBuffer name) {
        return (Column)this.ref.get().map.get((Object)name);
    }

    public SortedSet<ByteBuffer> getColumnNames() {
        return this.ref.get().map.keySet();
    }

    @Override
    public Collection<Column> getSortedColumns() {
        return this.ref.get().map.values();
    }

    @Override
    public Collection<Column> getReverseSortedColumns() {
        return this.ref.get().map.descendingMap().values();
    }

    @Override
    public int getColumnCount() {
        return this.ref.get().map.size();
    }

    @Override
    public Iterator<Column> iterator(ColumnSlice[] slices) {
        return new ColumnSlice.NavigableMapIterator((NavigableMap<ByteBuffer, Column>)this.ref.get().map, slices);
    }

    @Override
    public Iterator<Column> reverseIterator(ColumnSlice[] slices) {
        return new ColumnSlice.NavigableMapIterator(this.ref.get().map.descendingMap(), slices);
    }

    @Override
    public boolean isInsertReversed() {
        return false;
    }

    private static class Holder {
        private static final DeletionInfo LIVE = DeletionInfo.live();
        final SnapTreeMap<ByteBuffer, Column> map;
        final DeletionInfo deletionInfo;

        Holder(AbstractType<?> comparator) {
            this((SnapTreeMap<ByteBuffer, Column>)new SnapTreeMap(comparator), LIVE);
        }

        Holder(SnapTreeMap<ByteBuffer, Column> map, DeletionInfo deletionInfo) {
            this.map = map;
            this.deletionInfo = deletionInfo;
        }

        Holder cloneMe() {
            return this.with((SnapTreeMap<ByteBuffer, Column>)this.map.clone());
        }

        Holder with(DeletionInfo info) {
            return new Holder(this.map, info);
        }

        Holder with(SnapTreeMap<ByteBuffer, Column> newMap) {
            return new Holder(newMap, this.deletionInfo);
        }

        Holder clear() {
            return new Holder((SnapTreeMap<ByteBuffer, Column>)new SnapTreeMap(this.map.comparator()), LIVE);
        }

        Pair<Integer, Long> addColumn(Column column, Allocator allocator, SecondaryIndexManager.Updater indexer) {
            Column reconciledColumn;
            Column oldColumn;
            ByteBuffer name = column.name();
            do {
                if ((oldColumn = (Column)this.map.putIfAbsent((Object)name, (Object)column)) != null) continue;
                indexer.insert(column);
                return Pair.create(column.dataSize(), Long.MAX_VALUE);
            } while (!this.map.replace((Object)name, (Object)oldColumn, (Object)(reconciledColumn = column.reconcile(oldColumn, allocator))));
            indexer.update(oldColumn, reconciledColumn);
            return Pair.create(reconciledColumn.dataSize() - oldColumn.dataSize(), enableColUpdateTimeDelta ? Math.abs(oldColumn.timestamp - column.timestamp) : Long.MAX_VALUE);
        }
    }
}

