/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.SnapshotCommand;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.IVersionedSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

class SnapshotCommandSerializer
implements IVersionedSerializer<SnapshotCommand> {
    SnapshotCommandSerializer() {
    }

    @Override
    public void serialize(SnapshotCommand snapshot_command, DataOutput out, int version) throws IOException {
        out.writeUTF(snapshot_command.keyspace);
        out.writeUTF(snapshot_command.column_family);
        out.writeUTF(snapshot_command.snapshot_name);
        out.writeBoolean(snapshot_command.clear_snapshot);
    }

    @Override
    public SnapshotCommand deserialize(DataInput in, int version) throws IOException {
        String keyspace = in.readUTF();
        String column_family = in.readUTF();
        String snapshot_name = in.readUTF();
        boolean clear_snapshot = in.readBoolean();
        return new SnapshotCommand(keyspace, column_family, snapshot_name, clear_snapshot);
    }

    @Override
    public long serializedSize(SnapshotCommand sc, int version) {
        return TypeSizes.NATIVE.sizeof(sc.keyspace) + TypeSizes.NATIVE.sizeof(sc.column_family) + TypeSizes.NATIVE.sizeof(sc.snapshot_name) + TypeSizes.NATIVE.sizeof(sc.clear_snapshot);
    }
}

