/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal;

import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.CQL3Type;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.DoubleSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.MarshalException;
import com.netflix.astyanax.shaded.org.apache.cassandra.serializers.TypeSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.nio.ByteBuffer;

public class DoubleType
extends AbstractType<Double> {
    public static final DoubleType instance = new DoubleType();

    DoubleType() {
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        if (o1.remaining() == 0) {
            return o2.remaining() == 0 ? 0 : -1;
        }
        if (o2.remaining() == 0) {
            return 1;
        }
        return ((Double)this.compose(o1)).compareTo((Double)this.compose(o2));
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        Double d;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            d = Double.valueOf(source);
        }
        catch (NumberFormatException e1) {
            throw new MarshalException(String.format("unable to coerce '%s' to a double", source), e1);
        }
        return this.decompose(d);
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.DOUBLE;
    }

    @Override
    public TypeSerializer<Double> getSerializer() {
        return DoubleSerializer.instance;
    }
}

