/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.gms;

import com.netflix.astyanax.shaded.org.apache.cassandra.gms.ApplicationState;
import com.netflix.astyanax.shaded.org.apache.cassandra.gms.EndpointStateSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.gms.HeartBeatState;
import com.netflix.astyanax.shaded.org.apache.cassandra.gms.VersionedValue;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.IVersionedSerializer;
import java.util.Map;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointState {
    protected static final Logger logger = LoggerFactory.getLogger(EndpointState.class);
    public static final IVersionedSerializer<EndpointState> serializer = new EndpointStateSerializer();
    private volatile HeartBeatState hbState;
    final Map<ApplicationState, VersionedValue> applicationState = new NonBlockingHashMap();
    private volatile long updateTimestamp;
    private volatile boolean isAlive;

    EndpointState(HeartBeatState initialHbState) {
        this.hbState = initialHbState;
        this.updateTimestamp = System.nanoTime();
        this.isAlive = true;
    }

    HeartBeatState getHeartBeatState() {
        return this.hbState;
    }

    void setHeartBeatState(HeartBeatState newHbState) {
        this.updateTimestamp();
        this.hbState = newHbState;
    }

    public VersionedValue getApplicationState(ApplicationState key) {
        return this.applicationState.get((Object)key);
    }

    @Deprecated
    public Map<ApplicationState, VersionedValue> getApplicationStateMap() {
        return this.applicationState;
    }

    void addApplicationState(ApplicationState key, VersionedValue value) {
        this.applicationState.put(key, value);
    }

    public long getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    void updateTimestamp() {
        this.updateTimestamp = System.nanoTime();
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    void markAlive() {
        this.isAlive = true;
    }

    void markDead() {
        this.isAlive = false;
    }

    public String toString() {
        return "EndpointState: HeartBeatState = " + this.hbState + ", AppStateMap = " + this.applicationState;
    }
}

