/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.hadoop;

import com.netflix.astyanax.shaded.org.apache.cassandra.hadoop.ConfigHelper;
import com.netflix.astyanax.shaded.org.apache.cassandra.hadoop.HadoopCompat;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.AuthenticationRequest;
import com.netflix.astyanax.shaded.org.apache.cassandra.thrift.Cassandra;
import java.io.IOException;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractColumnFamilyOutputFormat<K, Y>
extends OutputFormat<K, Y>
implements org.apache.hadoop.mapred.OutputFormat<K, Y> {
    public static final String BATCH_THRESHOLD = "mapreduce.output.columnfamilyoutputformat.batch.threshold";
    public static final String QUEUE_SIZE = "mapreduce.output.columnfamilyoutputformat.queue.size";
    private static final Logger logger = LoggerFactory.getLogger(AbstractColumnFamilyOutputFormat.class);

    public void checkOutputSpecs(JobContext context) {
        this.checkOutputSpecs(HadoopCompat.getConfiguration(context));
    }

    protected void checkOutputSpecs(Configuration conf) {
        if (ConfigHelper.getOutputKeyspace(conf) == null) {
            throw new UnsupportedOperationException("You must set the keyspace with setOutputKeyspace()");
        }
        if (ConfigHelper.getOutputPartitioner(conf) == null) {
            throw new UnsupportedOperationException("You must set the output partitioner to the one used by your Cassandra cluster");
        }
        if (ConfigHelper.getOutputInitialAddress(conf) == null) {
            throw new UnsupportedOperationException("You must set the initial output address to a Cassandra node");
        }
    }

    @Deprecated
    public void checkOutputSpecs(FileSystem filesystem, JobConf job) throws IOException {
        this.checkOutputSpecs((Configuration)job);
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new NullOutputCommitter();
    }

    public static Cassandra.Client createAuthenticatedClient(String host, int port, Configuration conf) throws Exception {
        logger.debug("Creating authenticated client for CF output format");
        TTransport transport = ConfigHelper.getClientTransportFactory(conf).openTransport(host, port);
        TBinaryProtocol binaryProtocol = new TBinaryProtocol(transport, true, true);
        Cassandra.Client client = new Cassandra.Client((TProtocol)binaryProtocol);
        client.set_keyspace(ConfigHelper.getOutputKeyspace(conf));
        String user = ConfigHelper.getOutputKeyspaceUserName(conf);
        String password = ConfigHelper.getOutputKeyspacePassword(conf);
        if (user != null && password != null) {
            AbstractColumnFamilyOutputFormat.login(user, password, client);
        }
        logger.debug("Authenticated client for CF output format created successfully");
        return client;
    }

    public static void login(String user, String password, Cassandra.Client client) throws Exception {
        HashMap<String, String> creds = new HashMap<String, String>();
        creds.put("username", user);
        creds.put("password", password);
        AuthenticationRequest authRequest = new AuthenticationRequest(creds);
        client.login(authRequest);
    }

    private static class NullOutputCommitter
    extends OutputCommitter {
        private NullOutputCommitter() {
        }

        public void abortTask(TaskAttemptContext taskContext) {
        }

        public void cleanupJob(JobContext jobContext) {
        }

        public void commitTask(TaskAttemptContext taskContext) {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskContext) {
            return false;
        }

        public void setupJob(JobContext jobContext) {
        }

        public void setupTask(TaskAttemptContext taskContext) {
        }
    }
}

