/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable;

import com.google.common.collect.AbstractIterator;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.DecoratedKey;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RowIndexEntry;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.Descriptor;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.SSTable;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.RandomAccessReader;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.StorageService;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.CloseableIterator;
import java.io.File;
import java.io.IOException;

public class KeyIterator
extends AbstractIterator<DecoratedKey>
implements CloseableIterator<DecoratedKey> {
    private final RandomAccessReader in;

    public KeyIterator(Descriptor desc) {
        File path = new File(desc.filenameFor(SSTable.COMPONENT_INDEX));
        this.in = RandomAccessReader.open(path);
    }

    protected DecoratedKey computeNext() {
        try {
            if (this.in.isEOF()) {
                return (DecoratedKey)this.endOfData();
            }
            DecoratedKey key = StorageService.getPartitioner().decorateKey(ByteBufferUtil.readWithShortLength(this.in));
            RowIndexEntry.serializer.skip(this.in);
            return key;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.in.close();
    }

    public long getBytesRead() {
        return this.in.getFilePointer();
    }

    public long getTotalBytes() {
        return this.in.length();
    }
}

