/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.locator;

import com.netflix.astyanax.shaded.org.apache.cassandra.dht.Token;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.ConfigurationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.locator.AbstractReplicationStrategy;
import com.netflix.astyanax.shaded.org.apache.cassandra.locator.IEndpointSnitch;
import com.netflix.astyanax.shaded.org.apache.cassandra.locator.TokenMetadata;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SimpleStrategy
extends AbstractReplicationStrategy {
    public SimpleStrategy(String keyspaceName, TokenMetadata tokenMetadata, IEndpointSnitch snitch, Map<String, String> configOptions) {
        super(keyspaceName, tokenMetadata, snitch, configOptions);
    }

    @Override
    public List<InetAddress> calculateNaturalEndpoints(Token token, TokenMetadata metadata) {
        int replicas = this.getReplicationFactor();
        ArrayList<Token> tokens = metadata.sortedTokens();
        ArrayList<InetAddress> endpoints = new ArrayList<InetAddress>(replicas);
        if (tokens.isEmpty()) {
            return endpoints;
        }
        Iterator<Token> iter = TokenMetadata.ringIterator(tokens, token, false);
        while (endpoints.size() < replicas && iter.hasNext()) {
            InetAddress ep = metadata.getEndpoint(iter.next());
            if (endpoints.contains(ep)) continue;
            endpoints.add(ep);
        }
        return endpoints;
    }

    @Override
    public int getReplicationFactor() {
        return Integer.parseInt((String)this.configOptions.get("replication_factor"));
    }

    @Override
    public void validateOptions() throws ConfigurationException {
        String rf = (String)this.configOptions.get("replication_factor");
        if (rf == null) {
            throw new ConfigurationException("SimpleStrategy requires a replication_factor strategy option.");
        }
        this.validateReplicationFactor(rf);
    }

    @Override
    public Collection<String> recognizedOptions() {
        return Collections.singleton("replication_factor");
    }
}

