/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.metrics;

import com.netflix.astyanax.shaded.org.apache.cassandra.cache.ICache;
import com.netflix.astyanax.shaded.org.apache.cassandra.metrics.DefaultNameFactory;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.util.RatioGauge;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class CacheMetrics {
    public final Gauge<Long> capacity;
    public final Meter hits;
    public final Meter requests;
    public final Gauge<Double> hitRate;
    public final Gauge<Long> size;
    public final Gauge<Integer> entries;
    private final AtomicLong lastRequests = new AtomicLong(0L);
    private final AtomicLong lastHits = new AtomicLong(0L);

    public CacheMetrics(String type, final ICache cache) {
        DefaultNameFactory factory = new DefaultNameFactory("Cache", type);
        this.capacity = Metrics.newGauge((MetricName)factory.createMetricName("Capacity"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cache.capacity();
            }
        });
        this.hits = Metrics.newMeter((MetricName)factory.createMetricName("Hits"), (String)"hits", (TimeUnit)TimeUnit.SECONDS);
        this.requests = Metrics.newMeter((MetricName)factory.createMetricName("Requests"), (String)"requests", (TimeUnit)TimeUnit.SECONDS);
        this.hitRate = Metrics.newGauge((MetricName)factory.createMetricName("HitRate"), (Gauge)new RatioGauge(){

            protected double getNumerator() {
                return CacheMetrics.this.hits.count();
            }

            protected double getDenominator() {
                return CacheMetrics.this.requests.count();
            }
        });
        this.size = Metrics.newGauge((MetricName)factory.createMetricName("Size"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cache.weightedSize();
            }
        });
        this.entries = Metrics.newGauge((MetricName)factory.createMetricName("Entries"), (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return cache.size();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public double getRecentHitRate() {
        long r = this.requests.count();
        long h = this.hits.count();
        try {
            double d = (double)(h - this.lastHits.get()) / (double)(r - this.lastRequests.get());
            return d;
        }
        finally {
            this.lastRequests.set(r);
            this.lastHits.set(h);
        }
    }
}

