/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.net;

import com.netflix.astyanax.shaded.org.apache.cassandra.net.IAsyncCallback;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageIn;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AsyncOneResponse<T>
implements IAsyncCallback<T> {
    private T result;
    private boolean done;
    private final long start = System.nanoTime();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(long timeout, TimeUnit tu) throws TimeoutException {
        timeout = tu.toNanos(timeout);
        boolean interrupted = false;
        try {
            AsyncOneResponse asyncOneResponse = this;
            synchronized (asyncOneResponse) {
                while (!this.done) {
                    try {
                        long overallTimeout = timeout - (System.nanoTime() - this.start);
                        if (overallTimeout <= 0L) {
                            throw new TimeoutException("Operation timed out.");
                        }
                        TimeUnit.NANOSECONDS.timedWait(this, overallTimeout);
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return this.result;
    }

    @Override
    public synchronized void response(MessageIn<T> response) {
        if (!this.done) {
            this.result = response.payload;
            this.done = true;
            this.notifyAll();
        }
    }

    @Override
    public boolean isLatencyForSnitch() {
        return false;
    }
}

