/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.service;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.Keyspace;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.SnapshotCommand;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.IVerbHandler;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageIn;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageOut;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotVerbHandler
implements IVerbHandler<SnapshotCommand> {
    private static final Logger logger = LoggerFactory.getLogger(SnapshotVerbHandler.class);

    @Override
    public void doVerb(MessageIn<SnapshotCommand> message, int id) {
        SnapshotCommand command = (SnapshotCommand)message.payload;
        if (command.clear_snapshot) {
            Keyspace.clearSnapshot(command.snapshot_name, command.keyspace);
        } else {
            Keyspace.open(command.keyspace).getColumnFamilyStore(command.column_family).snapshot(command.snapshot_name);
        }
        logger.debug("Enqueuing response to snapshot request {} to {}", (Object)command.snapshot_name, (Object)message.from);
        MessagingService.instance().sendReply(new MessageOut(MessagingService.Verb.INTERNAL_RESPONSE), id, message.from);
    }
}

