/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.service.pager;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Keyspace;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.Row;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.SliceByNamesReadCommand;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.filter.ColumnCounter;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestExecutionException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.RequestValidationException;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.StorageProxy;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.pager.PagingState;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.pager.SinglePartitionPager;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;

public class NamesQueryPager
implements SinglePartitionPager {
    private final SliceByNamesReadCommand command;
    private final ConsistencyLevel consistencyLevel;
    private final boolean localQuery;
    private volatile boolean queried;

    NamesQueryPager(SliceByNamesReadCommand command, ConsistencyLevel consistencyLevel, boolean localQuery) {
        this.command = command;
        this.consistencyLevel = consistencyLevel;
        this.localQuery = localQuery;
    }

    @Override
    public ByteBuffer key() {
        return this.command.key;
    }

    @Override
    public ColumnCounter columnCounter() {
        return this.command.filter.columnCounter(null, this.command.timestamp);
    }

    @Override
    public PagingState state() {
        return null;
    }

    @Override
    public boolean isExhausted() {
        return this.queried;
    }

    @Override
    public List<Row> fetchPage(int pageSize) throws RequestValidationException, RequestExecutionException {
        assert (this.command.filter.countCQL3Rows() || this.command.filter.columns.size() <= pageSize);
        if (this.isExhausted()) {
            return Collections.emptyList();
        }
        this.queried = true;
        return this.localQuery ? Collections.singletonList(this.command.getRow(Keyspace.open(this.command.ksName))) : StorageProxy.read(Collections.singletonList(this.command), this.consistencyLevel);
    }

    @Override
    public int maxRemaining() {
        if (this.queried) {
            return 0;
        }
        return this.command.filter.countCQL3Rows() ? 1 : this.command.filter.columns.size();
    }

    public long timestamp() {
        return this.command.timestamp;
    }
}

