/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.streaming.compress;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.IVersionedSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.compress.CompressionMetadata;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.compress.CompressionParameters;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CompressionInfo {
    public static final IVersionedSerializer<CompressionInfo> serializer = new CompressionInfoSerializer();
    public final CompressionMetadata.Chunk[] chunks;
    public final CompressionParameters parameters;

    public CompressionInfo(CompressionMetadata.Chunk[] chunks, CompressionParameters parameters) {
        assert (chunks != null && parameters != null);
        this.chunks = chunks;
        this.parameters = parameters;
    }

    static class CompressionInfoSerializer
    implements IVersionedSerializer<CompressionInfo> {
        CompressionInfoSerializer() {
        }

        @Override
        public void serialize(CompressionInfo info, DataOutput out, int version) throws IOException {
            if (info == null) {
                out.writeInt(-1);
                return;
            }
            int chunkCount = info.chunks.length;
            out.writeInt(chunkCount);
            for (int i = 0; i < chunkCount; ++i) {
                CompressionMetadata.Chunk.serializer.serialize(info.chunks[i], out, version);
            }
            CompressionParameters.serializer.serialize(info.parameters, out, version);
        }

        @Override
        public CompressionInfo deserialize(DataInput in, int version) throws IOException {
            int chunkCount = in.readInt();
            if (chunkCount < 0) {
                return null;
            }
            CompressionMetadata.Chunk[] chunks = new CompressionMetadata.Chunk[chunkCount];
            for (int i = 0; i < chunkCount; ++i) {
                chunks[i] = CompressionMetadata.Chunk.serializer.deserialize(in, version);
            }
            CompressionParameters parameters = CompressionParameters.serializer.deserialize(in, version);
            return new CompressionInfo(chunks, parameters);
        }

        @Override
        public long serializedSize(CompressionInfo info, int version) {
            if (info == null) {
                return TypeSizes.NATIVE.sizeof(-1);
            }
            int chunkCount = info.chunks.length;
            long size = TypeSizes.NATIVE.sizeof(chunkCount);
            for (int i = 0; i < chunkCount; ++i) {
                size += CompressionMetadata.Chunk.serializer.serializedSize(info.chunks[i], version);
            }
            return size += CompressionParameters.serializer.serializedSize(info.parameters, version);
        }
    }
}

