/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.streaming.messages;

import com.netflix.astyanax.shaded.org.apache.cassandra.io.sstable.SSTableWriter;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamReader;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamSession;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.compress.CompressedStreamReader;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.messages.FileMessageHeader;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.messages.StreamMessage;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class IncomingFileMessage
extends StreamMessage {
    public static StreamMessage.Serializer<IncomingFileMessage> serializer = new StreamMessage.Serializer<IncomingFileMessage>(){

        @Override
        public IncomingFileMessage deserialize(ReadableByteChannel in, int version, StreamSession session) throws IOException {
            DataInputStream input = new DataInputStream(Channels.newInputStream(in));
            FileMessageHeader header = FileMessageHeader.serializer.deserialize(input, version);
            StreamReader reader = header.compressionInfo == null ? new StreamReader(header, session) : new CompressedStreamReader(header, session);
            try {
                return new IncomingFileMessage(reader.read(in), header);
            }
            catch (IOException eof) {
                throw eof;
            }
            catch (Throwable e) {
                Throwable cause = e;
                while ((cause = cause.getCause()) != null) {
                    if (!(cause instanceof IOException)) continue;
                    throw (IOException)cause;
                }
                session.doRetry(header, e);
                return null;
            }
        }

        @Override
        public void serialize(IncomingFileMessage message, WritableByteChannel out, int version, StreamSession session) throws IOException {
            throw new UnsupportedOperationException("Not allowed to call serialize on an incoming file");
        }
    };
    public FileMessageHeader header;
    public SSTableWriter sstable;

    public IncomingFileMessage(SSTableWriter sstable, FileMessageHeader header) {
        super(StreamMessage.Type.FILE);
        this.header = header;
        this.sstable = sstable;
    }

    public String toString() {
        return "File (" + this.header + ", file: " + this.sstable.getFilename() + ")";
    }
}

