/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.streaming.messages;

import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamRequest;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamSession;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.StreamSummary;
import com.netflix.astyanax.shaded.org.apache.cassandra.streaming.messages.StreamMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;

public class PrepareMessage
extends StreamMessage {
    public static StreamMessage.Serializer<PrepareMessage> serializer = new StreamMessage.Serializer<PrepareMessage>(){

        @Override
        public PrepareMessage deserialize(ReadableByteChannel in, int version, StreamSession session) throws IOException {
            DataInputStream input = new DataInputStream(Channels.newInputStream(in));
            PrepareMessage message = new PrepareMessage();
            int numRequests = input.readInt();
            for (int i = 0; i < numRequests; ++i) {
                message.requests.add(StreamRequest.serializer.deserialize(input, version));
            }
            int numSummaries = input.readInt();
            for (int i = 0; i < numSummaries; ++i) {
                message.summaries.add(StreamSummary.serializer.deserialize(input, version));
            }
            return message;
        }

        @Override
        public void serialize(PrepareMessage message, WritableByteChannel out, int version, StreamSession session) throws IOException {
            DataOutputStream output = new DataOutputStream(Channels.newOutputStream(out));
            output.writeInt(message.requests.size());
            for (StreamRequest request : message.requests) {
                StreamRequest.serializer.serialize(request, output, version);
            }
            output.writeInt(message.summaries.size());
            for (StreamSummary summary : message.summaries) {
                StreamSummary.serializer.serialize(summary, output, version);
            }
        }
    };
    public final Collection<StreamRequest> requests = new ArrayList<StreamRequest>();
    public final Collection<StreamSummary> summaries = new ArrayList<StreamSummary>();

    public PrepareMessage() {
        super(StreamMessage.Type.PREPARE);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Prepare (");
        sb.append(this.requests.size()).append(" requests, ");
        int totalFile = 0;
        for (StreamSummary summary : this.summaries) {
            totalFile += summary.files;
        }
        sb.append(" ").append(totalFile).append(" files");
        sb.append('}');
        return sb.toString();
    }
}

