/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.tracing;

import com.netflix.astyanax.shaded.org.apache.cassandra.concurrent.Stage;
import com.netflix.astyanax.shaded.org.apache.cassandra.concurrent.StageManager;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.CFMetaData;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql3.ColumnNameBuilder;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ArrayBackedSortedColumns;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ConsistencyLevel;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RowMutation;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.TreeMapBackedSortedColumns;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.TimeUUIDType;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.OverloadedException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.UnavailableException;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.WriteTimeoutException;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessageIn;
import com.netflix.astyanax.shaded.org.apache.cassandra.net.MessagingService;
import com.netflix.astyanax.shaded.org.apache.cassandra.service.StorageProxy;
import com.netflix.astyanax.shaded.org.apache.cassandra.tracing.ExpiredTraceState;
import com.netflix.astyanax.shaded.org.apache.cassandra.tracing.TraceState;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.FBUtilities;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.UUIDGen;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tracing {
    public static final String TRACE_KS = "system_traces";
    public static final String EVENTS_CF = "events";
    public static final String SESSIONS_CF = "sessions";
    public static final String TRACE_HEADER = "TraceSession";
    private static final Logger logger = LoggerFactory.getLogger(Tracing.class);
    private final InetAddress localAddress = FBUtilities.getLocalAddress();
    private final ThreadLocal<TraceState> state = new ThreadLocal();
    private final ConcurrentMap<UUID, TraceState> sessions = new ConcurrentHashMap<UUID, TraceState>();
    public static final Tracing instance = new Tracing();

    public static void addColumn(ColumnFamily cf, ByteBuffer name, InetAddress address) {
        Tracing.addColumn(cf, name, ByteBufferUtil.bytes(address));
    }

    public static void addColumn(ColumnFamily cf, ByteBuffer name, int value) {
        Tracing.addColumn(cf, name, ByteBufferUtil.bytes(value));
    }

    public static void addColumn(ColumnFamily cf, ByteBuffer name, long value) {
        Tracing.addColumn(cf, name, ByteBufferUtil.bytes(value));
    }

    public static void addColumn(ColumnFamily cf, ByteBuffer name, String value) {
        Tracing.addColumn(cf, name, ByteBufferUtil.bytes(value));
    }

    private static void addColumn(ColumnFamily cf, ByteBuffer name, ByteBuffer value) {
        cf.addColumn(name, value, FBUtilities.timestampMicros());
    }

    public static ByteBuffer buildName(CFMetaData meta, ByteBuffer ... args) {
        ColumnNameBuilder builder = meta.getCfDef().getColumnNameBuilder();
        for (ByteBuffer arg : args) {
            builder.add(arg);
        }
        return builder.build();
    }

    public UUID getSessionId() {
        assert (Tracing.isTracing());
        return this.state.get().sessionId;
    }

    public static boolean isTracing() {
        return Tracing.instance.state.get() != null;
    }

    public UUID newSession() {
        return this.newSession((UUID)TimeUUIDType.instance.compose(ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes())));
    }

    public UUID newSession(UUID sessionId) {
        assert (this.state.get() == null);
        TraceState ts = new TraceState(this.localAddress, sessionId);
        this.state.set(ts);
        this.sessions.put(sessionId, ts);
        return sessionId;
    }

    public void stopNonLocal(TraceState state) {
        this.sessions.remove(state.sessionId);
    }

    public void stopSession() {
        TraceState state = this.state.get();
        if (state == null) {
            logger.debug("request complete");
        } else {
            final int elapsed = state.elapsed();
            final ByteBuffer sessionIdBytes = state.sessionIdBytes;
            StageManager.getStage(Stage.TRACING).execute(new Runnable(){

                @Override
                public void run() {
                    CFMetaData cfMeta = CFMetaData.TraceSessionsCf;
                    ArrayBackedSortedColumns cf = ArrayBackedSortedColumns.factory.create(cfMeta);
                    Tracing.addColumn((ColumnFamily)cf, Tracing.buildName(cfMeta, ByteBufferUtil.bytes("duration")), elapsed);
                    Tracing.mutateWithCatch(new RowMutation(Tracing.TRACE_KS, sessionIdBytes, cf));
                }
            });
            this.sessions.remove(state.sessionId);
            this.state.set(null);
        }
    }

    public TraceState get() {
        return this.state.get();
    }

    public TraceState get(UUID sessionId) {
        return (TraceState)this.sessions.get(sessionId);
    }

    public void set(TraceState tls) {
        this.state.set(tls);
    }

    public void begin(final String request, final Map<String, String> parameters) {
        assert (Tracing.isTracing());
        final long started_at = System.currentTimeMillis();
        final ByteBuffer sessionIdBytes = this.state.get().sessionIdBytes;
        StageManager.getStage(Stage.TRACING).execute(new Runnable(){

            @Override
            public void run() {
                CFMetaData cfMeta = CFMetaData.TraceSessionsCf;
                TreeMapBackedSortedColumns cf = TreeMapBackedSortedColumns.factory.create(cfMeta);
                Tracing.addColumn((ColumnFamily)cf, Tracing.buildName(cfMeta, ByteBufferUtil.bytes("coordinator")), FBUtilities.getBroadcastAddress());
                for (Map.Entry entry : parameters.entrySet()) {
                    Tracing.addColumn((ColumnFamily)cf, Tracing.buildName(cf.metadata(), ByteBufferUtil.bytes("parameters"), ByteBufferUtil.bytes((String)entry.getKey())), (String)entry.getValue());
                }
                Tracing.addColumn((ColumnFamily)cf, Tracing.buildName(cfMeta, ByteBufferUtil.bytes("request")), request);
                Tracing.addColumn((ColumnFamily)cf, Tracing.buildName(cfMeta, ByteBufferUtil.bytes("started_at")), started_at);
                Tracing.mutateWithCatch(new RowMutation(Tracing.TRACE_KS, sessionIdBytes, cf));
            }
        });
    }

    public TraceState initializeFromMessage(MessageIn<?> message) {
        byte[] sessionBytes = message.parameters.get(TRACE_HEADER);
        if (sessionBytes == null) {
            return null;
        }
        assert (sessionBytes.length == 16);
        UUID sessionId = UUIDGen.getUUID(ByteBuffer.wrap(sessionBytes));
        TraceState ts = (TraceState)this.sessions.get(sessionId);
        if (ts != null) {
            return ts;
        }
        if (message.verb == MessagingService.Verb.REQUEST_RESPONSE) {
            return new ExpiredTraceState(sessionId);
        }
        ts = new TraceState(message.from, sessionId);
        this.sessions.put(sessionId, ts);
        return ts;
    }

    public static void trace(String message) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(message);
    }

    public static void trace(String format, Object arg) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(format, arg);
    }

    public static void trace(String format, Object arg1, Object arg2) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(format, arg1, arg2);
    }

    public static void trace(String format, Object[] args) {
        TraceState state = instance.get();
        if (state == null) {
            return;
        }
        state.trace(format, args);
    }

    static void mutateWithCatch(RowMutation mutation) {
        try {
            StorageProxy.mutate(Arrays.asList(mutation), ConsistencyLevel.ANY);
        }
        catch (UnavailableException | WriteTimeoutException e) {
            throw new AssertionError((Object)e);
        }
        catch (OverloadedException e) {
            logger.warn("Too many nodes are overloaded to save trace events");
        }
    }
}

