/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.triggers;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.astyanax.shaded.org.apache.cassandra.config.TriggerDefinition;
import com.netflix.astyanax.shaded.org.apache.cassandra.cql.QueryProcessor;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.ColumnFamily;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.CounterMutation;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.IMutation;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.RowMutation;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.marshal.AbstractType;
import com.netflix.astyanax.shaded.org.apache.cassandra.exceptions.InvalidRequestException;
import com.netflix.astyanax.shaded.org.apache.cassandra.triggers.CustomClassLoader;
import com.netflix.astyanax.shaded.org.apache.cassandra.triggers.ITrigger;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.FBUtilities;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.HeapAllocator;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Pair;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class TriggerExecutor {
    public static final TriggerExecutor instance = new TriggerExecutor();
    private final Map<String, ITrigger> cachedTriggers = Maps.newConcurrentMap();
    private final ClassLoader parent = Thread.currentThread().getContextClassLoader();
    private volatile ClassLoader customClassLoader;

    private TriggerExecutor() {
        this.reloadClasses();
    }

    public void reloadClasses() {
        File tiggerDirectory = FBUtilities.cassandraTriggerDir();
        if (tiggerDirectory == null) {
            return;
        }
        this.customClassLoader = new CustomClassLoader(this.parent, tiggerDirectory);
        this.cachedTriggers.clear();
    }

    public ColumnFamily execute(ByteBuffer key, ColumnFamily updates) throws InvalidRequestException {
        List<RowMutation> intermediate = this.executeInternal(key, updates);
        if (intermediate == null || intermediate.isEmpty()) {
            return updates;
        }
        this.validateForSinglePartition(updates.metadata().getKeyValidator(), updates.id(), key, intermediate);
        for (RowMutation mutation : intermediate) {
            for (ColumnFamily cf : mutation.getColumnFamilies()) {
                updates.addAll(cf, HeapAllocator.instance);
            }
        }
        return updates;
    }

    public Collection<RowMutation> execute(Collection<? extends IMutation> mutations) throws InvalidRequestException {
        boolean hasCounters = false;
        LinkedList<RowMutation> augmentedMutations = null;
        for (IMutation iMutation : mutations) {
            if (iMutation instanceof CounterMutation) {
                hasCounters = true;
            }
            for (ColumnFamily cf : iMutation.getColumnFamilies()) {
                List<RowMutation> augmentations = this.executeInternal(iMutation.key(), cf);
                if (augmentations == null || augmentations.isEmpty()) continue;
                this.validate(augmentations);
                if (augmentedMutations == null) {
                    augmentedMutations = new LinkedList<RowMutation>();
                }
                augmentedMutations.addAll(augmentations);
            }
        }
        if (augmentedMutations == null) {
            return null;
        }
        if (hasCounters) {
            throw new InvalidRequestException("Counter mutations and trigger mutations cannot be applied together atomically.");
        }
        Collection<? extends IMutation> originalMutations = mutations;
        return this.mergeMutations(Iterables.concat(originalMutations, augmentedMutations));
    }

    private Collection<RowMutation> mergeMutations(Iterable<RowMutation> mutations) {
        HashMap<Pair<String, ByteBuffer>, RowMutation> groupedMutations = new HashMap<Pair<String, ByteBuffer>, RowMutation>();
        for (RowMutation mutation : mutations) {
            Pair<String, ByteBuffer> key = Pair.create(mutation.getKeyspaceName(), mutation.key());
            RowMutation current = (RowMutation)groupedMutations.get(key);
            if (current == null) {
                groupedMutations.put(key, mutation.copy());
                continue;
            }
            current.addAll(mutation);
        }
        return groupedMutations.values();
    }

    private void validateForSinglePartition(AbstractType<?> keyValidator, UUID cfId, ByteBuffer key, Collection<RowMutation> tmutations) throws InvalidRequestException {
        for (RowMutation mutation : tmutations) {
            if (keyValidator.compare(mutation.key(), key) != 0) {
                throw new InvalidRequestException("Partition key of additional mutation does not match primary update key");
            }
            for (ColumnFamily cf : mutation.getColumnFamilies()) {
                if (cf.id().equals(cfId)) continue;
                throw new InvalidRequestException("Column family of additional mutation does not match primary update cf");
            }
        }
        this.validate(tmutations);
    }

    private void validate(Collection<RowMutation> tmutations) throws InvalidRequestException {
        for (RowMutation mutation : tmutations) {
            QueryProcessor.validateKey(mutation.key());
            for (ColumnFamily tcf : mutation.getColumnFamilies()) {
                for (ByteBuffer tName : tcf.getColumnNames()) {
                    QueryProcessor.validateColumn(tcf.metadata(), tName, tcf.getColumn(tName).value());
                }
            }
        }
    }

    private List<RowMutation> executeInternal(ByteBuffer key, ColumnFamily columnFamily) {
        Map<String, TriggerDefinition> triggers = columnFamily.metadata().getTriggers();
        if (triggers.isEmpty()) {
            return null;
        }
        LinkedList tmutations = Lists.newLinkedList();
        Thread.currentThread().setContextClassLoader(this.customClassLoader);
        try {
            for (TriggerDefinition td : triggers.values()) {
                Collection<RowMutation> temp;
                ITrigger trigger = this.cachedTriggers.get(td.classOption);
                if (trigger == null) {
                    trigger = this.loadTriggerInstance(td.classOption);
                    this.cachedTriggers.put(td.classOption, trigger);
                }
                if ((temp = trigger.augment(key, columnFamily)) == null) continue;
                tmutations.addAll(temp);
            }
            LinkedList i$ = tmutations;
            return i$;
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Exception while creating trigger on CF with ID: %s", columnFamily.id()), ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.parent);
        }
    }

    public synchronized ITrigger loadTriggerInstance(String triggerName) throws Exception {
        if (this.cachedTriggers.get(triggerName) != null) {
            return this.cachedTriggers.get(triggerName);
        }
        return (ITrigger)this.customClassLoader.loadClass(triggerName).getConstructor(new Class[0]).newInstance(new Object[0]);
    }
}

