/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.utils;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.ISerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.BloomFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.obs.IBitSet;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.obs.OffHeapBitSet;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.obs.OpenBitSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

abstract class BloomFilterSerializer
implements ISerializer<BloomFilter> {
    BloomFilterSerializer() {
    }

    @Override
    public void serialize(BloomFilter bf, DataOutput out) throws IOException {
        out.writeInt(bf.hashCount);
        bf.bitset.serialize(out);
    }

    @Override
    public BloomFilter deserialize(DataInput in) throws IOException {
        return this.deserialize(in, false);
    }

    public BloomFilter deserialize(DataInput in, boolean offheap) throws IOException {
        int hashes = in.readInt();
        IBitSet bs = offheap ? OffHeapBitSet.deserialize(in) : OpenBitSet.deserialize(in);
        return this.createFilter(hashes, bs);
    }

    protected abstract BloomFilter createFilter(int var1, IBitSet var2);

    @Override
    public long serializedSize(BloomFilter bf, TypeSizes typeSizes) {
        int size = typeSizes.sizeof(bf.hashCount);
        size = (int)((long)size + bf.bitset.serializedSize(typeSizes));
        return size;
    }
}

