/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.utils;

import com.netflix.astyanax.shaded.org.apache.cassandra.utils.AlwaysPresentFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.BloomCalculations;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.IFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Murmur3BloomFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.obs.IBitSet;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.obs.OffHeapBitSet;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.obs.OpenBitSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterFactory {
    public static final IFilter AlwaysPresent = new AlwaysPresentFilter();
    private static final Logger logger = LoggerFactory.getLogger(FilterFactory.class);
    private static final long BITSET_EXCESS = 20L;

    public static void serialize(IFilter bf, DataOutput output) throws IOException {
        Murmur3BloomFilter.serializer.serialize((Murmur3BloomFilter)bf, output);
    }

    public static IFilter deserialize(DataInput input, boolean offheap) throws IOException {
        return Murmur3BloomFilter.serializer.deserialize(input, offheap);
    }

    public static IFilter getFilter(long numElements, int targetBucketsPerElem, boolean offheap) {
        int maxBucketsPerElement = Math.max(1, BloomCalculations.maxBucketsPerElement(numElements));
        int bucketsPerElement = Math.min(targetBucketsPerElem, maxBucketsPerElement);
        if (bucketsPerElement < targetBucketsPerElem) {
            logger.warn(String.format("Cannot provide an optimal BloomFilter for %d elements (%d/%d buckets per element).", numElements, bucketsPerElement, targetBucketsPerElem));
        }
        BloomCalculations.BloomSpecification spec = BloomCalculations.computeBloomSpec(bucketsPerElement);
        return FilterFactory.createFilter(spec.K, numElements, spec.bucketsPerElement, offheap);
    }

    public static IFilter getFilter(long numElements, double maxFalsePosProbability, boolean offheap) {
        assert (maxFalsePosProbability <= 1.0) : "Invalid probability";
        if (maxFalsePosProbability == 1.0) {
            return new AlwaysPresentFilter();
        }
        int bucketsPerElement = BloomCalculations.maxBucketsPerElement(numElements);
        BloomCalculations.BloomSpecification spec = BloomCalculations.computeBloomSpec(bucketsPerElement, maxFalsePosProbability);
        return FilterFactory.createFilter(spec.K, numElements, spec.bucketsPerElement, offheap);
    }

    private static IFilter createFilter(int hash, long numElements, int bucketsPer, boolean offheap) {
        long numBits = numElements * (long)bucketsPer + 20L;
        IBitSet bitset = offheap ? new OffHeapBitSet(numBits) : new OpenBitSet(numBits);
        return new Murmur3BloomFilter(hash, bitset);
    }
}

