/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.utils;

import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.BloomFilter;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.BloomFilterSerializer;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.MurmurHash;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.obs.IBitSet;
import java.nio.ByteBuffer;

public class Murmur3BloomFilter
extends BloomFilter {
    public static final Murmur3BloomFilterSerializer serializer = new Murmur3BloomFilterSerializer();

    public Murmur3BloomFilter(int hashes, IBitSet bs) {
        super(hashes, bs);
    }

    @Override
    public long serializedSize() {
        return serializer.serializedSize(this, TypeSizes.NATIVE);
    }

    @Override
    public long offHeapSize() {
        return this.bitset.offHeapSize();
    }

    @Override
    protected void hash(ByteBuffer b, int position, int remaining, long seed, long[] result) {
        MurmurHash.hash3_x64_128(b, b.position(), b.remaining(), seed, result);
    }

    public static class Murmur3BloomFilterSerializer
    extends BloomFilterSerializer {
        @Override
        protected BloomFilter createFilter(int hashes, IBitSet bs) {
            return new Murmur3BloomFilter(hashes, bs);
        }
    }
}

