/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.entitytransform;

import java.util.Arrays;
import java.util.List;
import org.apache.atlas.entitytransform.AtlasEntityTransformer;
import org.apache.atlas.entitytransform.BaseEntityHandler;
import org.apache.atlas.entitytransform.EntityAttribute;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.commons.lang.StringUtils;

public class HdfsPathEntityHandler
extends BaseEntityHandler {
    static final List<String> CUSTOM_TRANSFORM_ATTRIBUTES = Arrays.asList("hdfs_path.name", "hdfs_path.path", "hdfs_path.clusterName");

    public HdfsPathEntityHandler(List<AtlasEntityTransformer> transformers) {
        super(transformers);
    }

    @Override
    public BaseEntityHandler.AtlasTransformableEntity getTransformableEntity(AtlasEntity entity) {
        return this.isHdfsPathEntity(entity) ? new HdfsPathEntity(entity) : null;
    }

    private boolean isHdfsPathEntity(AtlasEntity entity) {
        return StringUtils.equals((String)entity.getTypeName(), (String)"hdfs_path");
    }

    public static class HdfsPathEntity
    extends BaseEntityHandler.AtlasTransformableEntity {
        private String clusterName;
        private String path;
        private String name;
        private String pathPrefix;
        private boolean isPathUpdated = false;
        private boolean isCustomAttributeUpdated = false;

        public HdfsPathEntity(AtlasEntity entity) {
            super(entity);
            this.path = (String)entity.getAttribute("path");
            this.name = (String)entity.getAttribute("name");
            String qualifiedName = (String)entity.getAttribute("qualifiedName");
            if (qualifiedName != null) {
                int clusterSeparatorIdx = qualifiedName.lastIndexOf(64);
                this.clusterName = clusterSeparatorIdx != -1 ? qualifiedName.substring(clusterSeparatorIdx + 1) : "";
                if (StringUtils.isNotEmpty((String)this.path) && StringUtils.isNotEmpty((String)this.name)) {
                    int idx = this.path.indexOf(this.name);
                    this.pathPrefix = idx != -1 ? this.path.substring(0, idx) : "";
                }
            } else {
                this.clusterName = "";
                this.pathPrefix = "";
            }
        }

        @Override
        public Object getAttribute(EntityAttribute attribute) {
            switch (attribute.getAttributeKey()) {
                case "hdfs_path.clusterName": {
                    return this.clusterName;
                }
                case "hdfs_path.name": {
                    return this.name;
                }
                case "hdfs_path.path": {
                    return this.path;
                }
            }
            return super.getAttribute(attribute);
        }

        @Override
        public void setAttribute(EntityAttribute attribute, String attributeValue) {
            switch (attribute.getAttributeKey()) {
                case "hdfs_path.clusterName": {
                    this.clusterName = attributeValue;
                    this.isCustomAttributeUpdated = true;
                    break;
                }
                case "hdfs_path.name": {
                    this.name = attributeValue;
                    this.isCustomAttributeUpdated = true;
                    break;
                }
                case "hdfs_path.path": {
                    this.path = attributeValue;
                    this.isPathUpdated = true;
                    this.isCustomAttributeUpdated = true;
                    break;
                }
                default: {
                    super.setAttribute(attribute, attributeValue);
                }
            }
        }

        @Override
        public void transformComplete() {
            if (this.isCustomAttributeUpdated) {
                this.entity.setAttribute("clusterName", (Object)this.clusterName);
                this.entity.setAttribute("name", (Object)this.name);
                this.entity.setAttribute("path", (Object)this.toPath());
                this.entity.setAttribute("qualifiedName", (Object)this.toQualifiedName());
            }
        }

        private String toQualifiedName() {
            return StringUtils.isEmpty((String)this.clusterName) ? this.toPath() : String.format("%s@%s", this.toPath(), this.clusterName);
        }

        private String toPath() {
            String ret = this.isPathUpdated ? this.path : (StringUtils.isNotEmpty((String)this.pathPrefix) ? this.pathPrefix + this.name : this.name);
            return ret;
        }
    }
}

