/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.glossary;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.glossary.GlossaryUtils;
import org.apache.atlas.model.glossary.AtlasGlossary;
import org.apache.atlas.model.glossary.AtlasGlossaryCategory;
import org.apache.atlas.model.glossary.relations.AtlasGlossaryHeader;
import org.apache.atlas.model.glossary.relations.AtlasRelatedCategoryHeader;
import org.apache.atlas.model.glossary.relations.AtlasRelatedTermHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.repository.ogm.DataAccess;
import org.apache.atlas.repository.store.graph.AtlasRelationshipStore;
import org.apache.atlas.type.AtlasRelationshipType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryCategoryUtils
extends GlossaryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(GlossaryCategoryUtils.class);
    private static final boolean DEBUG_ENABLED = LOG.isDebugEnabled();

    protected GlossaryCategoryUtils(AtlasRelationshipStore relationshipStore, AtlasTypeRegistry typeRegistry, DataAccess dataAccess) {
        super(relationshipStore, typeRegistry, dataAccess);
    }

    public Map<String, AtlasGlossaryCategory> processCategoryRelations(AtlasGlossaryCategory storeObject, AtlasGlossaryCategory updatedCategory, GlossaryUtils.RelationshipOperation op) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("==> GlossaryCategoryUtils.processCategoryRelations({}, {}, {})", new Object[]{storeObject, updatedCategory, op});
        }
        HashMap<String, AtlasGlossaryCategory> impactedCategories = new HashMap<String, AtlasGlossaryCategory>();
        this.processCategoryAnchor(storeObject, updatedCategory, op, impactedCategories);
        this.processParentCategory(storeObject, updatedCategory, op, impactedCategories);
        this.processCategoryChildren(storeObject, updatedCategory, op, impactedCategories);
        this.processAssociatedTerms(storeObject, updatedCategory, op);
        if (DEBUG_ENABLED) {
            LOG.debug("<== GlossaryCategoryUtils.processCategoryRelations(): {}", impactedCategories);
        }
        return impactedCategories;
    }

    private void processCategoryAnchor(AtlasGlossaryCategory storeObject, AtlasGlossaryCategory updatedCategory, GlossaryUtils.RelationshipOperation op, Map<String, AtlasGlossaryCategory> impactedCategories) throws AtlasBaseException {
        if (Objects.isNull(updatedCategory.getAnchor()) && op != GlossaryUtils.RelationshipOperation.DELETE) {
            throw new AtlasBaseException(AtlasErrorCode.MISSING_MANDATORY_ANCHOR, new String[0]);
        }
        AtlasGlossaryHeader existingAnchor = storeObject.getAnchor();
        AtlasGlossaryHeader updatedCategoryAnchor = updatedCategory.getAnchor();
        switch (op) {
            case CREATE: {
                if (StringUtils.isEmpty((String)updatedCategoryAnchor.getGlossaryGuid())) {
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_NEW_ANCHOR_GUID, new String[0]);
                }
                if (DEBUG_ENABLED) {
                    LOG.debug("Creating new category anchor, category = {}, glossary = {}", (Object)storeObject.getGuid(), (Object)updatedCategory.getAnchor().getGlossaryGuid());
                }
                String anchorGlossaryGuid = updatedCategory.getAnchor().getGlossaryGuid();
                this.createRelationship(this.defineCategoryAnchorRelation(anchorGlossaryGuid, storeObject.getGuid()));
                break;
            }
            case UPDATE: {
                if (Objects.equals(existingAnchor, updatedCategoryAnchor)) break;
                if (Objects.isNull(updatedCategory.getAnchor().getGlossaryGuid())) {
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_NEW_ANCHOR_GUID, new String[0]);
                }
                if (DEBUG_ENABLED) {
                    LOG.debug("Updating category anchor, currAnchor = {}, newAnchor = {} and category = {}", new Object[]{storeObject.getAnchor().getGlossaryGuid(), updatedCategory.getAnchor().getGlossaryGuid(), storeObject.getGuid()});
                }
                this.relationshipStore.deleteById(storeObject.getAnchor().getRelationGuid(), true);
                String anchorGlossaryGuid = updatedCategory.getAnchor().getGlossaryGuid();
                AtlasGlossary glossary = this.dataAccess.load(GlossaryCategoryUtils.getGlossarySkeleton(anchorGlossaryGuid));
                storeObject.setQualifiedName(storeObject.getName() + "@" + glossary.getQualifiedName());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Derived qualifiedName = {}", (Object)storeObject.getQualifiedName());
                }
                this.createRelationship(this.defineCategoryAnchorRelation(updatedCategory.getAnchor().getGlossaryGuid(), storeObject.getGuid()));
                this.updateChildCategories(storeObject, storeObject.getChildrenCategories(), impactedCategories, false);
                break;
            }
            case DELETE: {
                if (!Objects.nonNull(storeObject.getAnchor())) break;
                if (DEBUG_ENABLED) {
                    LOG.debug("Deleting category anchor");
                }
                this.relationshipStore.deleteById(storeObject.getAnchor().getRelationGuid(), true);
            }
        }
    }

    private void processParentCategory(AtlasGlossaryCategory storeObject, AtlasGlossaryCategory updatedCategory, GlossaryUtils.RelationshipOperation op, Map<String, AtlasGlossaryCategory> impactedCategories) throws AtlasBaseException {
        AtlasRelatedCategoryHeader newParent = updatedCategory.getParentCategory();
        AtlasRelatedCategoryHeader existingParent = storeObject.getParentCategory();
        switch (op) {
            case CREATE: {
                if (!Objects.nonNull(newParent)) break;
                this.processNewParent(storeObject, newParent, impactedCategories);
                break;
            }
            case UPDATE: {
                if (Objects.equals(newParent, existingParent)) {
                    if (!DEBUG_ENABLED) break;
                    LOG.debug("No change to parent");
                    break;
                }
                if (Objects.isNull(existingParent)) {
                    this.processNewParent(storeObject, newParent, impactedCategories);
                    break;
                }
                if (Objects.isNull(newParent)) {
                    this.processParentRemoval(storeObject, updatedCategory, existingParent, impactedCategories);
                    break;
                }
                if (DEBUG_ENABLED) {
                    LOG.debug("Updating category parent, category = {}, currParent = {}, newParent = {}", new Object[]{storeObject.getGuid(), existingParent.getDisplayText(), newParent.getDisplayText()});
                }
                AtlasRelationship parentRelationship = this.relationshipStore.getById(existingParent.getRelationGuid());
                if (existingParent.getCategoryGuid().equals(newParent.getCategoryGuid())) {
                    this.updateRelationshipAttributes(parentRelationship, newParent);
                    this.relationshipStore.update(parentRelationship);
                    break;
                }
                this.relationshipStore.deleteById(parentRelationship.getGuid(), true);
                this.createRelationship(this.defineCategoryHierarchyLink(newParent, storeObject.getGuid()));
                break;
            }
            case DELETE: {
                if (!Objects.nonNull(existingParent)) break;
                this.processParentRemoval(storeObject, updatedCategory, existingParent, impactedCategories);
            }
        }
    }

    private void processNewParent(AtlasGlossaryCategory storeObject, AtlasRelatedCategoryHeader newParent, Map<String, AtlasGlossaryCategory> impactedCategories) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("Creating new parent, category = {}, parent = {}", (Object)storeObject.getGuid(), (Object)newParent.getDisplayText());
        }
        this.createRelationship(this.defineCategoryHierarchyLink(newParent, storeObject.getGuid()));
        AtlasGlossaryCategory parentCategory = this.dataAccess.load(GlossaryCategoryUtils.getAtlasGlossaryCategorySkeleton(newParent.getCategoryGuid()));
        storeObject.setQualifiedName(storeObject.getName() + "." + parentCategory.getQualifiedName());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Derived qualifiedName = {}", (Object)storeObject.getQualifiedName());
        }
        this.updateChildCategories(storeObject, storeObject.getChildrenCategories(), impactedCategories, false);
    }

    private void processParentRemoval(AtlasGlossaryCategory storeObject, AtlasGlossaryCategory updatedCategory, AtlasRelatedCategoryHeader existingParent, Map<String, AtlasGlossaryCategory> impactedCategories) throws AtlasBaseException {
        if (DEBUG_ENABLED) {
            LOG.debug("Removing category parent, category = {}, parent = {}", (Object)storeObject.getGuid(), (Object)existingParent.getDisplayText());
        }
        this.relationshipStore.deleteById(existingParent.getRelationGuid(), true);
        String anchorGlossaryGuid = updatedCategory.getAnchor().getGlossaryGuid();
        AtlasGlossary glossary = this.dataAccess.load(GlossaryCategoryUtils.getGlossarySkeleton(anchorGlossaryGuid));
        storeObject.setQualifiedName(storeObject.getName() + "@" + glossary.getQualifiedName());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Derived qualifiedName = {}", (Object)storeObject.getQualifiedName());
        }
        this.updateChildCategories(storeObject, storeObject.getChildrenCategories(), impactedCategories, false);
    }

    private void processAssociatedTerms(AtlasGlossaryCategory storeObject, AtlasGlossaryCategory updatedCategory, GlossaryUtils.RelationshipOperation op) throws AtlasBaseException {
        Map<String, AtlasRelatedTermHeader> newTerms = this.getTerms(updatedCategory);
        Map<String, AtlasRelatedTermHeader> existingTerms = this.getTerms(storeObject);
        switch (op) {
            case CREATE: {
                if (DEBUG_ENABLED) {
                    LOG.debug("Creating term relation with category = {}, terms = {}", (Object)storeObject.getName(), Objects.nonNull(newTerms) ? Integer.valueOf(newTerms.size()) : "none");
                }
                this.createTermCategorizationRelationships(storeObject, newTerms.values());
                break;
            }
            case UPDATE: {
                if (MapUtils.isEmpty(existingTerms)) {
                    if (DEBUG_ENABLED) {
                        LOG.debug("Creating term relation with category = {}, terms = {}", (Object)storeObject.getName(), Objects.nonNull(newTerms) ? Integer.valueOf(newTerms.size()) : "none");
                    }
                    this.createTermCategorizationRelationships(storeObject, newTerms.values());
                    break;
                }
                if (MapUtils.isEmpty(newTerms)) {
                    if (DEBUG_ENABLED) {
                        LOG.debug("Deleting term relation with category = {}, terms = {}", (Object)storeObject.getName(), (Object)existingTerms.size());
                    }
                    this.deleteTermCategorizationRelationships(storeObject, existingTerms.values());
                    break;
                }
                Set<AtlasRelatedTermHeader> toCreate = newTerms.values().stream().filter(t -> !existingTerms.containsKey(t.getTermGuid())).collect(Collectors.toSet());
                this.createTermCategorizationRelationships(storeObject, toCreate);
                Set<AtlasRelatedTermHeader> toUpdate = newTerms.values().stream().filter(t -> this.updatedExistingTermRelation(existingTerms, (AtlasRelatedTermHeader)t)).collect(Collectors.toSet());
                this.updateTermCategorizationRelationships(storeObject, toUpdate);
                Set<AtlasRelatedTermHeader> toDelete = existingTerms.values().stream().filter(t -> !newTerms.containsKey(t.getTermGuid())).collect(Collectors.toSet());
                this.deleteTermCategorizationRelationships(storeObject, toDelete);
                break;
            }
            case DELETE: {
                this.deleteTermCategorizationRelationships(storeObject, existingTerms.values());
            }
        }
    }

    private boolean updatedExistingTermRelation(Map<String, AtlasRelatedTermHeader> existingTerms, AtlasRelatedTermHeader term) {
        return Objects.nonNull(term.getRelationGuid()) && !existingTerms.get(term.getTermGuid()).equals((Object)term);
    }

    private Map<String, AtlasRelatedTermHeader> getTerms(AtlasGlossaryCategory category) {
        if (Objects.nonNull(category.getTerms())) {
            HashMap<String, AtlasRelatedTermHeader> map = new HashMap<String, AtlasRelatedTermHeader>();
            for (AtlasRelatedTermHeader t : category.getTerms()) {
                AtlasRelatedTermHeader header = (AtlasRelatedTermHeader)map.get(t.getTermGuid());
                if (header == null) {
                    map.put(t.getTermGuid(), t);
                    continue;
                }
                if (!StringUtils.isEmpty((String)header.getRelationGuid()) || !StringUtils.isNotEmpty((String)t.getRelationGuid())) continue;
                map.put(t.getTermGuid(), t);
            }
            return map;
        }
        return Collections.emptyMap();
    }

    private void createTermCategorizationRelationships(AtlasGlossaryCategory storeObject, Collection<AtlasRelatedTermHeader> terms) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(terms)) {
            Set existingTerms = storeObject.getTerms();
            for (AtlasRelatedTermHeader term : terms) {
                if (Objects.isNull(term.getTermGuid())) {
                    throw new AtlasBaseException(AtlasErrorCode.MISSING_TERM_ID_FOR_CATEGORIZATION, new String[0]);
                }
                if (Objects.nonNull(existingTerms) && existingTerms.contains(term)) {
                    if (!DEBUG_ENABLED) continue;
                    LOG.debug("Skipping existing term guid={}", (Object)term.getTermGuid());
                    continue;
                }
                if (DEBUG_ENABLED) {
                    LOG.debug("Creating relation between category = {} and term = {}", (Object)storeObject.getGuid(), (Object)term.getDisplayText());
                }
                this.createRelationship(this.defineCategorizedTerm(storeObject.getGuid(), term));
            }
        }
    }

    private void updateTermCategorizationRelationships(AtlasGlossaryCategory storeObject, Collection<AtlasRelatedTermHeader> terms) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(terms)) {
            for (AtlasRelatedTermHeader term : terms) {
                if (DEBUG_ENABLED) {
                    LOG.debug("Updating term relation with category = {}, term = {}", (Object)storeObject.getName(), (Object)term.getDisplayText());
                }
                AtlasRelationship relationship = this.relationshipStore.getById(term.getRelationGuid());
                this.updateRelationshipAttributes(relationship, term);
                this.relationshipStore.update(relationship);
            }
        }
    }

    private void deleteTermCategorizationRelationships(AtlasGlossaryCategory storeObject, Collection<AtlasRelatedTermHeader> terms) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(terms)) {
            for (AtlasRelatedTermHeader term : terms) {
                if (DEBUG_ENABLED) {
                    LOG.debug("Creating term relation with category = {}, terms = {}", (Object)storeObject.getName(), (Object)term.getDisplayText());
                }
                this.relationshipStore.deleteById(term.getRelationGuid(), true);
            }
        }
    }

    private void processCategoryChildren(AtlasGlossaryCategory storeObject, AtlasGlossaryCategory updatedCategory, GlossaryUtils.RelationshipOperation op, Map<String, AtlasGlossaryCategory> impactedCategories) throws AtlasBaseException {
        Map<String, AtlasRelatedCategoryHeader> newChildren = this.getChildren(updatedCategory);
        Map<String, AtlasRelatedCategoryHeader> existingChildren = this.getChildren(storeObject);
        switch (op) {
            case CREATE: {
                if (DEBUG_ENABLED) {
                    LOG.debug("Creating new children, category = {}, children = {}", (Object)storeObject.getName(), Objects.nonNull(newChildren) ? Integer.valueOf(newChildren.size()) : "none");
                }
                this.createCategoryRelationships(storeObject, newChildren.values());
                this.updateChildCategories(storeObject, newChildren.values(), impactedCategories, false);
                break;
            }
            case UPDATE: {
                if (MapUtils.isEmpty(existingChildren)) {
                    if (DEBUG_ENABLED) {
                        LOG.debug("Creating new children, category = {}, children = {}", (Object)storeObject.getName(), Objects.nonNull(newChildren) ? Integer.valueOf(newChildren.size()) : "none");
                    }
                    this.createCategoryRelationships(storeObject, newChildren.values());
                    this.updateChildCategories(storeObject, newChildren.values(), impactedCategories, false);
                    break;
                }
                if (MapUtils.isEmpty(newChildren)) {
                    if (DEBUG_ENABLED) {
                        LOG.debug("Deleting children, category = {}, children = {}", (Object)storeObject.getName(), (Object)existingChildren.size());
                    }
                    this.deleteCategoryRelationships(storeObject, existingChildren.values());
                    this.updateChildCategories(storeObject, existingChildren.values(), impactedCategories, true);
                    break;
                }
                Set<AtlasRelatedCategoryHeader> toCreate = newChildren.values().stream().filter(c -> !existingChildren.containsKey(c.getCategoryGuid())).collect(Collectors.toSet());
                this.createCategoryRelationships(storeObject, toCreate);
                this.updateChildCategories(storeObject, toCreate, impactedCategories, false);
                Set<AtlasRelatedCategoryHeader> toUpdate = newChildren.values().stream().filter(c -> this.updatedExistingCategoryRelation(existingChildren, (AtlasRelatedCategoryHeader)c)).collect(Collectors.toSet());
                this.updateCategoryRelationships(storeObject, toUpdate);
                Set<AtlasRelatedCategoryHeader> toDelete = existingChildren.values().stream().filter(c -> !newChildren.containsKey(c.getCategoryGuid())).collect(Collectors.toSet());
                this.deleteCategoryRelationships(storeObject, toDelete);
                break;
            }
            case DELETE: {
                this.deleteCategoryRelationships(storeObject, existingChildren.values());
            }
        }
    }

    private boolean updatedExistingCategoryRelation(Map<String, AtlasRelatedCategoryHeader> existingChildren, AtlasRelatedCategoryHeader header) {
        return Objects.nonNull(header.getRelationGuid()) && !header.equals((Object)existingChildren.get(header.getCategoryGuid()));
    }

    private Map<String, AtlasRelatedCategoryHeader> getChildren(AtlasGlossaryCategory category) {
        if (Objects.nonNull(category.getChildrenCategories())) {
            HashMap<String, AtlasRelatedCategoryHeader> map = new HashMap<String, AtlasRelatedCategoryHeader>();
            for (AtlasRelatedCategoryHeader c : category.getChildrenCategories()) {
                AtlasRelatedCategoryHeader header = (AtlasRelatedCategoryHeader)map.get(c.getCategoryGuid());
                if (header != null && (!StringUtils.isEmpty((String)header.getRelationGuid()) || !StringUtils.isNotEmpty((String)c.getRelationGuid()))) continue;
                map.put(c.getCategoryGuid(), c);
            }
            return map;
        }
        return Collections.emptyMap();
    }

    private void createCategoryRelationships(AtlasGlossaryCategory storeObject, Collection<AtlasRelatedCategoryHeader> newChildren) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(newChildren)) {
            Set existingChildren = storeObject.getChildrenCategories();
            for (AtlasRelatedCategoryHeader child : newChildren) {
                if (Objects.nonNull(existingChildren) && existingChildren.contains(child)) {
                    if (!DEBUG_ENABLED) continue;
                    LOG.debug("Skipping existing child relation for category guid = {}", (Object)child.getCategoryGuid());
                    continue;
                }
                if (DEBUG_ENABLED) {
                    LOG.debug("Loading the child category to perform glossary check");
                }
                AtlasGlossaryCategory childCategory = new AtlasGlossaryCategory();
                childCategory.setGuid(child.getCategoryGuid());
                childCategory = this.dataAccess.load(childCategory);
                if (StringUtils.equals((String)storeObject.getAnchor().getGlossaryGuid(), (String)childCategory.getAnchor().getGlossaryGuid())) {
                    if (DEBUG_ENABLED) {
                        LOG.debug("Creating new child, category = {}, child = {}", (Object)storeObject.getName(), (Object)child.getDisplayText());
                    }
                    this.createRelationship(this.defineCategoryHierarchyLink(storeObject.getGuid(), child));
                    continue;
                }
                throw new AtlasBaseException(AtlasErrorCode.INVALID_CHILD_CATEGORY_DIFFERENT_GLOSSARY, new String[]{child.getCategoryGuid()});
            }
        }
    }

    private void updateCategoryRelationships(AtlasGlossaryCategory storeObject, Collection<AtlasRelatedCategoryHeader> toUpdate) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(toUpdate)) {
            for (AtlasRelatedCategoryHeader categoryHeader : toUpdate) {
                if (DEBUG_ENABLED) {
                    LOG.debug("Updating child, category = {}, child = {}", (Object)storeObject.getName(), (Object)categoryHeader.getDisplayText());
                }
                AtlasRelationship childRelationship = this.relationshipStore.getById(categoryHeader.getRelationGuid());
                this.updateRelationshipAttributes(childRelationship, categoryHeader);
                this.relationshipStore.update(childRelationship);
            }
        }
    }

    private void deleteCategoryRelationships(AtlasGlossaryCategory storeObject, Collection<AtlasRelatedCategoryHeader> existingChildren) throws AtlasBaseException {
        if (CollectionUtils.isNotEmpty(existingChildren)) {
            for (AtlasRelatedCategoryHeader child : existingChildren) {
                if (DEBUG_ENABLED) {
                    LOG.debug("Deleting child, category = {}, child = {}", (Object)storeObject.getName(), (Object)child.getDisplayText());
                }
                this.relationshipStore.deleteById(child.getRelationGuid(), true);
            }
        }
    }

    private AtlasRelationship defineCategoryAnchorRelation(String glossaryGuid, String categoryGuid) {
        AtlasRelationshipType relationshipType = this.typeRegistry.getRelationshipTypeByName("AtlasGlossaryCategoryAnchor");
        AtlasStruct defaultAttrs = relationshipType.createDefaultValue();
        return new AtlasRelationship("AtlasGlossaryCategoryAnchor", new AtlasObjectId(glossaryGuid), new AtlasObjectId(categoryGuid), defaultAttrs.getAttributes());
    }

    private AtlasRelationship defineCategoryHierarchyLink(String parentCategoryGuid, AtlasRelatedCategoryHeader childCategory) {
        AtlasRelationshipType relationshipType = this.typeRegistry.getRelationshipTypeByName("AtlasGlossaryCategoryHierarchyLink");
        AtlasStruct defaultAttrs = relationshipType.createDefaultValue();
        AtlasRelationship relationship = new AtlasRelationship("AtlasGlossaryCategoryHierarchyLink", new AtlasObjectId(parentCategoryGuid), new AtlasObjectId(childCategory.getCategoryGuid()), defaultAttrs.getAttributes());
        this.updateRelationshipAttributes(relationship, childCategory);
        return relationship;
    }

    private AtlasRelationship defineCategoryHierarchyLink(AtlasRelatedCategoryHeader parentCategory, String childGuid) {
        AtlasRelationshipType relationshipType = this.typeRegistry.getRelationshipTypeByName("AtlasGlossaryCategoryHierarchyLink");
        AtlasStruct defaultAttrs = relationshipType.createDefaultValue();
        AtlasRelationship relationship = new AtlasRelationship("AtlasGlossaryCategoryHierarchyLink", new AtlasObjectId(parentCategory.getCategoryGuid()), new AtlasObjectId(childGuid), defaultAttrs.getAttributes());
        this.updateRelationshipAttributes(relationship, parentCategory);
        return relationship;
    }

    private AtlasRelationship defineCategorizedTerm(String categoryGuid, AtlasRelatedTermHeader relatedTermId) {
        AtlasRelationshipType relationshipType = this.typeRegistry.getRelationshipTypeByName("AtlasGlossaryTermCategorization");
        AtlasStruct defaultAttrs = relationshipType.createDefaultValue();
        AtlasRelationship relationship = new AtlasRelationship("AtlasGlossaryTermCategorization", new AtlasObjectId(categoryGuid), new AtlasObjectId(relatedTermId.getTermGuid()), defaultAttrs.getAttributes());
        this.updateRelationshipAttributes(relationship, relatedTermId);
        return relationship;
    }

    private void updateRelationshipAttributes(AtlasRelationship relationship, AtlasRelatedCategoryHeader relatedCategoryHeader) {
        if (Objects.nonNull(relationship)) {
            relationship.setAttribute("description", (Object)relatedCategoryHeader.getDescription());
        }
    }

    private void updateChildCategories(AtlasGlossaryCategory parentCategory, Collection<AtlasRelatedCategoryHeader> childCategories, Map<String, AtlasGlossaryCategory> impactedCategories, boolean isParentRemoved) throws AtlasBaseException {
        if (CollectionUtils.isEmpty(childCategories)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Recomputing qualifiedName for {} children of category(guid={}, qualifiedName={})", new Object[]{childCategories.size(), parentCategory.getGuid(), parentCategory.getQualifiedName()});
        }
        String parentAnchorGuid = parentCategory.getAnchor().getGlossaryGuid();
        for (AtlasRelatedCategoryHeader childCategoryHeader : childCategories) {
            AtlasGlossaryCategory child = this.dataAccess.load(GlossaryCategoryUtils.getAtlasGlossaryCategorySkeleton(childCategoryHeader.getCategoryGuid()));
            String qualifiedName = child.getName() + ".";
            String childAnchorGuid = child.getAnchor().getGlossaryGuid();
            if (isParentRemoved) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Parent removed, deriving qualifiedName using Glossary");
                }
                AtlasGlossary glossary = this.dataAccess.load(GlossaryCategoryUtils.getGlossarySkeleton(childAnchorGuid));
                qualifiedName = qualifiedName + glossary.getQualifiedName();
                child.setParentCategory(null);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using parent to derive qualifiedName");
                }
                qualifiedName = qualifiedName + parentCategory.getQualifiedName();
            }
            child.setQualifiedName(qualifiedName);
            if (!StringUtils.equals((String)childAnchorGuid, (String)parentAnchorGuid)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Child anchor guid({}) doesn't match parent anchor guid({}). Updating child anchor", (Object)childAnchorGuid, (Object)parentAnchorGuid);
                }
                this.relationshipStore.deleteById(child.getAnchor().getRelationGuid(), true);
                this.createRelationship(this.defineCategoryAnchorRelation(parentAnchorGuid, child.getGuid()));
                child.getAnchor().setGlossaryGuid(parentAnchorGuid);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Derived qualifiedName = {}", (Object)qualifiedName);
            }
            impactedCategories.put(child.getGuid(), child);
            this.updateChildCategories(child, child.getChildrenCategories(), impactedCategories, false);
        }
    }
}

