/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.repository.impexp.ExportService;
import org.apache.atlas.repository.impexp.ExtractStrategy;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipAttributesExtractor
implements ExtractStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(RelationshipAttributesExtractor.class);
    private final AtlasTypeRegistry typeRegistry;

    public RelationshipAttributesExtractor(AtlasTypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    @Override
    public void fullFetch(AtlasEntity entity, ExportService.ExportContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> fullFetch({}): guidsToProcess {}", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)entity), (Object)context.guidsToProcess.size());
        }
        List<AtlasRelatedObjectId> atlasRelatedObjectIdList = this.getRelatedObjectIds(entity);
        for (AtlasRelatedObjectId ar : atlasRelatedObjectIdList) {
            boolean isLineage = this.isLineageType(ar.getTypeName());
            if (context.skipLineage && isLineage) continue;
            context.addToBeProcessed(isLineage, ar.getGuid(), ExportService.TraversalDirection.BOTH);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== fullFetch({}): guidsToProcess {}", (Object)entity.getGuid(), (Object)context.guidsToProcess.size());
        }
    }

    @Override
    public void connectedFetch(AtlasEntity entity, ExportService.ExportContext context) {
        ExportService.TraversalDirection direction;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> connectedFetch({}): guidsToProcess {}", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)entity), (Object)context.guidsToProcess.size());
        }
        if ((direction = context.guidDirection.get(entity.getGuid())) == null || direction == ExportService.TraversalDirection.UNKNOWN) {
            this.addToBeProcessed(entity, context, ExportService.TraversalDirection.OUTWARD, ExportService.TraversalDirection.INWARD);
        } else {
            if (this.isLineageType(entity.getTypeName())) {
                direction = ExportService.TraversalDirection.OUTWARD;
            }
            this.addToBeProcessed(entity, context, direction);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> connectedFetch({}): guidsToProcess {}", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)entity), (Object)context.guidsToProcess.size());
        }
    }

    @Override
    public void close() {
    }

    private void addToBeProcessed(AtlasEntity entity, ExportService.ExportContext context, ExportService.TraversalDirection ... directions) {
        if (directions == null || directions.length == 0) {
            return;
        }
        boolean isLineageEntity = this.isLineageType(entity.getTypeName());
        List<AtlasRelatedObjectId> relatedObjectIds = this.getRelatedObjectIds(entity);
        for (ExportService.TraversalDirection direction : directions) {
            for (AtlasRelatedObjectId id : relatedObjectIds) {
                String guid = id.getGuid();
                ExportService.TraversalDirection currentDirection = context.guidDirection.get(guid);
                boolean isLineageId = this.isLineageType(id.getTypeName());
                ExportService.TraversalDirection edgeDirection = this.getRelationshipEdgeDirection(id, entity.getTypeName());
                if (context.skipLineage && isLineageId || !isLineageEntity && direction != edgeDirection || isLineageEntity && direction == edgeDirection) continue;
                if (currentDirection == null) {
                    context.addToBeProcessed(isLineageId, guid, direction);
                    continue;
                }
                if (currentDirection != ExportService.TraversalDirection.OUTWARD || direction != ExportService.TraversalDirection.INWARD) continue;
                context.guidsProcessed.remove(guid);
                context.addToBeProcessed(isLineageId, guid, direction);
            }
        }
    }

    private ExportService.TraversalDirection getRelationshipEdgeDirection(AtlasRelatedObjectId relatedObjectId, String entityTypeName) {
        boolean isOutEdge = this.typeRegistry.getRelationshipDefByName(relatedObjectId.getRelationshipType()).getEndDef1().getType().equals(entityTypeName);
        return isOutEdge ? ExportService.TraversalDirection.OUTWARD : ExportService.TraversalDirection.INWARD;
    }

    private boolean isLineageType(String typeName) {
        AtlasEntityDef entityDef = this.typeRegistry.getEntityDefByName(typeName);
        return entityDef.getSuperTypes().contains("Process");
    }

    private List<AtlasRelatedObjectId> getRelatedObjectIds(AtlasEntity entity) {
        ArrayList<AtlasRelatedObjectId> relatedObjectIds = new ArrayList<AtlasRelatedObjectId>();
        for (Object o : entity.getRelationshipAttributes().values()) {
            if (o instanceof AtlasRelatedObjectId) {
                relatedObjectIds.add((AtlasRelatedObjectId)o);
                continue;
            }
            if (!(o instanceof Collection)) continue;
            relatedObjectIds.addAll((List)o);
        }
        return relatedObjectIds;
    }
}

