/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.impexp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.entitytransform.BaseEntityHandler;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasExportResult;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.impexp.ImportTransforms;
import org.apache.atlas.repository.impexp.ZipExportFileNames;
import org.apache.atlas.repository.store.graph.v2.EntityImportStream;
import org.apache.atlas.type.AtlasType;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipSource
implements EntityImportStream {
    private static final Logger LOG = LoggerFactory.getLogger(ZipSource.class);
    private final InputStream inputStream;
    private List<String> creationOrder;
    private Iterator<String> iterator;
    private Map<String, String> guidEntityJsonMap;
    private ImportTransforms importTransform;
    private List<BaseEntityHandler> entityHandlers;
    private int currentPosition;

    public ZipSource(InputStream inputStream) throws IOException, AtlasBaseException {
        this(inputStream, null);
    }

    public ZipSource(InputStream inputStream, ImportTransforms importTransform) throws IOException, AtlasBaseException {
        this.inputStream = inputStream;
        this.guidEntityJsonMap = new HashMap<String, String>();
        this.importTransform = importTransform;
        this.updateGuidZipEntryMap();
        if (this.isZipFileEmpty()) {
            throw new AtlasBaseException(AtlasErrorCode.IMPORT_ATTEMPTING_EMPTY_ZIP, new String[]{"Attempting to import empty ZIP."});
        }
        this.setCreationOrder();
    }

    private boolean isZipFileEmpty() {
        if (MapUtils.isEmpty(this.guidEntityJsonMap)) {
            return true;
        }
        String key = ZipExportFileNames.ATLAS_EXPORT_ORDER_NAME.toString();
        return this.guidEntityJsonMap.containsKey(key) && StringUtils.isNotEmpty((String)this.guidEntityJsonMap.get(key)) && this.guidEntityJsonMap.get(key).equals("[]");
    }

    @Override
    public ImportTransforms getImportTransform() {
        return this.importTransform;
    }

    @Override
    public void setImportTransform(ImportTransforms importTransform) {
        this.importTransform = importTransform;
    }

    @Override
    public List<BaseEntityHandler> getEntityHandlers() {
        return this.entityHandlers;
    }

    @Override
    public void setEntityHandlers(List<BaseEntityHandler> entityHandlers) {
        this.entityHandlers = entityHandlers;
    }

    @Override
    public AtlasTypesDef getTypesDef() throws AtlasBaseException {
        String fileName = ZipExportFileNames.ATLAS_TYPESDEF_NAME.toString();
        String s = this.getFromCache(fileName);
        return this.convertFromJson(AtlasTypesDef.class, s);
    }

    @Override
    public AtlasExportResult getExportResult() throws AtlasBaseException {
        String fileName = ZipExportFileNames.ATLAS_EXPORT_INFO_NAME.toString();
        String s = this.getFromCache(fileName);
        return this.convertFromJson(AtlasExportResult.class, s);
    }

    private void setCreationOrder() {
        String fileName = ZipExportFileNames.ATLAS_EXPORT_ORDER_NAME.toString();
        try {
            String s = this.getFromCache(fileName);
            this.creationOrder = this.convertFromJson(List.class, s);
            this.iterator = this.creationOrder.iterator();
        }
        catch (AtlasBaseException e) {
            LOG.error(String.format("Error retrieving '%s' from zip.", fileName), (Throwable)e);
        }
    }

    private void updateGuidZipEntryMap() throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(this.inputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            String entryName = zipEntry.getName().replace(".json", "");
            if (this.guidEntityJsonMap.containsKey(entryName)) continue;
            byte[] buf = new byte[1024];
            int n = 0;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((n = zipInputStream.read(buf, 0, 1024)) > -1) {
                bos.write(buf, 0, n);
            }
            this.guidEntityJsonMap.put(entryName, bos.toString());
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.close();
    }

    @Override
    public List<String> getCreationOrder() {
        return this.creationOrder;
    }

    @Override
    public AtlasEntity.AtlasEntityWithExtInfo getEntityWithExtInfo(String guid) throws AtlasBaseException {
        String s = this.getFromCache(guid);
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.convertFromJson(AtlasEntity.AtlasEntityWithExtInfo.class, s);
        if (this.importTransform != null) {
            entityWithExtInfo = this.importTransform.apply(entityWithExtInfo);
        }
        if (this.entityHandlers != null) {
            this.applyTransformers(entityWithExtInfo);
        }
        return entityWithExtInfo;
    }

    private void applyTransformers(AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo) {
        if (entityWithExtInfo == null) {
            return;
        }
        this.transform(entityWithExtInfo.getEntity());
        if (MapUtils.isNotEmpty((Map)entityWithExtInfo.getReferredEntities())) {
            for (AtlasEntity e : entityWithExtInfo.getReferredEntities().values()) {
                this.transform(e);
            }
        }
    }

    private void transform(AtlasEntity e) {
        for (BaseEntityHandler handler : this.entityHandlers) {
            handler.transform(e);
        }
    }

    private <T> T convertFromJson(Class<T> clazz, String jsonData) throws AtlasBaseException {
        Object t;
        try {
            t = AtlasType.fromJson((String)jsonData, clazz);
            if (t == null) {
                LOG.error("Error converting file to JSON.");
                return null;
            }
        }
        catch (Exception e) {
            throw new AtlasBaseException("Error converting file to JSON.", (Throwable)e);
        }
        return (T)t;
    }

    private String getFromCache(String entryName) {
        String s = this.guidEntityJsonMap.get(entryName);
        if (StringUtils.isEmpty((String)s)) {
            LOG.warn("Could not fetch requested contents of file: {}", (Object)entryName);
        }
        return s;
    }

    @Override
    public void close() {
        try {
            this.inputStream.close();
            this.guidEntityJsonMap.clear();
        }
        catch (IOException ex) {
            LOG.warn("{}: Error closing streams.");
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public AtlasEntity next() {
        AtlasEntity.AtlasEntityWithExtInfo entityWithExtInfo = this.getNextEntityWithExtInfo();
        return entityWithExtInfo != null ? entityWithExtInfo.getEntity() : null;
    }

    @Override
    public AtlasEntity.AtlasEntityWithExtInfo getNextEntityWithExtInfo() {
        try {
            ++this.currentPosition;
            return this.getEntityWithExtInfo(this.iterator.next());
        }
        catch (AtlasBaseException e) {
            LOG.warn("getNextEntityWithExtInfo", (Throwable)e);
            return null;
        }
    }

    @Override
    public void reset() {
        this.getCreationOrder();
        this.iterator = this.creationOrder.iterator();
    }

    @Override
    public AtlasEntity getByGuid(String guid) {
        try {
            AtlasEntity entity = this.getEntity(guid);
            return entity;
        }
        catch (AtlasBaseException e) {
            LOG.error("getByGuid: {} failed!", (Object)guid, (Object)e);
            return null;
        }
    }

    private AtlasEntity getEntity(String guid) throws AtlasBaseException {
        if (this.guidEntityJsonMap.containsKey(guid)) {
            AtlasEntity.AtlasEntityWithExtInfo extInfo = this.getEntityWithExtInfo(guid);
            return extInfo != null ? extInfo.getEntity() : null;
        }
        return null;
    }

    @Override
    public int size() {
        return this.creationOrder.size();
    }

    @Override
    public void onImportComplete(String guid) {
        this.guidEntityJsonMap.remove(guid);
    }

    @Override
    public void setPosition(int index) {
        this.currentPosition = index;
        this.reset();
        for (int i = 0; i < this.creationOrder.size() && i <= index; ++i) {
            this.onImportComplete(this.iterator.next());
        }
    }

    @Override
    public void setPositionUsingEntityGuid(String guid) {
        if (StringUtils.isBlank((String)guid)) {
            return;
        }
        int index = this.creationOrder.indexOf(guid);
        if (index == -1) {
            return;
        }
        this.setPosition(index);
    }

    @Override
    public int getPosition() {
        return this.currentPosition;
    }
}

