/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.migration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import javax.inject.Inject;
import org.apache.atlas.AtlasException;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.impexp.AtlasImportResult;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graphdb.GraphDBMigrator;
import org.apache.atlas.repository.impexp.ImportService;
import org.apache.atlas.repository.impexp.ImportTypeDefProcessor;
import org.apache.atlas.repository.migration.ZipFileMigrationImporter;
import org.apache.atlas.repository.store.bootstrap.AtlasTypeDefStoreInitializer;
import org.apache.atlas.service.Service;
import org.apache.atlas.store.AtlasTypeDefStore;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DataMigrationService
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(DataMigrationService.class);
    private static final String FILE_EXTENSION_ZIP = ".zip";
    private static String ATLAS_MIGRATION_DATA_NAME = "atlas-migration-data.json";
    private static String ATLAS_MIGRATION_TYPESDEF_NAME = "atlas-migration-typesdef.json";
    private final Configuration configuration;
    private final Thread thread;

    @Inject
    public DataMigrationService(GraphDBMigrator migrator, AtlasTypeDefStore typeDefStore, Configuration configuration, GraphBackedSearchIndexer indexer, AtlasTypeDefStoreInitializer storeInitializer, AtlasTypeRegistry typeRegistry, ImportService importService) {
        this.configuration = configuration;
        String fileName = this.getFileName();
        boolean zipFileBasedMigrationImport = StringUtils.endsWithIgnoreCase((String)fileName, (String)FILE_EXTENSION_ZIP);
        this.thread = zipFileBasedMigrationImport ? new Thread((Runnable)new ZipFileMigrationImporter(importService, fileName), "zipFileBasedMigrationImporter") : new Thread(new FileImporter(migrator, typeDefStore, typeRegistry, storeInitializer, fileName, indexer));
    }

    public void start() {
        Runtime.getRuntime().addShutdownHook(this.thread);
        this.thread.start();
    }

    public void stop() {
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            LOG.error("Data Migration: Interrupted", (Throwable)e);
        }
    }

    public String getFileName() {
        return this.configuration.getString("atlas.migration.data.filename", "");
    }

    public static class FileImporter
    implements Runnable {
        private final GraphDBMigrator migrator;
        private final AtlasTypeDefStore typeDefStore;
        private final String importDirectory;
        private final GraphBackedSearchIndexer indexer;
        private final AtlasTypeRegistry typeRegistry;
        private final AtlasTypeDefStoreInitializer storeInitializer;

        public FileImporter(GraphDBMigrator migrator, AtlasTypeDefStore typeDefStore, AtlasTypeRegistry typeRegistry, AtlasTypeDefStoreInitializer storeInitializer, String directoryName, GraphBackedSearchIndexer indexer) {
            this.migrator = migrator;
            this.typeDefStore = typeDefStore;
            this.typeRegistry = typeRegistry;
            this.storeInitializer = storeInitializer;
            this.importDirectory = directoryName;
            this.indexer = indexer;
        }

        @Override
        public void run() {
            try {
                this.performImport();
            }
            catch (AtlasBaseException e) {
                LOG.error("Data Migration:", (Throwable)e);
            }
        }

        private void performImport() throws AtlasBaseException {
            try {
                if (!this.performAccessChecks(this.importDirectory)) {
                    return;
                }
                this.performInit();
                FileInputStream fs = new FileInputStream(this.getFileFromImportDirectory(this.importDirectory, ATLAS_MIGRATION_DATA_NAME));
                this.migrator.importData(this.typeRegistry, (InputStream)fs);
            }
            catch (Exception ex) {
                LOG.error("Import failed!", (Throwable)ex);
                throw new AtlasBaseException((Throwable)ex);
            }
        }

        private boolean performAccessChecks(String path) {
            boolean ret;
            if (StringUtils.isEmpty((String)path)) {
                ret = false;
            } else {
                File f = new File(path);
                boolean bl = ret = f.exists() && f.isDirectory() && f.canRead();
            }
            if (ret) {
                LOG.info("will migrate data in directory {}", (Object)this.importDirectory);
            } else {
                LOG.error("cannot read migration data in directory {}", (Object)this.importDirectory);
            }
            return ret;
        }

        private void performInit() throws AtlasBaseException, AtlasException {
            this.indexer.instanceIsActive();
            this.storeInitializer.instanceIsActive();
            this.processIncomingTypesDef(this.getFileFromImportDirectory(this.importDirectory, ATLAS_MIGRATION_TYPESDEF_NAME));
        }

        private void processIncomingTypesDef(File typesDefFile) throws AtlasBaseException {
            try {
                AtlasImportResult result = new AtlasImportResult();
                String jsonStr = FileUtils.readFileToString((File)typesDefFile);
                AtlasTypesDef typesDef = this.migrator.getScrubbedTypesDef(jsonStr);
                ImportTypeDefProcessor processor = new ImportTypeDefProcessor(this.typeDefStore, this.typeRegistry);
                processor.processTypes(typesDef, result);
                LOG.info("  types migrated: {}", (Object)result.getMetrics());
            }
            catch (IOException e) {
                LOG.error("processIncomingTypesDef: Could not process file: {}! Imported data may not be usable.", (Object)typesDefFile.getName());
            }
        }

        private File getFileFromImportDirectory(String importDirectory, String fileName) {
            return Paths.get(importDirectory, fileName).toFile();
        }
    }
}

