/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.store.graph.v2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.AtlasException;
import org.apache.atlas.RequestContext;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.listener.EntityChangeListener;
import org.apache.atlas.listener.EntityChangeListenerV2;
import org.apache.atlas.model.audit.EntityAuditEventV2;
import org.apache.atlas.model.glossary.AtlasGlossaryTerm;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasRelatedObjectId;
import org.apache.atlas.model.instance.AtlasRelationship;
import org.apache.atlas.model.instance.EntityMutationResponse;
import org.apache.atlas.model.instance.EntityMutations;
import org.apache.atlas.model.notification.EntityNotification;
import org.apache.atlas.repository.Constants;
import org.apache.atlas.repository.converters.AtlasInstanceConverter;
import org.apache.atlas.repository.graph.FullTextMapperV2;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.store.graph.v2.AtlasGraphUtilsV2;
import org.apache.atlas.repository.store.graph.v2.IAtlasEntityChangeNotifier;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.util.AtlasRepositoryConfiguration;
import org.apache.atlas.utils.AtlasPerfMetrics;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.atlas.v1.model.instance.Struct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AtlasEntityChangeNotifier
implements IAtlasEntityChangeNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasEntityChangeNotifier.class);
    private final Set<EntityChangeListener> entityChangeListeners;
    private final Set<EntityChangeListenerV2> entityChangeListenersV2;
    private final AtlasInstanceConverter instanceConverter;
    private final FullTextMapperV2 fullTextMapperV2;
    private final AtlasTypeRegistry atlasTypeRegistry;
    private final boolean isV2EntityNotificationEnabled;
    private static final Predicate<AtlasEntityHeader> PRED_IS_NOT_TYPE_AUDIT_ENTITY = obj -> !obj.getTypeName().equals("__AtlasAuditEntry");

    @Inject
    public AtlasEntityChangeNotifier(Set<EntityChangeListener> entityChangeListeners, Set<EntityChangeListenerV2> entityChangeListenersV2, AtlasInstanceConverter instanceConverter, FullTextMapperV2 fullTextMapperV2, AtlasTypeRegistry atlasTypeRegistry) {
        this.entityChangeListeners = entityChangeListeners;
        this.entityChangeListenersV2 = entityChangeListenersV2;
        this.instanceConverter = instanceConverter;
        this.fullTextMapperV2 = fullTextMapperV2;
        this.atlasTypeRegistry = atlasTypeRegistry;
        this.isV2EntityNotificationEnabled = AtlasRepositoryConfiguration.isV2EntityNotificationEnabled();
    }

    @Override
    public void onEntitiesMutated(EntityMutationResponse entityMutationResponse, boolean isImport) throws AtlasBaseException {
        if (CollectionUtils.isEmpty(this.entityChangeListeners)) {
            return;
        }
        this.pruneResponse(entityMutationResponse);
        List createdEntities = entityMutationResponse.getCreatedEntities();
        List updatedEntities = entityMutationResponse.getUpdatedEntities();
        List partiallyUpdatedEntities = entityMutationResponse.getPartialUpdatedEntities();
        List deletedEntities = entityMutationResponse.getDeletedEntities();
        List purgedEntities = entityMutationResponse.getPurgedEntities();
        this.doFullTextMapping(createdEntities);
        this.doFullTextMapping(updatedEntities);
        this.doFullTextMapping(partiallyUpdatedEntities);
        this.notifyListeners(createdEntities, EntityMutations.EntityOperation.CREATE, isImport);
        this.notifyListeners(updatedEntities, EntityMutations.EntityOperation.UPDATE, isImport);
        this.notifyListeners(partiallyUpdatedEntities, EntityMutations.EntityOperation.PARTIAL_UPDATE, isImport);
        this.notifyListeners(deletedEntities, EntityMutations.EntityOperation.DELETE, isImport);
        this.notifyListeners(purgedEntities, EntityMutations.EntityOperation.PURGE, isImport);
        this.notifyPropagatedEntities();
    }

    @Override
    public void notifyRelationshipMutation(AtlasRelationship relationship, EntityNotification.EntityNotificationV2.OperationType operationType) throws AtlasBaseException {
        if (CollectionUtils.isEmpty(this.entityChangeListeners)) {
            return;
        }
        switch (operationType) {
            case RELATIONSHIP_CREATE: {
                this.notifyRelationshipListeners(Collections.singletonList(relationship), EntityMutations.EntityOperation.CREATE, false);
                break;
            }
            case RELATIONSHIP_UPDATE: {
                this.notifyRelationshipListeners(Collections.singletonList(relationship), EntityMutations.EntityOperation.UPDATE, false);
                break;
            }
            case RELATIONSHIP_DELETE: {
                this.notifyRelationshipListeners(Collections.singletonList(relationship), EntityMutations.EntityOperation.DELETE, false);
            }
        }
    }

    @Override
    public void onClassificationAddedToEntity(AtlasEntity entity, List<AtlasClassification> addedClassifications) throws AtlasBaseException {
        block6: {
            block5: {
                if (!this.isV2EntityNotificationEnabled) break block5;
                this.doFullTextMapping(entity.getGuid());
                for (EntityChangeListenerV2 listener : this.entityChangeListenersV2) {
                    listener.onClassificationsAdded(entity, addedClassifications);
                }
                break block6;
            }
            this.updateFullTextMapping(entity.getGuid(), addedClassifications);
            if (this.instanceConverter == null) break block6;
            Referenceable entityRef = this.toReferenceable(entity.getGuid());
            List<Struct> traits = this.toStruct(addedClassifications);
            if (entityRef == null || CollectionUtils.isEmpty(traits)) {
                return;
            }
            for (EntityChangeListener listener : this.entityChangeListeners) {
                try {
                    listener.onTraitsAdded(entityRef, traits);
                }
                catch (AtlasException e) {
                    throw new AtlasBaseException(AtlasErrorCode.NOTIFICATION_FAILED, (Throwable)e, new String[]{this.getListenerName(listener), "TraitAdd"});
                }
            }
        }
    }

    @Override
    public void onClassificationsAddedToEntities(List<AtlasEntity> entities, List<AtlasClassification> addedClassifications) throws AtlasBaseException {
        block7: {
            List<Struct> traits;
            block6: {
                if (!this.isV2EntityNotificationEnabled) break block6;
                this.doFullTextMappingHelper(entities);
                for (EntityChangeListenerV2 listener : this.entityChangeListenersV2) {
                    listener.onClassificationsAdded(entities, addedClassifications);
                }
                break block7;
            }
            this.updateFullTextMapping(entities, addedClassifications);
            if (this.instanceConverter == null || CollectionUtils.isEmpty(traits = this.toStruct(addedClassifications))) break block7;
            for (AtlasEntity entity : entities) {
                Referenceable entityRef = this.toReferenceable(entity.getGuid());
                if (entityRef == null) {
                    LOG.warn("EntityRef with guid {} not found while adding classifications {} ", (Object)entity.getGuid(), addedClassifications);
                    continue;
                }
                for (EntityChangeListener listener : this.entityChangeListeners) {
                    try {
                        listener.onTraitsAdded(entityRef, traits);
                    }
                    catch (AtlasException e) {
                        throw new AtlasBaseException(AtlasErrorCode.NOTIFICATION_FAILED, (Throwable)e, new String[]{this.getListenerName(listener), "TraitAdd"});
                    }
                }
            }
        }
    }

    @Override
    public void onClassificationUpdatedToEntity(AtlasEntity entity, List<AtlasClassification> updatedClassifications) throws AtlasBaseException {
        block6: {
            block5: {
                this.doFullTextMapping(entity.getGuid());
                if (!this.isV2EntityNotificationEnabled) break block5;
                for (EntityChangeListenerV2 listener : this.entityChangeListenersV2) {
                    listener.onClassificationsUpdated(entity, updatedClassifications);
                }
                break block6;
            }
            if (this.instanceConverter == null) break block6;
            Referenceable entityRef = this.toReferenceable(entity.getGuid());
            List<Struct> traits = this.toStruct(updatedClassifications);
            if (entityRef == null || CollectionUtils.isEmpty(traits)) {
                return;
            }
            for (EntityChangeListener listener : this.entityChangeListeners) {
                try {
                    listener.onTraitsUpdated(entityRef, traits);
                }
                catch (AtlasException e) {
                    throw new AtlasBaseException(AtlasErrorCode.NOTIFICATION_FAILED, (Throwable)e, new String[]{this.getListenerName(listener), "TraitUpdate"});
                }
            }
        }
    }

    @Override
    public void onClassificationDeletedFromEntity(AtlasEntity entity, List<AtlasClassification> deletedClassifications) throws AtlasBaseException {
        block6: {
            block5: {
                this.doFullTextMapping(entity.getGuid());
                if (!this.isV2EntityNotificationEnabled) break block5;
                for (EntityChangeListenerV2 listener : this.entityChangeListenersV2) {
                    listener.onClassificationsDeleted(entity, deletedClassifications);
                }
                break block6;
            }
            if (this.instanceConverter == null) break block6;
            Referenceable entityRef = this.toReferenceable(entity.getGuid());
            List<Struct> traits = this.toStruct(deletedClassifications);
            if (entityRef == null || CollectionUtils.isEmpty(deletedClassifications)) {
                return;
            }
            for (EntityChangeListener listener : this.entityChangeListeners) {
                try {
                    listener.onTraitsDeleted(entityRef, traits);
                }
                catch (AtlasException e) {
                    throw new AtlasBaseException(AtlasErrorCode.NOTIFICATION_FAILED, (Throwable)e, new String[]{this.getListenerName(listener), "TraitDelete"});
                }
            }
        }
    }

    @Override
    public void onClassificationsDeletedFromEntities(List<AtlasEntity> entities, List<AtlasClassification> deletedClassifications) throws AtlasBaseException {
        block8: {
            block7: {
                this.doFullTextMappingHelper(entities);
                if (!this.isV2EntityNotificationEnabled) break block7;
                for (EntityChangeListenerV2 listener : this.entityChangeListenersV2) {
                    listener.onClassificationsDeleted(entities, deletedClassifications);
                }
                break block8;
            }
            if (this.instanceConverter == null) break block8;
            List<Struct> traits = this.toStruct(deletedClassifications);
            if (!CollectionUtils.isEmpty(deletedClassifications)) {
                for (AtlasEntity entity : entities) {
                    Referenceable entityRef = this.toReferenceable(entity.getGuid());
                    if (entityRef == null) {
                        LOG.warn("EntityRef with guid {} not found while deleting classifications {} ", (Object)entity.getGuid(), deletedClassifications);
                        continue;
                    }
                    for (EntityChangeListener listener : this.entityChangeListeners) {
                        try {
                            listener.onTraitsDeleted(entityRef, traits);
                        }
                        catch (AtlasException e) {
                            throw new AtlasBaseException(AtlasErrorCode.NOTIFICATION_FAILED, (Throwable)e, new String[]{this.getListenerName(listener), "TraitDelete"});
                        }
                    }
                }
            }
        }
    }

    @Override
    public void onTermAddedToEntities(AtlasGlossaryTerm term, List<AtlasRelatedObjectId> entityIds) throws AtlasBaseException {
        block5: {
            block4: {
                if (!this.isV2EntityNotificationEnabled) break block4;
                for (EntityChangeListenerV2 listener : this.entityChangeListenersV2) {
                    listener.onTermAdded(term, entityIds);
                }
                break block5;
            }
            if (this.instanceConverter == null) break block5;
            List<Referenceable> entityRefs = this.toReferenceables(entityIds);
            for (EntityChangeListener listener : this.entityChangeListeners) {
                try {
                    listener.onTermAdded(entityRefs, term);
                }
                catch (AtlasException e) {
                    throw new AtlasBaseException(AtlasErrorCode.NOTIFICATION_FAILED, (Throwable)e, new String[]{this.getListenerName(listener), "TermAdd"});
                }
            }
        }
    }

    @Override
    public void onTermDeletedFromEntities(AtlasGlossaryTerm term, List<AtlasRelatedObjectId> entityIds) throws AtlasBaseException {
        block5: {
            block4: {
                if (!this.isV2EntityNotificationEnabled) break block4;
                for (EntityChangeListenerV2 listener : this.entityChangeListenersV2) {
                    listener.onTermDeleted(term, entityIds);
                }
                break block5;
            }
            if (this.instanceConverter == null) break block5;
            List<Referenceable> entityRefs = this.toReferenceables(entityIds);
            for (EntityChangeListener listener : this.entityChangeListeners) {
                try {
                    listener.onTermDeleted(entityRefs, term);
                }
                catch (AtlasException e) {
                    throw new AtlasBaseException(AtlasErrorCode.NOTIFICATION_FAILED, (Throwable)e, new String[]{this.getListenerName(listener), "TermDelete"});
                }
            }
        }
    }

    @Override
    public void onLabelsUpdatedFromEntity(String entityGuid, Set<String> addedLabels, Set<String> deletedLabels) throws AtlasBaseException {
        this.doFullTextMapping(entityGuid);
        if (this.isV2EntityNotificationEnabled) {
            AtlasEntity entity = this.instanceConverter.getAndCacheEntity(entityGuid);
            for (EntityChangeListenerV2 listener : this.entityChangeListenersV2) {
                listener.onLabelsDeleted(entity, deletedLabels);
                listener.onLabelsAdded(entity, addedLabels);
            }
        }
    }

    @Override
    public void notifyPropagatedEntities() throws AtlasBaseException {
        RequestContext context = RequestContext.get();
        Map addedPropagations = context.getAddedPropagations();
        Map removedPropagations = context.getRemovedPropagations();
        this.notifyPropagatedEntities(addedPropagations, EntityAuditEventV2.EntityAuditActionV2.PROPAGATED_CLASSIFICATION_ADD);
        context.clearAddedPropagations();
        this.notifyPropagatedEntities(removedPropagations, EntityAuditEventV2.EntityAuditActionV2.PROPAGATED_CLASSIFICATION_DELETE);
        context.clearRemovePropagations();
    }

    @Override
    public void onBusinessAttributesUpdated(String entityGuid, Map<String, Map<String, Object>> updatedBusinessAttributes) throws AtlasBaseException {
        if (this.isV2EntityNotificationEnabled) {
            AtlasEntity entity = this.instanceConverter.getAndCacheEntity(entityGuid);
            for (EntityChangeListenerV2 listener : this.entityChangeListenersV2) {
                listener.onBusinessAttributesUpdated(entity, updatedBusinessAttributes);
            }
        }
    }

    private void notifyPropagatedEntities(Map<String, List<AtlasClassification>> entityPropagationMap, EntityAuditEventV2.EntityAuditActionV2 action) throws AtlasBaseException {
        if (MapUtils.isEmpty(entityPropagationMap) || action == null) {
            return;
        }
        RequestContext context = RequestContext.get();
        for (String guid : entityPropagationMap.keySet()) {
            AtlasEntity entity;
            if (context.isDeletedEntity(guid) || (entity = this.fullTextMapperV2.getAndCacheEntity(guid)) == null) continue;
            if (action == EntityAuditEventV2.EntityAuditActionV2.PROPAGATED_CLASSIFICATION_ADD) {
                this.onClassificationAddedToEntity(entity, entityPropagationMap.get(guid));
                continue;
            }
            if (action != EntityAuditEventV2.EntityAuditActionV2.PROPAGATED_CLASSIFICATION_DELETE) continue;
            this.onClassificationDeletedFromEntity(entity, entityPropagationMap.get(guid));
        }
    }

    private String getListenerName(EntityChangeListener listener) {
        return listener.getClass().getSimpleName();
    }

    private boolean skipAuditEntries(List<AtlasEntityHeader> entityHeaders) {
        return CollectionUtils.isEmpty(entityHeaders) || !entityHeaders.stream().anyMatch(PRED_IS_NOT_TYPE_AUDIT_ENTITY);
    }

    private void notifyListeners(List<AtlasEntityHeader> entityHeaders, EntityMutations.EntityOperation operation, boolean isImport) throws AtlasBaseException {
        if (CollectionUtils.isEmpty(entityHeaders)) {
            return;
        }
        if (this.skipAuditEntries(entityHeaders)) {
            return;
        }
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("notifyListeners");
        if (this.isV2EntityNotificationEnabled) {
            this.notifyV2Listeners(entityHeaders, operation, isImport);
        } else {
            this.notifyV1Listeners(entityHeaders, operation, isImport);
        }
        RequestContext.get().endMetricRecord(metric);
    }

    private void notifyRelationshipListeners(List<AtlasRelationship> relationships, EntityMutations.EntityOperation operation, boolean isImport) throws AtlasBaseException {
        if (CollectionUtils.isEmpty(relationships)) {
            return;
        }
        if (this.isV2EntityNotificationEnabled) {
            this.notifyV2RelationshipListeners(relationships, operation, isImport);
            return;
        }
        LOG.warn("Relationships not supported by v1 notifications. {}", relationships);
    }

    private void notifyV1Listeners(List<AtlasEntityHeader> entityHeaders, EntityMutations.EntityOperation operation, boolean isImport) throws AtlasBaseException {
        if (operation != EntityMutations.EntityOperation.PURGE && this.instanceConverter != null) {
            List<Referenceable> typedRefInsts = this.toReferenceables(entityHeaders, operation);
            for (EntityChangeListener listener : this.entityChangeListeners) {
                try {
                    switch (operation) {
                        case CREATE: {
                            listener.onEntitiesAdded(typedRefInsts, isImport);
                            break;
                        }
                        case UPDATE: 
                        case PARTIAL_UPDATE: {
                            listener.onEntitiesUpdated(typedRefInsts, isImport);
                            break;
                        }
                        case DELETE: {
                            listener.onEntitiesDeleted(typedRefInsts, isImport);
                        }
                    }
                }
                catch (AtlasException e) {
                    throw new AtlasBaseException(AtlasErrorCode.NOTIFICATION_FAILED, (Throwable)e, new String[]{this.getListenerName(listener), operation.toString()});
                }
            }
        }
    }

    private void notifyV2Listeners(List<AtlasEntityHeader> entityHeaders, EntityMutations.EntityOperation operation, boolean isImport) throws AtlasBaseException {
        List<AtlasEntity> entities = this.toAtlasEntities(entityHeaders, operation);
        for (EntityChangeListenerV2 listener : this.entityChangeListenersV2) {
            switch (operation) {
                case CREATE: {
                    listener.onEntitiesAdded(entities, isImport);
                    break;
                }
                case UPDATE: 
                case PARTIAL_UPDATE: {
                    listener.onEntitiesUpdated(entities, isImport);
                    break;
                }
                case DELETE: {
                    listener.onEntitiesDeleted(entities, isImport);
                    break;
                }
                case PURGE: {
                    listener.onEntitiesPurged(entities);
                }
            }
        }
    }

    private void notifyV2RelationshipListeners(List<AtlasRelationship> relationships, EntityMutations.EntityOperation operation, boolean isImport) throws AtlasBaseException {
        for (EntityChangeListenerV2 listener : this.entityChangeListenersV2) {
            switch (operation) {
                case CREATE: {
                    listener.onRelationshipsAdded(relationships, isImport);
                    break;
                }
                case UPDATE: 
                case PARTIAL_UPDATE: {
                    listener.onRelationshipsUpdated(relationships, isImport);
                    break;
                }
                case DELETE: {
                    listener.onRelationshipsDeleted(relationships, isImport);
                    break;
                }
                case PURGE: {
                    listener.onRelationshipsPurged(relationships);
                }
            }
        }
    }

    private List<Referenceable> toReferenceables(List<AtlasEntityHeader> entityHeaders, EntityMutations.EntityOperation operation) throws AtlasBaseException {
        ArrayList<Referenceable> ret;
        block4: {
            ret = new ArrayList<Referenceable>(entityHeaders.size());
            if (this.instanceConverter == null) break block4;
            if (operation == EntityMutations.EntityOperation.DELETE) {
                for (AtlasEntityHeader entityHeader : entityHeaders) {
                    ret.add(new Referenceable(entityHeader.getGuid(), entityHeader.getTypeName(), entityHeader.getAttributes()));
                }
            } else {
                for (AtlasEntityHeader entityHeader : entityHeaders) {
                    ret.add(this.toReferenceable(entityHeader.getGuid()));
                }
            }
        }
        return ret;
    }

    private List<Referenceable> toReferenceables(List<AtlasRelatedObjectId> entityIds) throws AtlasBaseException {
        ArrayList<Referenceable> ret = new ArrayList<Referenceable>();
        if (this.instanceConverter != null && CollectionUtils.isNotEmpty(entityIds)) {
            for (AtlasRelatedObjectId relatedObjectId : entityIds) {
                String entityGuid = relatedObjectId.getGuid();
                ret.add(this.toReferenceable(entityGuid));
            }
        }
        return ret;
    }

    private Referenceable toReferenceable(String entityId) throws AtlasBaseException {
        Referenceable ret = null;
        if (this.instanceConverter != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)entityId)) {
            ret = this.instanceConverter.getReferenceable(entityId);
        }
        return ret;
    }

    private List<Struct> toStruct(List<AtlasClassification> classifications) throws AtlasBaseException {
        ArrayList<Struct> ret = null;
        if (this.instanceConverter != null && classifications != null) {
            ret = new ArrayList<Struct>(classifications.size());
            for (AtlasClassification classification : classifications) {
                if (classification == null) continue;
                ret.add(this.instanceConverter.getTrait(classification));
            }
        }
        return ret;
    }

    private List<AtlasEntity> toAtlasEntities(List<AtlasEntityHeader> entityHeaders, EntityMutations.EntityOperation operation) throws AtlasBaseException {
        ArrayList<AtlasEntity> ret = new ArrayList<AtlasEntity>();
        if (CollectionUtils.isNotEmpty(entityHeaders)) {
            for (AtlasEntityHeader entityHeader : entityHeaders) {
                AtlasEntity entity;
                String typeName = entityHeader.getTypeName();
                AtlasEntityType entityType = this.atlasTypeRegistry.getEntityTypeByName(typeName);
                if (entityType == null) continue;
                if (entityType.isInternalType()) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Skipping internal type = {}", (Object)typeName);
                    continue;
                }
                if (operation == EntityMutations.EntityOperation.DELETE || operation == EntityMutations.EntityOperation.PURGE) {
                    entity = new AtlasEntity(entityHeader);
                } else {
                    String entityGuid = entityHeader.getGuid();
                    entity = this.fullTextMapperV2.getAndCacheEntity(entityGuid);
                }
                if (entity == null) continue;
                ret.add(entity);
            }
        }
        return ret;
    }

    private void doFullTextMapping(List<AtlasEntityHeader> entityHeaders) {
        if (AtlasRepositoryConfiguration.isFreeTextSearchEnabled() || !AtlasRepositoryConfiguration.isFullTextSearchEnabled()) {
            return;
        }
        if (CollectionUtils.isEmpty(entityHeaders)) {
            return;
        }
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("fullTextMapping");
        for (AtlasEntityHeader entityHeader : entityHeaders) {
            String guid;
            AtlasVertex vertex;
            if (GraphHelper.isInternalType(entityHeader.getTypeName()) || (vertex = AtlasGraphUtilsV2.findByGuid(guid = entityHeader.getGuid())) == null) continue;
            try {
                String fullText = this.fullTextMapperV2.getIndexTextForEntity(guid);
                AtlasGraphUtilsV2.setEncodedProperty(vertex, Constants.ENTITY_TEXT_PROPERTY_KEY, fullText);
            }
            catch (AtlasBaseException e) {
                LOG.error("FullText mapping failed for Vertex[ guid = {} ]", (Object)guid, (Object)e);
            }
        }
        RequestContext.get().endMetricRecord(metric);
    }

    private void updateFullTextMapping(String entityId, List<AtlasClassification> classifications) {
        if (AtlasRepositoryConfiguration.isFreeTextSearchEnabled() || !AtlasRepositoryConfiguration.isFullTextSearchEnabled()) {
            return;
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)entityId) || CollectionUtils.isEmpty(classifications)) {
            return;
        }
        AtlasVertex atlasVertex = AtlasGraphUtilsV2.findByGuid(entityId);
        if (atlasVertex == null || GraphHelper.isInternalType(atlasVertex)) {
            return;
        }
        AtlasPerfMetrics.MetricRecorder metric = RequestContext.get().startMetricRecord("fullTextMapping");
        try {
            String classificationFullText = this.fullTextMapperV2.getIndexTextForClassifications(entityId, classifications);
            String existingFullText = AtlasGraphUtilsV2.getEncodedProperty(atlasVertex, Constants.ENTITY_TEXT_PROPERTY_KEY, String.class);
            String newFullText = existingFullText + " " + classificationFullText;
            AtlasGraphUtilsV2.setEncodedProperty(atlasVertex, Constants.ENTITY_TEXT_PROPERTY_KEY, newFullText);
        }
        catch (AtlasBaseException e) {
            LOG.error("FullText mapping failed for Vertex[ guid = {} ]", (Object)entityId, (Object)e);
        }
        RequestContext.get().endMetricRecord(metric);
    }

    private void updateFullTextMapping(List<AtlasEntity> entities, List<AtlasClassification> classifications) {
        for (AtlasEntity entity : entities) {
            this.updateFullTextMapping(entity.getGuid(), classifications);
        }
    }

    private void doFullTextMapping(String guid) {
        if (AtlasRepositoryConfiguration.isFreeTextSearchEnabled() || !AtlasRepositoryConfiguration.isFullTextSearchEnabled()) {
            return;
        }
        AtlasEntityHeader entityHeader = new AtlasEntityHeader();
        entityHeader.setGuid(guid);
        this.doFullTextMapping(Collections.singletonList(entityHeader));
    }

    private void doFullTextMappingHelper(List<AtlasEntity> entities) {
        for (AtlasEntity entity : entities) {
            this.doFullTextMapping(entity.getGuid());
        }
    }

    private void pruneResponse(EntityMutationResponse resp) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> pruneResponse()");
        }
        List createdEntities = resp.getCreatedEntities();
        List updatedEntities = resp.getUpdatedEntities();
        List partialUpdatedEntities = resp.getPartialUpdatedEntities();
        List deletedEntities = resp.getDeletedEntities();
        List purgedEntities = resp.getPurgedEntities();
        this.purgeDeletedEntities(createdEntities);
        this.purgeDeletedEntities(updatedEntities);
        this.purgeDeletedEntities(partialUpdatedEntities);
        if (purgedEntities != null) {
            for (AtlasEntityHeader entity : purgedEntities) {
                this.purgeEntity(entity.getGuid(), deletedEntities);
                this.purgeEntity(entity.getGuid(), createdEntities);
                this.purgeEntity(entity.getGuid(), updatedEntities);
                this.purgeEntity(entity.getGuid(), partialUpdatedEntities);
            }
        }
        if (deletedEntities != null) {
            for (AtlasEntityHeader entity : deletedEntities) {
                this.purgeEntity(entity.getGuid(), createdEntities);
                this.purgeEntity(entity.getGuid(), updatedEntities);
                this.purgeEntity(entity.getGuid(), partialUpdatedEntities);
            }
        }
        if (createdEntities != null) {
            for (AtlasEntityHeader entity : createdEntities) {
                this.purgeEntity(entity.getGuid(), updatedEntities);
                this.purgeEntity(entity.getGuid(), partialUpdatedEntities);
            }
        }
        if (updatedEntities != null) {
            for (AtlasEntityHeader entity : updatedEntities) {
                this.purgeEntity(entity.getGuid(), partialUpdatedEntities);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== pruneResponse()");
        }
    }

    private void purgeDeletedEntities(List<AtlasEntityHeader> entities) {
        if (entities != null) {
            ListIterator<AtlasEntityHeader> iter = entities.listIterator();
            while (iter.hasNext()) {
                AtlasEntityHeader entity = iter.next();
                if (entity.getStatus() != AtlasEntity.Status.DELETED) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("purgeDeletedEntities(guid={}, status={}): REMOVED", (Object)entity.getGuid(), (Object)entity.getStatus());
                }
                iter.remove();
            }
        }
    }

    private void purgeEntity(String guid, List<AtlasEntityHeader> entities) {
        if (guid != null && entities != null) {
            ListIterator<AtlasEntityHeader> iter = entities.listIterator();
            while (iter.hasNext()) {
                AtlasEntityHeader entity = iter.next();
                if (!StringUtils.equals((String)guid, (String)entity.getGuid())) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("purgeEntity(guid={}): REMOVED", (Object)entity.getGuid());
                }
                iter.remove();
            }
        }
    }
}

