/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.composites;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.index.AbstractSimplePerColumnSecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.index.SecondaryIndexSearcher;
import org.apache.cassandra.db.index.composites.CompositesIndexOnClusteringKey;
import org.apache.cassandra.db.index.composites.CompositesIndexOnCollectionKey;
import org.apache.cassandra.db.index.composites.CompositesIndexOnCollectionValue;
import org.apache.cassandra.db.index.composites.CompositesIndexOnPartitionKey;
import org.apache.cassandra.db.index.composites.CompositesIndexOnRegular;
import org.apache.cassandra.db.index.composites.CompositesSearcher;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.utils.concurrent.OpOrder;

public abstract class CompositesIndex
extends AbstractSimplePerColumnSecondaryIndex {
    private volatile CellNameType indexComparator;

    protected CellNameType getIndexComparator() {
        if (this.indexComparator == null) {
            assert (this.columnDef != null);
            this.indexComparator = CompositesIndex.getIndexComparator(this.baseCfs.metadata, this.columnDef);
        }
        return this.indexComparator;
    }

    public static CompositesIndex create(ColumnDefinition cfDef) {
        if (cfDef.type.isCollection() && cfDef.type.isMultiCell()) {
            switch (((CollectionType)cfDef.type).kind) {
                case LIST: {
                    return new CompositesIndexOnCollectionValue();
                }
                case SET: {
                    return new CompositesIndexOnCollectionKey();
                }
                case MAP: {
                    return cfDef.hasIndexOption("index_keys") ? new CompositesIndexOnCollectionKey() : new CompositesIndexOnCollectionValue();
                }
            }
        }
        switch (cfDef.kind) {
            case CLUSTERING_COLUMN: {
                return new CompositesIndexOnClusteringKey();
            }
            case REGULAR: {
                return new CompositesIndexOnRegular();
            }
            case PARTITION_KEY: {
                return new CompositesIndexOnPartitionKey();
            }
        }
        throw new AssertionError();
    }

    public static CellNameType getIndexComparator(CFMetaData baseMetadata, ColumnDefinition cfDef) {
        if (cfDef.type.isCollection() && cfDef.type.isMultiCell()) {
            switch (((CollectionType)cfDef.type).kind) {
                case LIST: {
                    return CompositesIndexOnCollectionValue.buildIndexComparator(baseMetadata, cfDef);
                }
                case SET: {
                    return CompositesIndexOnCollectionKey.buildIndexComparator(baseMetadata, cfDef);
                }
                case MAP: {
                    return cfDef.hasIndexOption("index_keys") ? CompositesIndexOnCollectionKey.buildIndexComparator(baseMetadata, cfDef) : CompositesIndexOnCollectionValue.buildIndexComparator(baseMetadata, cfDef);
                }
            }
        }
        switch (cfDef.kind) {
            case CLUSTERING_COLUMN: {
                return CompositesIndexOnClusteringKey.buildIndexComparator(baseMetadata, cfDef);
            }
            case REGULAR: {
                return CompositesIndexOnRegular.buildIndexComparator(baseMetadata, cfDef);
            }
            case PARTITION_KEY: {
                return CompositesIndexOnPartitionKey.buildIndexComparator(baseMetadata, cfDef);
            }
        }
        throw new AssertionError();
    }

    @Override
    protected CellName makeIndexColumnName(ByteBuffer rowKey, Cell cell) {
        return this.getIndexComparator().create(this.makeIndexColumnPrefix(rowKey, cell.name()), null);
    }

    protected abstract Composite makeIndexColumnPrefix(ByteBuffer var1, Composite var2);

    public abstract IndexedEntry decodeEntry(DecoratedKey var1, Cell var2);

    public abstract boolean isStale(IndexedEntry var1, ColumnFamily var2, long var3);

    public void delete(IndexedEntry entry, OpOrder.Group opGroup) {
        int localDeletionTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayBackedSortedColumns cfi = ArrayBackedSortedColumns.factory.create(this.indexCfs.metadata);
        cfi.addTombstone(entry.indexEntry, localDeletionTime, entry.timestamp);
        this.indexCfs.apply(entry.indexValue, cfi, SecondaryIndexManager.nullUpdater, opGroup, null);
        if (logger.isDebugEnabled()) {
            logger.debug("removed index entry for cleaned-up value {}:{}", (Object)entry.indexValue, (Object)cfi);
        }
    }

    @Override
    protected AbstractType<?> getExpressionComparator() {
        return this.baseCfs.metadata.getColumnDefinitionComparator(this.columnDef);
    }

    @Override
    public SecondaryIndexSearcher createSecondaryIndexSearcher(Set<ByteBuffer> columns) {
        return new CompositesSearcher(this.baseCfs.indexManager, columns);
    }

    @Override
    public void validateOptions() throws ConfigurationException {
        ColumnDefinition columnDef = (ColumnDefinition)this.columnDefs.iterator().next();
        HashMap<String, String> options = new HashMap<String, String>(columnDef.getIndexOptions());
        options.remove("prefix_size");
        if (columnDef.type.isCollection()) {
            options.remove("index_values");
            options.remove("index_keys");
        }
        if (!options.isEmpty()) {
            throw new ConfigurationException("Unknown options provided for COMPOSITES index: " + options.keySet());
        }
    }

    public static class IndexedEntry {
        public final DecoratedKey indexValue;
        public final CellName indexEntry;
        public final long timestamp;
        public final ByteBuffer indexedKey;
        public final Composite indexedEntryPrefix;
        public final ByteBuffer indexedEntryCollectionKey;

        public IndexedEntry(DecoratedKey indexValue, CellName indexEntry, long timestamp, ByteBuffer indexedKey, Composite indexedEntryPrefix) {
            this(indexValue, indexEntry, timestamp, indexedKey, indexedEntryPrefix, null);
        }

        public IndexedEntry(DecoratedKey indexValue, CellName indexEntry, long timestamp, ByteBuffer indexedKey, Composite indexedEntryPrefix, ByteBuffer indexedEntryCollectionKey) {
            this.indexValue = indexValue;
            this.indexEntry = indexEntry;
            this.timestamp = timestamp;
            this.indexedKey = indexedKey;
            this.indexedEntryPrefix = indexedEntryPrefix;
            this.indexedEntryCollectionKey = indexedEntryCollectionKey;
        }
    }
}

