/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CollectionType<T>
extends AbstractType<T> {
    private static final Logger logger = LoggerFactory.getLogger(CollectionType.class);
    public static final int MAX_ELEMENTS = 65535;
    public final Kind kind;

    protected CollectionType(Kind kind) {
        this.kind = kind;
    }

    public abstract AbstractType<?> nameComparator();

    public abstract AbstractType<?> valueComparator();

    @Override
    public abstract CollectionSerializer<T> getSerializer();

    @Override
    public String getString(ByteBuffer bytes) {
        return BytesType.instance.getString(bytes);
    }

    @Override
    public ByteBuffer fromString(String source) {
        try {
            return ByteBufferUtil.hexToBytes(source);
        }
        catch (NumberFormatException e) {
            throw new MarshalException(String.format("cannot parse '%s' as hex bytes", source), e);
        }
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public void validateCellValue(ByteBuffer cellValue) throws MarshalException {
        if (this.isMultiCell()) {
            this.valueComparator().validate(cellValue);
        } else {
            super.validateCellValue(cellValue);
        }
    }

    public boolean isMap() {
        return this.kind == Kind.MAP;
    }

    public List<Cell> enforceLimit(ColumnDefinition def, List<Cell> cells, int version) {
        assert (this.isMultiCell());
        if (version >= 3 || cells.size() <= 65535) {
            return cells;
        }
        logger.error("Detected collection for table {}.{} with {} elements, more than the {} limit. Only the first {} elements will be returned to the client. Please see http://cassandra.apache.org/doc/cql3/CQL.html#collections for more details.", new Object[]{def.ksName, def.cfName, cells.size(), 65535, 65535});
        return cells.subList(0, 65535);
    }

    public abstract List<ByteBuffer> serializedValues(List<Cell> var1);

    public ByteBuffer serializeForNativeProtocol(ColumnDefinition def, List<Cell> cells, int version) {
        assert (this.isMultiCell());
        cells = this.enforceLimit(def, cells, version);
        List<ByteBuffer> values = this.serializedValues(cells);
        return CollectionSerializer.pack(values, cells.size(), version);
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        if (this == previous) {
            return true;
        }
        if (!this.getClass().equals(previous.getClass())) {
            return false;
        }
        CollectionType tprev = (CollectionType)previous;
        if (this.isMultiCell() != tprev.isMultiCell()) {
            return false;
        }
        if (!this.isMultiCell()) {
            return this.isCompatibleWithFrozen(tprev);
        }
        if (!this.nameComparator().isCompatibleWith(tprev.nameComparator())) {
            return false;
        }
        return this.valueComparator().isValueCompatibleWith(tprev.valueComparator());
    }

    @Override
    public boolean isValueCompatibleWithInternal(AbstractType<?> previous) {
        if (this.isMultiCell()) {
            return this.isCompatibleWith(previous);
        }
        if (this == previous) {
            return true;
        }
        if (!this.getClass().equals(previous.getClass())) {
            return false;
        }
        CollectionType tprev = (CollectionType)previous;
        if (this.isMultiCell() != tprev.isMultiCell()) {
            return false;
        }
        return this.isValueCompatibleWithFrozen(tprev);
    }

    protected abstract boolean isCompatibleWithFrozen(CollectionType<?> var1);

    protected abstract boolean isValueCompatibleWithFrozen(CollectionType<?> var1);

    @Override
    public CQL3Type asCQL3Type() {
        return new CQL3Type.Collection(this);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public static enum Kind {
        MAP,
        SET,
        LIST;

    }
}

