/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.File;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SegmentedFile;
import org.apache.cassandra.service.FileCacheService;

public abstract class PoolingSegmentedFile
extends SegmentedFile {
    final FileCacheService.CacheKey cacheKey;

    protected PoolingSegmentedFile(Cleanup cleanup, String path, long length) {
        this(cleanup, path, length, length);
    }

    protected PoolingSegmentedFile(Cleanup cleanup, String path, long length, long onDiskLength) {
        super(cleanup, path, length, onDiskLength);
        this.cacheKey = cleanup.cacheKey;
    }

    public PoolingSegmentedFile(PoolingSegmentedFile copy) {
        super(copy);
        this.cacheKey = copy.cacheKey;
    }

    @Override
    public FileDataInput getSegment(long position) {
        RandomAccessReader reader = FileCacheService.instance.get(this.cacheKey);
        if (reader == null) {
            reader = this.createPooledReader();
        }
        reader.seek(position);
        return reader;
    }

    protected RandomAccessReader createPooledReader() {
        return RandomAccessReader.open(new File(this.path), this.length, this);
    }

    public void recycle(RandomAccessReader reader) {
        FileCacheService.instance.put(this.cacheKey, reader);
    }

    protected static class Cleanup
    extends SegmentedFile.Cleanup {
        final FileCacheService.CacheKey cacheKey = new FileCacheService.CacheKey();

        protected Cleanup(String path) {
            super(path);
        }

        @Override
        public void tidy() throws Exception {
            FileCacheService.instance.invalidate(this.cacheKey, this.path);
        }
    }
}

